/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.openide.util.RequestProcessor;

public abstract class ConnectionDialogMediator {
    public static final String PROP_VALID = "valid";
    private final List connProgressListeners = new ArrayList();
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private boolean valid = true;
    private boolean connected = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionProgressListener(ConnectionProgressListener connectionProgressListener) {
        List list = this.connProgressListeners;
        synchronized (list) {
            this.connProgressListeners.add(connectionProgressListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void closeConnection() {
    }

    protected abstract boolean retrieveSchemas(SchemaPanel var1, DatabaseConnection var2, String var3);

    protected RequestProcessor.Task retrieveSchemasAsync(final SchemaPanel schemaPanel, final DatabaseConnection databaseConnection, final String string) {
        this.fireConnectionStarted();
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ConnectionDialogMediator.this.retrieveSchemas(schemaPanel, databaseConnection, string);
                ConnectionDialogMediator.this.fireConnectionFinished();
            }
        });
        return task;
    }

    protected void fireConnectionStarted() {
        Iterator iterator = this.connProgressListenersCopy();
        while (iterator.hasNext()) {
            ((ConnectionProgressListener)iterator.next()).connectionStarted();
        }
    }

    protected void fireConnectionStep(String string) {
        Iterator iterator = this.connProgressListenersCopy();
        while (iterator.hasNext()) {
            ((ConnectionProgressListener)iterator.next()).connectionStep(string);
        }
    }

    protected void fireConnectionFinished() {
        Iterator iterator = this.connProgressListenersCopy();
        while (iterator.hasNext()) {
            ((ConnectionProgressListener)iterator.next()).connectionFinished();
        }
    }

    protected void fireConnectionFailed() {
        Iterator iterator = this.connProgressListenersCopy();
        while (iterator.hasNext()) {
            ((ConnectionProgressListener)iterator.next()).connectionFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator connProgressListenersCopy() {
        ArrayList arrayList = null;
        List list = this.connProgressListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.connProgressListeners);
        }
        return arrayList.iterator();
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
        this.propChangeSupport.firePropertyChange(PROP_VALID, null, null);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
        this.propChangeSupport.firePropertyChange(PROP_VALID, null, null);
    }

    public boolean getValid() {
        return this.valid;
    }
}

