/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConnectionDialog {
    private transient ConnectionDialogMediator mediator;
    private transient JTabbedPane tabs;
    private transient Exception storedExp;
    final DialogDescriptor descriptor;
    final Dialog dialog;

    public ConnectionDialog(ConnectionDialogMediator connectionDialogMediator, FocusablePanel focusablePanel, JPanel jPanel, String string, HelpCtx helpCtx, ActionListener actionListener, ChangeListener changeListener) {
        if (focusablePanel.equals(jPanel)) {
            throw new IllegalArgumentException("The basePane and extendPane must not equal!");
        }
        this.mediator = connectionDialogMediator;
        ConnectionProgressListener connectionProgressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                ConnectionDialog.this.descriptor.setValid(false);
            }

            public void connectionStep(String string) {
            }

            public void connectionFinished() {
                ConnectionDialog.this.descriptor.setValid(true);
            }

            public void connectionFailed() {
                ConnectionDialog.this.descriptor.setValid(true);
            }
        };
        connectionDialogMediator.addConnectionProgressListener(connectionProgressListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string == null || string.equals("valid")) {
                    ConnectionDialog.this.updateValid();
                }
            }
        };
        connectionDialogMediator.addPropertyChangeListener(propertyChangeListener);
        this.tabs = new JTabbedPane(1);
        this.tabs.addChangeListener(changeListener);
        this.tabs.addTab(NbBundle.getMessage(ConnectionDialog.class, (String)"BasePanelTitle"), null, focusablePanel, NbBundle.getMessage(ConnectionDialog.class, (String)"BasePanelHint"));
        this.tabs.addTab(NbBundle.getMessage(ConnectionDialog.class, (String)"ExtendPanelTitle"), null, jPanel, NbBundle.getMessage(ConnectionDialog.class, (String)"ExtendPanelHint"));
        this.tabs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectionDialog.class, (String)"ACS_ConnectDialogA11yName"));
        this.tabs.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionDialog.class, (String)"ACS_ConnectDialogA11yDesc"));
        this.descriptor = new DialogDescriptor((Object)this.tabs, string, true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, actionListener);
        Object[] objectArray = new Object[]{DialogDescriptor.CANCEL_OPTION};
        this.descriptor.setClosingOptions(objectArray);
        this.updateValid();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        focusablePanel.initializeFocus();
        this.dialog.setVisible(false);
    }

    public Window getWindow() {
        return this.dialog;
    }

    public void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void setVisible(boolean bl) {
        this.dialog.setVisible(bl);
    }

    public void setSelectedComponent(JPanel jPanel) {
        this.tabs.setSelectedComponent(jPanel);
    }

    public void setException(Exception exception) {
        this.storedExp = exception;
    }

    public boolean isException() {
        return this.storedExp != null;
    }

    private void updateValid() {
        boolean bl = this.mediator.getValid();
        this.descriptor.setValid(bl);
        boolean bl2 = this.mediator.isConnected();
        this.tabs.setEnabledAt(1, bl && bl2);
    }

    public static abstract class FocusablePanel
    extends JPanel {
        public abstract void initializeFocus();
    }
}

