/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.lib.ddl.util.CommandBuffer;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;

public class AddTableColumnDDL {
    private Specification spec;
    private String schema;
    private String tablename;

    public AddTableColumnDDL(Specification specification, String string, String string2) {
        this.spec = specification;
        this.schema = string;
        this.tablename = string2;
    }

    public boolean execute(String string, ColumnItem columnItem) throws Exception {
        assert (columnItem != null);
        assert (string != null);
        CommandBuffer commandBuffer = new CommandBuffer();
        AddColumn addColumn = this.spec.createCommandAddColumn(this.tablename);
        addColumn.setObjectOwner(this.schema);
        TableColumn tableColumn = null;
        tableColumn = columnItem.isPrimaryKey() ? addColumn.createPrimaryKeyColumn(string) : (columnItem.isUnique() ? addColumn.createUniqueColumn(string) : (TableColumn)addColumn.createColumn(string));
        tableColumn.setColumnType(Specification.getType(columnItem.getType().getType()));
        tableColumn.setColumnSize(columnItem.getSize());
        tableColumn.setDecimalSize(columnItem.getScale());
        tableColumn.setNullAllowed(columnItem.allowsNull());
        if (columnItem.hasDefaultValue()) {
            tableColumn.setDefaultValue(columnItem.getDefaultValue());
        }
        if (columnItem.hasCheckConstraint()) {
            tableColumn.setCheckCondition(columnItem.getCheckConstraint());
        }
        commandBuffer.add(addColumn);
        if (columnItem.isIndexed() && !columnItem.isPrimaryKey() && !columnItem.isUnique()) {
            CreateIndex createIndex = this.spec.createCommandCreateIndex(this.tablename);
            createIndex.setIndexName(this.tablename + "_" + string + "_idx");
            createIndex.setIndexType(new String());
            createIndex.setObjectOwner(this.schema);
            createIndex.specifyNewColumn(string);
            commandBuffer.add(createIndex);
        }
        commandBuffer.execute();
        return commandBuffer.wasException();
    }
}

