/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectProgressDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConnectAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectAction.class.getName());
    ConnectionDialog dlg;
    boolean advancedPanel = false;
    boolean okPressed = false;

    public String getName() {
        return NbBundle.getMessage(ConnectAction.class, (String)"Connect");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        Lookup lookup;
        ConnectionNode connectionNode;
        boolean bl = false;
        if (nodeArray.length == 1 && (connectionNode = (ConnectionNode)((Object)(lookup = nodeArray[0].getLookup()).lookup(ConnectionNode.class))) != null) {
            DatabaseConnection databaseConnection = (DatabaseConnection)lookup.lookup(DatabaseConnection.class);
            bl = databaseConnection.getConnector().isDisconnected();
        }
        return bl;
    }

    public void performAction(Node[] nodeArray) {
        ConnectionNode connectionNode = (ConnectionNode)((Object)nodeArray[0].getLookup().lookup(ConnectionNode.class));
        new ConnectionDialogDisplayer().showDialog(connectionNode, false);
    }

    public static final class ConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        boolean advancedPanel = false;
        boolean okPressed = false;
        boolean failed = false;
        final ExceptionListener excListener = new ExceptionListener(){

            public void exceptionOccurred(Exception exception) {
                if (exception instanceof DDLException) {
                    LOGGER.log(Level.INFO, null, exception.getCause());
                } else {
                    LOGGER.log(Level.INFO, null, exception);
                }
                String string = null;
                if (exception instanceof ClassNotFoundException) {
                    string = MessageFormat.format(NbBundle.getMessage(ConnectAction.class, (String)"EXC_ClassNotFound"), exception.getMessage());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(DbUtilities.formatError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToConnect"), exception.getMessage()));
                    if (exception instanceof DDLException && exception.getCause() instanceof SQLException) {
                        for (SQLException sQLException = ((SQLException)exception.getCause()).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                            stringBuffer.append("\n\n" + sQLException.getMessage());
                        }
                    }
                    string = stringBuffer.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            }
        };

        public void showDialog(ConnectionNode connectionNode, boolean bl) {
            DatabaseConnection databaseConnection = (DatabaseConnection)connectionNode.getLookup().lookup(DatabaseConnection.class);
            this.showDialog(databaseConnection, bl);
        }

        public void showDialog(final DatabaseConnection databaseConnection, boolean bl) {
            final DatabaseConnector databaseConnector = databaseConnection.getConnector();
            String string = databaseConnection.getUser();
            String string2 = databaseConnection.getPassword();
            boolean bl2 = databaseConnection.rememberPassword();
            databaseConnection.addExceptionListener(this.excListener);
            if (string == null || !bl2 || bl) {
                final ConnectPanel connectPanel = new ConnectPanel(this, databaseConnection);
                final SchemaPanel schemaPanel = new SchemaPanel(this, databaseConnection);
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("argumentChanged")) {
                            schemaPanel.setSchemas(new Vector(), "");
                            schemaPanel.resetProgress();
                            try {
                                Connection connection = databaseConnection.getConnection();
                                if (DatabaseConnection.isVitalConnection(connection, null)) {
                                    connection.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                Exceptions.printStackTrace((Throwable)sQLException);
                            }
                        }
                    }
                };
                connectPanel.addPropertyChangeListener(propertyChangeListener);
                PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("connecting")) {
                            ConnectionDialogDisplayer.this.fireConnectionStarted();
                        }
                        if (propertyChangeEvent.getPropertyName().equals("failed")) {
                            ConnectionDialogDisplayer.this.fireConnectionFailed();
                        }
                        if (propertyChangeEvent.getPropertyName().equals("connected")) {
                            if (ConnectionDialogDisplayer.this.advancedPanel && !ConnectionDialogDisplayer.this.okPressed) {
                                if (ConnectionDialogDisplayer.this.retrieveSchemas(schemaPanel, databaseConnection, databaseConnection.getSchema())) {
                                    databaseConnection.setSchema(databaseConnection.getSchema());
                                }
                                ConnectionDialogDisplayer.this.dlg.setSelectedComponent(schemaPanel);
                                ConnectionDialogDisplayer.this.fireConnectionFinished();
                                return;
                            }
                            ConnectionDialogDisplayer.this.fireConnectionFinished();
                            databaseConnection.setSchema(databaseConnection.getSchema());
                            try {
                                databaseConnector.finishConnect(null, databaseConnection, databaseConnection.getConnection());
                            }
                            catch (DatabaseException databaseException) {
                                LOGGER.log(Level.INFO, null, databaseException);
                                DbUtilities.reportError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                return;
                            }
                            DatabaseConnection databaseConnection2 = ConnectionList.getDefault().getConnection(databaseConnection);
                            if (databaseConnection2 != null) {
                                databaseConnection2.setPassword(databaseConnection.getPassword());
                                databaseConnection2.setRememberPassword(databaseConnection.rememberPassword());
                            }
                            databaseConnection.setRememberPassword(connectPanel.rememberPassword());
                            if (ConnectionDialogDisplayer.this.dlg != null) {
                                ConnectionDialogDisplayer.this.dlg.close();
                            }
                            databaseConnection.fireConnectionComplete();
                        } else {
                            ConnectionDialogDisplayer.this.okPressed = false;
                        }
                    }
                };
                databaseConnection.addPropertyChangeListener(propertyChangeListener2);
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                            ConnectionDialogDisplayer.this.okPressed = true;
                            databaseConnection.setUser(connectPanel.getUser());
                            databaseConnection.setPassword(connectPanel.getPassword());
                            databaseConnection.setUser(connectPanel.getUser());
                            databaseConnection.setPassword(connectPanel.getPassword());
                            databaseConnection.setRememberPassword(connectPanel.rememberPassword());
                            if (!DatabaseConnection.isVitalConnection(databaseConnection.getConnection(), null)) {
                                databaseConnection.connectAsync();
                            } else {
                                databaseConnection.setSchema(schemaPanel.getSchema());
                                databaseConnection.setSchema(schemaPanel.getSchema());
                                try {
                                    databaseConnector.finishConnect(null, databaseConnection, databaseConnection.getConnection());
                                }
                                catch (DatabaseException databaseException) {
                                    Logger.getLogger("global").log(Level.INFO, null, databaseException);
                                    DbUtilities.reportError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                    return;
                                }
                                DatabaseConnection databaseConnection2 = ConnectionList.getDefault().getConnection(databaseConnection);
                                if (databaseConnection2 != null) {
                                    databaseConnection2.setPassword(databaseConnection.getPassword());
                                    databaseConnection2.setRememberPassword(connectPanel.rememberPassword());
                                }
                                databaseConnection.setRememberPassword(connectPanel.rememberPassword());
                                if (ConnectionDialogDisplayer.this.dlg != null) {
                                    ConnectionDialogDisplayer.this.dlg.close();
                                }
                                databaseConnection.fireConnectionComplete();
                            }
                            return;
                        }
                    }
                };
                ChangeListener changeListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(schemaPanel)) {
                            ConnectionDialogDisplayer.this.advancedPanel = true;
                            databaseConnection.setUser(connectPanel.getUser());
                            databaseConnection.setPassword(connectPanel.getPassword());
                        } else {
                            ConnectionDialogDisplayer.this.advancedPanel = false;
                        }
                    }
                };
                this.dlg = new ConnectionDialog(this, connectPanel, schemaPanel, connectPanel.getTitle(), new HelpCtx("db_save_password"), actionListener, changeListener);
                this.dlg.setVisible(true);
            } else {
                try {
                    DialogDescriptor dialogDescriptor = null;
                    ProgressHandle progressHandle = null;
                    progressHandle = ProgressHandleFactory.createHandle((String)"handle");
                    JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                    jComponent.setPreferredSize(new Dimension(350, 20));
                    ConnectProgressDialog connectProgressDialog = new ConnectProgressDialog(jComponent);
                    connectProgressDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectAction.class, (String)"ACS_ConnectingDialogTextA11yDesc"));
                    dialogDescriptor = new DialogDescriptor((Object)connectProgressDialog, NbBundle.getMessage(ConnectAction.class, (String)"ConnectingDialogTitle"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
                    final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (propertyChangeEvent.getPropertyName().equals("connected")) {
                                try {
                                    databaseConnector.finishConnect(null, databaseConnection, databaseConnection.getConnection());
                                    if (dialog == null) return;
                                    dialog.setVisible(false);
                                    return;
                                }
                                catch (DatabaseException databaseException) {
                                    LOGGER.log(Level.INFO, null, databaseException);
                                    DbUtilities.reportError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                    return;
                                }
                            } else {
                                if (!propertyChangeEvent.getPropertyName().equals("failed")) return;
                                if (dialog != null) {
                                    dialog.setVisible(false);
                                }
                                ConnectionDialogDisplayer.this.failed = true;
                            }
                        }
                    };
                    this.failed = false;
                    databaseConnection.addPropertyChangeListener(propertyChangeListener);
                    databaseConnection.connectAsync();
                    progressHandle.start();
                    progressHandle.switchToIndeterminate();
                    dialog.setVisible(true);
                    progressHandle.finish();
                    dialog.dispose();
                    if (this.failed) {
                        this.showDialog(databaseConnection, true);
                    } else {
                        databaseConnection.fireConnectionComplete();
                    }
                }
                catch (Exception exception) {
                    String string3 = MessageFormat.format(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToConnect"), exception.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 0));
                    this.showDialog(databaseConnection, true);
                }
            }
            databaseConnection.removeExceptionListener(this.excListener);
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.fireConnectionStep(NbBundle.getMessage(ConnectAction.class, (String)"ConnectionProgress_Schemas"));
            Vector<String> vector = new Vector<String>();
            try {
                ResultSet resultSet;
                DatabaseMetaData databaseMetaData = databaseConnection.getConnection().getMetaData();
                if (databaseMetaData.supportsSchemasInTableDefinitions() && (resultSet = databaseMetaData.getSchemas()) != null) {
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1).trim());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string2 = NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableObtainSchemas", (Object)sQLException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
            return schemaPanel.setSchemas(vector, string);
        }
    }
}

