/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.AddIndexDialog;
import org.netbeans.modules.db.explorer.node.IndexListNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class AddIndexAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(AddIndexAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(AddIndexAction.class, (String)"AddIndex");
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray.length == 1) {
            IndexListNode indexListNode = (IndexListNode)((Object)nodeArray[0].getLookup().lookup(IndexListNode.class));
            bl = indexListNode != null;
        }
        return bl;
    }

    protected void performAction(Node[] nodeArray) {
        final IndexListNode indexListNode = (IndexListNode)((Object)nodeArray[0].getLookup().lookup(IndexListNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                AddIndexAction.this.perform(indexListNode);
            }
        });
    }

    private void perform(final IndexListNode indexListNode) {
        try {
            DatabaseConnection databaseConnection = (DatabaseConnection)indexListNode.getLookup().lookup(DatabaseConnection.class);
            DatabaseConnector databaseConnector = databaseConnection.getConnector();
            String string = indexListNode.getTableName();
            String string2 = indexListNode.getSchemaName();
            String string3 = indexListNode.getCatalogName();
            if (string2 == null) {
                string2 = string3;
            }
            if (string3 == null) {
                string3 = string2;
            }
            Specification specification = databaseConnector.getDatabaseSpecification();
            DriverSpecification driverSpecification = databaseConnector.getDriverSpecification(string3);
            Vector<String> vector = new Vector<String>(5);
            driverSpecification.getColumns(string, "%");
            ResultSet resultSet = driverSpecification.getResultSet();
            HashMap hashMap = new HashMap();
            while (resultSet.next()) {
                hashMap = driverSpecification.getRow();
                vector.add((String)hashMap.get(new Integer(4)));
                hashMap.clear();
            }
            resultSet.close();
            if (vector.size() == 0) {
                throw new Exception(NbBundle.getMessage(AddIndexAction.class, (String)"EXC_NoUsableColumnInPlace"));
            }
            AddIndexDialog addIndexDialog = new AddIndexDialog(vector, specification, string, string2);
            addIndexDialog.setIndexName(string + "_idx");
            if (addIndexDialog.run()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Object object = indexListNode.getParentNode();
                        if (object == null) {
                            object = indexListNode;
                        }
                        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{object});
                    }
                });
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, exception.getMessage(), exception);
            DbUtilities.reportError(NbBundle.getMessage(AddIndexAction.class, (String)"ERR_UnableToAddIndex"), exception.getMessage());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddIndexAction.class);
    }
}

