/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.beans.PropertyVetoException;
import java.util.Set;
import org.netbeans.modules.ide.ergonomics.Utilities;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.util.actions.CookieAction;

public final class OpenAdvancedAction
extends CookieAction {
    private static Set<FileObject> candidates = new WeakSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCandidate(FileObject fileObject) {
        Set<FileObject> set = candidates;
        synchronized (set) {
            candidates.add(fileObject);
        }
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        final DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        FileObject fileObject = FileUtil.getConfigFile((String)("Loaders/" + dataObject.getPrimaryFile().getMIMEType() + "/Factories/Ergonomics.instance"));
        if (fileObject == null) {
            return;
        }
        final FeatureInfo featureInfo = FoDFileSystem.getInstance().whichProvides(fileObject);
        if (featureInfo == null || featureInfo.isEnabled()) {
            return;
        }
        RequestProcessor.Task task = FeatureManager.getInstance().create(new Runnable(){

            public void run() {
                boolean bl = Utilities.featureNotFoundDialog(featureInfo, NbBundle.getMessage(OpenAdvancedAction.class, (String)"CTL_OpenAdvanced"));
                if (bl) {
                    try {
                        OpenCookie openCookie;
                        dataObject.setValid(false);
                        DataObject dataObject2 = DataObject.find((FileObject)dataObject.getPrimaryFile());
                        if (dataObject2 != dataObject && (openCookie = (OpenCookie)dataObject2.getLookup().lookup(OpenCookie.class)) != null) {
                            openCookie.open();
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Exceptions.printStackTrace((Throwable)propertyVetoException);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    }
                }
            }
        });
        task.schedule(0);
    }

    protected boolean enable(Node[] nodeArray) {
        if (!super.enable(nodeArray) || nodeArray.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        return candidates.contains(dataObject.getPrimaryFile());
    }

    protected int mode() {
        return 1;
    }

    public String getName() {
        return NbBundle.getMessage(OpenAdvancedAction.class, (String)"CTL_OpenAdvancedAction");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

