/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.ui.customizer.SpringCustomizerPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CustomizerCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    public ProjectCustomizer.Category createCategory(Lookup lookup) {
        Project project = CustomizerCategoryProvider.getProject(lookup);
        ConfigFileManager configFileManager = CustomizerCategoryProvider.getConfigFileManager(project);
        if (configFileManager.getConfigFiles().size() <= 0 && !CustomizerCategoryProvider.hasSpringOnClassPath(project)) {
            return null;
        }
        String string = NbBundle.getMessage(CustomizerCategoryProvider.class, (String)"LBL_SpringFramework");
        return ProjectCustomizer.Category.create((String)"SpringFramework", (String)string, null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
        Project project = CustomizerCategoryProvider.getProject(lookup);
        ConfigFileManager configFileManager = CustomizerCategoryProvider.getConfigFileManager(project);
        SpringCustomizerPanel springCustomizerPanel = new SpringCustomizerPanel(project, configFileManager.getConfigFiles(), configFileManager.getConfigFileGroups());
        CategoryListener categoryListener = new CategoryListener(configFileManager, springCustomizerPanel);
        category.setOkButtonListener((ActionListener)categoryListener);
        category.setStoreListener((ActionListener)categoryListener);
        return springCustomizerPanel;
    }

    private static Project getProject(Lookup lookup) {
        Project project = (Project)lookup.lookup(Project.class);
        if (project == null) {
            throw new IllegalStateException("The lookup " + lookup + " does not contain a Project");
        }
        return project;
    }

    private static ConfigFileManager getConfigFileManager(Project project) {
        ProjectSpringScopeProvider projectSpringScopeProvider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        assert (projectSpringScopeProvider != null);
        return projectSpringScopeProvider.getSpringScope().getConfigFileManager();
    }

    private static boolean hasSpringOnClassPath(Project project) {
        SourceGroup[] sourceGroupArray;
        for (SourceGroup sourceGroup : sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
            if (classPath == null || !SpringUtilities.containsSpring(classPath)) continue;
            return true;
        }
        return false;
    }

    private static final class CategoryListener
    implements ActionListener {
        private final ConfigFileManager manager;
        private final SpringCustomizerPanel panel;
        private volatile List<File> files;
        private volatile List<ConfigFileGroup> groups;

        public CategoryListener(ConfigFileManager configFileManager, SpringCustomizerPanel springCustomizerPanel) {
            this.manager = configFileManager;
            this.panel = springCustomizerPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.files == null || this.groups == null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.files = this.panel.getConfigFiles();
                this.groups = this.panel.getConfigFileGroups();
            } else {
                this.manager.mutex().writeAccess(new Runnable(){

                    public void run() {
                        CategoryListener.this.manager.putConfigFilesAndGroups(CategoryListener.this.files, CategoryListener.this.groups);
                    }
                });
            }
        }
    }
}

