/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.SpringConfigModelAccessor;
import org.netbeans.modules.spring.beans.model.ConfigModelSpringBeans;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelController;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringConfigModelController {
    private final ConfigFileGroup configFileGroup;
    private final Map<File, SpringConfigFileModelController> file2Controller = new HashMap<File, SpringConfigFileModelController>();
    private ConfigModelSpringBeans readAccess;
    private boolean writeAccess;

    public SpringConfigModelController(SpringConfigFileModelManager springConfigFileModelManager, ConfigFileGroup configFileGroup) {
        this.configFileGroup = configFileGroup;
        for (File file : configFileGroup.getFiles()) {
            SpringConfigFileModelController springConfigFileModelController = springConfigFileModelManager.getFileModelController(file);
            if (springConfigFileModelController == null) continue;
            this.file2Controller.put(file, springConfigFileModelController);
        }
    }

    public ConfigFileGroup getConfigFileGroup() {
        return this.configFileGroup;
    }

    public void runReadAction(final Action<SpringBeans> action) throws IOException {
        try {
            ExclusiveAccess.getInstance().runSyncTask(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    SpringConfigModelController.this.runReadActionExclusively(action);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            throw (IOException)iOException.initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReadActionExclusively(Action<SpringBeans> action) throws IOException {
        if (this.writeAccess) {
            throw new IllegalStateException("Already in write access.");
        }
        boolean bl = this.readAccess == null;
        try {
            if (bl) {
                this.readAccess = new ConfigModelSpringBeans(this.computeSpringBeanSources(null));
            }
            action.run(this.readAccess);
        }
        finally {
            if (bl) {
                this.readAccess = null;
            }
        }
    }

    public void runDocumentAction(final Action<SpringConfigModel.DocumentAccess> action) throws IOException {
        try {
            ExclusiveAccess.getInstance().runSyncTask(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    SpringConfigModelController.this.runDocumentActionExclusively(action);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            throw (IOException)iOException.initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDocumentActionExclusively(Action<SpringConfigModel.DocumentAccess> action) throws IOException {
        if (this.readAccess != null) {
            throw new IllegalStateException("Already in read access.");
        }
        if (this.writeAccess) {
            throw new IllegalStateException("Reentrant write access not supported");
        }
        this.writeAccess = true;
        try {
            for (File file : this.file2Controller.keySet()) {
                Map<File, SpringBeanSource> map = this.computeSpringBeanSources(file);
                SpringConfigFileModelController springConfigFileModelController = this.file2Controller.get(file);
                SpringConfigFileModelController.LockedDocument lockedDocument = springConfigFileModelController.getLockedDocument();
                if (lockedDocument == null) continue;
                lockedDocument.lock();
                try {
                    map.put(file, lockedDocument.getBeanSource());
                    ConfigModelSpringBeans configModelSpringBeans = new ConfigModelSpringBeans(map);
                    SpringConfigModel.DocumentAccess documentAccess = SpringConfigModelAccessor.getDefault().createDocumentAccess(configModelSpringBeans, file, lockedDocument);
                    action.run(documentAccess);
                }
                finally {
                    lockedDocument.unlock();
                }
            }
        }
        finally {
            this.writeAccess = false;
        }
    }

    private Map<File, SpringBeanSource> computeSpringBeanSources(File file) throws IOException {
        HashMap<File, SpringBeanSource> hashMap = new HashMap<File, SpringBeanSource>();
        for (Map.Entry<File, SpringConfigFileModelController> entry : this.file2Controller.entrySet()) {
            File file2 = entry.getKey();
            if (file2.equals(file)) continue;
            hashMap.put(entry.getKey(), entry.getValue().getUpToDateBeanSource());
        }
        return hashMap;
    }
}

