/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelController;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBeanSource;
import org.netbeans.modules.spring.util.fcs.FileChangeSupport;
import org.netbeans.modules.spring.util.fcs.FileChangeSupportEvent;
import org.netbeans.modules.spring.util.fcs.FileChangeSupportListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SpringConfigFileModelManager {
    private final Map<File, SpringConfigFileModelController> file2Controller = Collections.synchronizedMap(new HashMap());
    private FileListener fileListener;
    private EditorRegistryListener editorListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringConfigFileModelController getFileModelController(File file) {
        Object object = this;
        synchronized (object) {
            if (this.fileListener == null) {
                this.fileListener = new FileListener();
                this.editorListener = new EditorRegistryListener();
                this.editorListener.initialize();
            }
        }
        object = this.file2Controller;
        synchronized (object) {
            SpringConfigFileModelController springConfigFileModelController = this.file2Controller.get(file);
            if (springConfigFileModelController == null) {
                springConfigFileModelController = new SpringConfigFileModelController(file, new ConfigFileSpringBeanSource());
                FileChangeSupport.DEFAULT.addListener(this.fileListener, file);
                this.file2Controller.put(file, springConfigFileModelController);
            }
            return springConfigFileModelController;
        }
    }

    private void notifyFileChanged(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return;
        }
        this.notifyFileChanged(fileObject, file);
    }

    private void notifyFileDeleted(File file) {
    }

    private void notifyFileChanged(FileObject fileObject, File file) {
        SpringConfigFileModelController springConfigFileModelController = this.file2Controller.get(file);
        if (springConfigFileModelController != null) {
            springConfigFileModelController.notifyChange(fileObject);
        }
    }

    private final class EditorRegistryListener
    implements PropertyChangeListener,
    DocumentListener {
        private Document currentDocument;

        public synchronized void initialize() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            Document document = this.currentDocument = jTextComponent != null ? jTextComponent.getDocument() : null;
            if (this.currentDocument != null) {
                this.currentDocument.addDocumentListener(this);
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Document document;
            assert (SwingUtilities.isEventDispatchThread());
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            Document document2 = document = jTextComponent != null ? jTextComponent.getDocument() : null;
            if (this.currentDocument == document) {
                return;
            }
            if (this.currentDocument != null) {
                this.currentDocument.removeDocumentListener(this);
            }
            this.currentDocument = document;
            if (this.currentDocument != null) {
                this.currentDocument.addDocumentListener(this);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.notify(documentEvent.getDocument());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.notify(documentEvent.getDocument());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.notify(documentEvent.getDocument());
        }

        private void notify(Document document) {
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            if (fileObject == null) {
                return;
            }
            if (!"text/x-springconfig+xml".equals(fileObject.getMIMEType())) {
                return;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                return;
            }
            SpringConfigFileModelManager.this.notifyFileChanged(fileObject, file);
        }
    }

    private final class FileListener
    implements FileChangeSupportListener {
        private FileListener() {
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            SpringConfigFileModelManager.this.notifyFileChanged(fileChangeSupportEvent.getPath());
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            SpringConfigFileModelManager.this.notifyFileChanged(fileChangeSupportEvent.getPath());
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            SpringConfigFileModelManager.this.notifyFileDeleted(fileChangeSupportEvent.getPath());
        }
    }
}

