/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBeanSource;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;

public class SpringConfigFileModelController {
    private static final Logger LOGGER = Logger.getLogger(SpringConfigFileModelController.class.getName());
    private static final int DELAY = 500;
    private final ConfigFileSpringBeanSource beanSource;
    private final File file;
    private boolean parsedAtLeastOnce;
    private ExclusiveAccess.AsyncTask currentUpdateTask;
    private FileObject currentFile;

    public SpringConfigFileModelController(File file, ConfigFileSpringBeanSource configFileSpringBeanSource) {
        this.file = file;
        this.beanSource = configFileSpringBeanSource;
    }

    public SpringBeanSource getUpToDateBeanSource() throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        FileObject fileObject = this.getFileToMakeUpToDate();
        if (fileObject != null) {
            this.doParse(fileObject, false);
        }
        return this.beanSource;
    }

    public LockedDocument getLockedDocument() throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        FileObject fileObject = this.getFileToMakeUpToDate();
        if (fileObject == null) {
            fileObject = FileUtil.toFileObject((File)this.file);
        }
        if (fileObject != null) {
            return new LockedDocument(fileObject);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getFileToMakeUpToDate() throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        FileObject fileObject = null;
        SpringConfigFileModelController springConfigFileModelController = this;
        synchronized (springConfigFileModelController) {
            if (this.currentUpdateTask == null || this.currentUpdateTask.isFinished()) {
                if (!this.parsedAtLeastOnce) {
                    fileObject = FileUtil.toFileObject((File)this.file);
                }
            } else {
                fileObject = this.currentFile;
            }
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParse(FileObject fileObject, boolean bl) throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        BaseDocument baseDocument = (BaseDocument)SpringConfigFileModelController.getEditorCookie(fileObject).openDocument();
        baseDocument.readLock();
        try {
            this.doParse(fileObject, baseDocument, bl);
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParse(FileObject fileObject, BaseDocument baseDocument, boolean bl) throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        this.beanSource.parse(baseDocument);
        SpringConfigFileModelController springConfigFileModelController = this;
        synchronized (springConfigFileModelController) {
            if (!this.parsedAtLeastOnce) {
                this.parsedAtLeastOnce = true;
            }
            if (!bl && fileObject.equals(this.currentFile)) {
                LOGGER.log(Level.FINE, "Canceling update task for " + this.currentFile);
                this.currentUpdateTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(FileObject fileObject) {
        assert (fileObject != null);
        LOGGER.log(Level.FINE, "Scheduling update for {0}", fileObject);
        SpringConfigFileModelController springConfigFileModelController = this;
        synchronized (springConfigFileModelController) {
            if (fileObject != this.currentFile) {
                if (this.currentUpdateTask != null) {
                    this.currentUpdateTask.cancel();
                }
                this.currentFile = fileObject;
                this.currentUpdateTask = ExclusiveAccess.getInstance().createAsyncTask(new Updater(fileObject));
            }
            this.currentUpdateTask.schedule(500);
        }
    }

    private static EditorCookie getEditorCookie(FileObject fileObject) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            throw new IllegalStateException("File " + fileObject + " does not have an EditorCookie.");
        }
        return editorCookie;
    }

    private final class Updater
    implements Runnable {
        private final FileObject configFile;

        public Updater(FileObject fileObject) {
            this.configFile = fileObject;
        }

        public void run() {
            LOGGER.log(Level.FINE, "Running scheduled update for file {0}", this.configFile);
            assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
            try {
                SpringConfigFileModelController.this.doParse(this.configFile, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public final class LockedDocument {
        private final FileObject fo;
        private final CloneableEditorSupport editor;
        final BaseDocument document;
        private final AtomicBoolean locked = new AtomicBoolean();
        private final AtomicBoolean unlocked = new AtomicBoolean();

        public LockedDocument(FileObject fileObject) throws IOException {
            this.fo = fileObject;
            this.editor = (CloneableEditorSupport)SpringConfigFileModelController.getEditorCookie(fileObject);
            this.document = (BaseDocument)this.editor.openDocument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() throws IOException {
            if (!this.locked.getAndSet(true)) {
                this.document.atomicLock();
                boolean bl = false;
                try {
                    SpringConfigFileModelController.this.doParse(this.fo, this.document, false);
                    bl = true;
                }
                finally {
                    if (!bl) {
                        this.document.atomicUnlock();
                    }
                }
            }
        }

        public void unlock() throws IOException {
            assert (this.locked.get());
            if (!this.unlocked.getAndSet(true)) {
                this.document.atomicUnlock();
            }
        }

        public BaseDocument getDocument() {
            assert (this.locked.get());
            return this.document;
        }

        public SpringBeanSource getBeanSource() throws IOException {
            assert (this.locked.get());
            return SpringConfigFileModelController.this.beanSource;
        }

        public PositionRef createPositionRef(int n, Position.Bias bias) {
            assert (this.locked.get());
            return this.editor.createPositionRef(n, bias);
        }
    }
}

