/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletorUtils {
    public static final Acceptor JAVA_IDENTIFIER_ACCEPTOR = new Acceptor(){

        public boolean accept(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Acceptor CHARACTER_STRING_ACCEPTOR = new Acceptor(){

        public boolean accept(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isLetter(c)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Acceptor BEAN_NAME_ACCEPTOR = new Acceptor(){

        public boolean accept(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Acceptor RESOURCE_PATH_ELEMENT_ACCEPTOR = new Acceptor(){

        public boolean accept(String string) {
            return !string.contains("/");
        }
    };
    public static final Acceptor P_ATTRIBUTE_ACCEPTOR = new Acceptor(){

        public boolean accept(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isWhitespace(c)) {
                    return false;
                }
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == ':') continue;
                return false;
            }
            return true;
        }
    };

    private CompletorUtils() {
    }

    public static boolean canFilter(Document document, int n, int n2, int n3, Acceptor acceptor) {
        if (n3 == -1 || n2 < n) {
            return false;
        }
        try {
            String string = document.getText(n3, n2 - n3);
            return acceptor.accept(string);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return false;
        }
    }

    public static List<SpringXMLConfigCompletionItem> filter(List<SpringXMLConfigCompletionItem> list, Document document, int n, int n2, int n3) {
        if (n3 == -1) {
            return Collections.emptyList();
        }
        ArrayList<SpringXMLConfigCompletionItem> arrayList = new ArrayList();
        try {
            String string = document.getText(n3, n2 - n3);
            for (SpringXMLConfigCompletionItem springXMLConfigCompletionItem : list) {
                if (!((Object)springXMLConfigCompletionItem.getInsertPrefix()).toString().startsWith(string)) continue;
                arrayList.add(springXMLConfigCompletionItem);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            arrayList = Collections.emptyList();
        }
        return arrayList;
    }

    public static interface Acceptor {
        public boolean accept(String var1);
    }
}

