/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaType;
import org.netbeans.modules.websvc.manager.swing.outline.DefaultOutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.Outline;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;
import org.netbeans.modules.websvc.manager.ui.MethodExceptionDialog;
import org.netbeans.modules.websvc.manager.ui.MethodTaskListener;
import org.netbeans.modules.websvc.manager.ui.NodeHelper;
import org.netbeans.modules.websvc.manager.ui.ParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.ResultCellEditor;
import org.netbeans.modules.websvc.manager.ui.ResultRowModel;
import org.netbeans.modules.websvc.manager.ui.TypeCellEditor;
import org.netbeans.modules.websvc.manager.ui.TypeDataProvider;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.TypeRowModel;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.netbeans.modules.websvc.saas.util.TypeUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TestWebServiceMethodDlg
extends JPanel
implements ActionListener,
MethodTaskListener {
    private Dialog dialog;
    private DialogDescriptor dlg = null;
    private String okString = NbBundle.getMessage(this.getClass(), (String)"CLOSE");
    private URLClassLoader runtimeClassLoader;
    private DefaultMutableTreeNode parameterRootNode = new DefaultMutableTreeNode();
    private DefaultMutableTreeNode resultRootNode = new DefaultMutableTreeNode();
    private final WsdlSaas wsData;
    private final WSPort port;
    private final JavaMethod method;
    private MethodTask methodTask;
    private JPanel btnPanel;
    private JButton btnSubmit;
    private JSplitPane jSplitPane1;
    private JLabel lblParameters;
    private JLabel lblResults;
    private JLabel lblTitle;
    private JPanel pnlLabel;
    private JPanel pnlParameter;
    private JPanel pnlResults;
    private JScrollPane scrollPaneParameter;
    private JScrollPane scrollPaneResults;
    private JButton okButton = new JButton();
    private Outline parameterOutline;
    private Outline resultOutline;
    private TypeRowModel rowModel;
    private Cursor normalCursor;

    public TestWebServiceMethodDlg(WsdlSaasMethod wsdlSaasMethod) {
        this.method = wsdlSaasMethod.getJavaMethod();
        this.wsData = wsdlSaasMethod.getSaas();
        this.port = wsdlSaasMethod.getWsdlPort();
        this.initComponents();
        this.myInitComponents();
        this.lblTitle.setText(NbBundle.getMessage(this.getClass(), (String)"TEST_WEBSVC_LABEL") + " ");
    }

    private boolean isRPCEncoded(WsdlData wsdlData) {
        File file = new File(wsdlData.getWsdlFile());
        if (file != null) {
            try {
                file = file.getCanonicalFile();
                return file != null && JaxWsUtils.isRPCEncoded((URI)file.toURI());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    private URLClassLoader getRuntimeClassLoader() {
        if (null == this.runtimeClassLoader) {
            try {
                List list = null;
                WsdlData wsdlData = this.wsData.getWsdlData();
                boolean bl = this.isRPCEncoded(wsdlData);
                list = TypeUtil.buildClasspath(null, (!bl ? 1 : 0) != 0);
                WsdlServiceProxyDescriptor wsdlServiceProxyDescriptor = null;
                wsdlServiceProxyDescriptor = bl ? wsdlData.getJaxRpcDescriptor() : wsdlData.getJaxWsDescriptor();
                for (WsdlServiceProxyDescriptor.JarEntry jarEntry : wsdlServiceProxyDescriptor.getJars()) {
                    if (!jarEntry.getType().equals("proxy")) continue;
                    File file = new File(wsdlServiceProxyDescriptor.getXmlDescriptorFile().getParent(), jarEntry.getName());
                    File file2 = this.createTempCopy(file);
                    list.add(file2.toURI().toURL());
                }
                URL[] uRLArray = list.toArray(new URL[0]);
                this.runtimeClassLoader = new URLClassLoader(uRLArray);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                ErrorManager.getDefault().log(this.getClass().getName() + ":IOException=" + iOException);
                return null;
            }
        }
        return this.runtimeClassLoader;
    }

    private File createTempCopy(File file) {
        try {
            File file2 = File.createTempFile("proxyjar", "jar");
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
            fileChannel.close();
            fileChannel2.close();
            return file2;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
            return null;
        }
    }

    public void displayDialog() {
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"TEST_WEB_SERVICE_METHOD"), false, 2, DialogDescriptor.OK_OPTION, 0, this.getHelpCtx(), (ActionListener)this);
        this.dlg.setOptions(new Object[]{this.okButton});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        final TestWebServiceMethodDlg testWebServiceMethodDlg = this;
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TestWebServiceMethodDlg.this.btnSubmit.requestFocus();
                        testWebServiceMethodDlg.getRootPane().setDefaultButton(TestWebServiceMethodDlg.this.btnSubmit);
                    }
                });
            }
        });
        this.normalCursor = this.dialog.getCursor();
        BusyMouseAdapter busyMouseAdapter = new BusyMouseAdapter(this.normalCursor);
        this.okButton.addMouseListener(busyMouseAdapter);
        this.dialog.show();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_server_nav_test_websvcdb");
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.pnlParameter = new JPanel();
        this.pnlLabel = new JPanel();
        this.lblTitle = new JLabel();
        this.lblParameters = new JLabel();
        this.scrollPaneParameter = new JScrollPane();
        this.btnPanel = new JPanel();
        this.btnSubmit = new JButton();
        this.pnlResults = new JPanel();
        this.lblResults = new JLabel();
        this.scrollPaneResults = new JScrollPane();
        this.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.main.ACC_desc"));
        this.setPreferredSize(new Dimension(600, 450));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.jsplintPane1.ACC_desc"));
        this.pnlParameter.setBorder(BorderFactory.createEmptyBorder(12, 12, 5, 12));
        this.pnlParameter.setLayout(new BorderLayout());
        this.pnlLabel.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.pnlLabel.ACC_desc"));
        this.pnlLabel.setLayout(new GridLayout(2, 0));
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(this.lblTitle.getFont().getStyle() | 1, this.lblTitle.getFont().getSize() - 2));
        this.lblTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TEST_WEB_SERVICE_METHOD"));
        this.lblTitle.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.lblTitle.ACC_desc"));
        this.pnlLabel.add(this.lblTitle);
        this.lblParameters.setFont(this.lblParameters.getFont().deriveFont((float)this.lblParameters.getFont().getSize() - 4.0f));
        this.lblParameters.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblParameters, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TEST_WEBSVC_INSTRUCTIONS"));
        this.lblParameters.setToolTipText(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.jLabel1.ACC_desc"));
        this.pnlLabel.add(this.lblParameters);
        this.pnlParameter.add((Component)this.pnlLabel, "North");
        this.pnlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.pnlLabel.ACC_name"));
        this.scrollPaneParameter.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.scrollPaneParameter.ACC_desc"));
        this.pnlParameter.add((Component)this.scrollPaneParameter, "Center");
        this.scrollPaneParameter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.scrollPaneParameter.ACC_name"));
        this.btnPanel.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.btnPanel.ACC_desc"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSubmit, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"BUTTON_SUBMIT"));
        this.btnSubmit.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.btnSubmit.ACC_desc"));
        this.btnSubmit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestWebServiceMethodDlg.this.btnSubmitActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.btnSubmit);
        this.pnlParameter.add((Component)this.btnPanel, "South");
        this.btnPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.btnPanel.ACC_name"));
        this.jSplitPane1.setLeftComponent(this.pnlParameter);
        this.pnlParameter.getAccessibleContext().setAccessibleName("null");
        this.pnlParameter.getAccessibleContext().setAccessibleDescription("null");
        this.pnlResults.setBorder(BorderFactory.createEmptyBorder(5, 12, 5, 12));
        this.pnlResults.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.pnResults.ACC_desc"));
        this.pnlResults.setLayout(new BorderLayout(0, 5));
        this.lblResults.setHorizontalAlignment(2);
        this.lblResults.setLabelFor(this.scrollPaneResults);
        Mnemonics.setLocalizedText((JLabel)this.lblResults, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"RESULTS"));
        this.lblResults.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.lblResults.ACC_desc"));
        this.pnlResults.add((Component)this.lblResults, "North");
        this.scrollPaneResults.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.scrollPaneResults.ACC_desc"));
        this.pnlResults.add((Component)this.scrollPaneResults, "Center");
        this.scrollPaneResults.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.scrollPaneResults.ACC_name"));
        this.jSplitPane1.setRightComponent(this.pnlResults);
        this.pnlResults.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.pnResults.ACC_name"));
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.jsplintPane1.ACC_name"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.main.ACC_name"));
    }

    private void btnSubmitActionPerformed(ActionEvent actionEvent) {
        this.dialog.setCursor(new Cursor(3));
        this.invokeMethod();
    }

    private void invokeMethod() {
        Object object;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; null != this.getParamterRootNode() && i < this.getParamterRootNode().getChildCount(); ++i) {
            object = (DefaultMutableTreeNode)this.getParamterRootNode().getChildAt(i);
            TypeNodeData typeNodeData = (TypeNodeData)((DefaultMutableTreeNode)object).getUserObject();
            Object object2 = typeNodeData.getTypeValue();
            linkedList.add(object2);
        }
        String string = null;
        string = this.isRPCEncoded(this.wsData.getWsdlData()) ? this.wsData.getWsdlModel().getJavaName() + "_Impl" : this.wsData.getWsdlModel().getJavaName();
        this.methodTask = new MethodTask(string, linkedList, this.method, this.getRuntimeClassLoader());
        this.methodTask.registerListener(this);
        object = new Thread(this.methodTask);
        ((Thread)object).start();
    }

    public void methodFinished(Object object, LinkedList linkedList) {
        this.dialog.setCursor(this.normalCursor);
        this.showResults(object);
        for (int i = 0; null != this.getParamterRootNode() && i < this.getParamterRootNode().getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParamterRootNode().getChildAt(i);
            TypeNodeData typeNodeData = (TypeNodeData)defaultMutableTreeNode.getUserObject();
            typeNodeData.setTypeValue(linkedList.get(i));
            String string = typeNodeData.getTypeClass();
            if (!ReflectionHelper.isHolder(string)) continue;
            ((ParameterTreeNode)((Object)defaultMutableTreeNode)).updateChildren();
        }
        this.parameterOutline.tableChanged(new TableModelEvent((TableModel)((Object)this.parameterOutline.getOutlineModel().getRowNodeModel())));
    }

    private void showResults(Object object) {
        try {
            this.resultOutline = this.loadResultTreeTable(this.method, object);
            this.resultOutline.getTableHeader().setReorderingAllowed(false);
            this.resultOutline.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.resultOutline.ACC_name"));
            this.resultOutline.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.resultOutline.ACC_desc"));
            this.addFocusListener(this.resultOutline);
            this.lblResults.setLabelFor(this.resultOutline);
            this.scrollPaneResults.setViewportView(this.resultOutline);
        }
        catch (WebServiceReflectionException webServiceReflectionException) {
            Throwable throwable = webServiceReflectionException.getCause();
            ErrorManager.getDefault().notify(throwable);
            ErrorManager.getDefault().log(this.getClass().getName() + ": WebServiceReflectionException=" + throwable);
        }
    }

    private void myInitComponents() {
        this.okButton.setText(this.okString);
        if (null == this.method) {
            return;
        }
        try {
            NodeHelper.createInstance(this.getRuntimeClassLoader());
            this.parameterOutline = this.loadParameterTreeTable(this.method);
            this.scrollPaneParameter.setViewportView(this.parameterOutline);
            this.okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.okButton.ACC_name"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.okButton.ACC_desc"));
            this.okButton.setMnemonic(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.okButton.ACC_mnemonic").charAt(0));
            this.parameterOutline.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.parameterOutline.ACC_name"));
            this.parameterOutline.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.parameterOutline.ACC_desc"));
            this.lblParameters.setLabelFor(this.parameterOutline);
            this.addFocusListener(this.parameterOutline);
        }
        catch (WebServiceReflectionException webServiceReflectionException) {
            Throwable throwable = webServiceReflectionException.getCause();
            ErrorManager.getDefault().notify(throwable);
            ErrorManager.getDefault().log(this.getClass().getName() + ": WebServiceReflectionException=" + throwable);
        }
    }

    private void addFocusListener(final JTable jTable) {
        jTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Container container = jTable.getFocusCycleRootAncestor();
                FocusTraversalPolicy focusTraversalPolicy = jTable.getFocusTraversalPolicy();
                if (focusTraversalPolicy == null && container != null) {
                    focusTraversalPolicy = container.getFocusTraversalPolicy();
                }
                if (jTable.getRowCount() == 0 && focusTraversalPolicy != null) {
                    Component component = focusTraversalPolicy.getComponentAfter(container, jTable);
                    if (component != null && component == focusEvent.getOppositeComponent()) {
                        component = focusTraversalPolicy.getComponentBefore(container, jTable);
                    }
                    if (component != null) {
                        component.requestFocusInWindow();
                    }
                }
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    private DefaultMutableTreeNode getParamterRootNode() {
        return this.parameterRootNode;
    }

    private void setParameterRootNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.parameterRootNode = defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getResultRootNode() {
        return this.resultRootNode;
    }

    private void setResultRootNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.resultRootNode = defaultMutableTreeNode;
    }

    private Outline loadResultTreeTable(JavaMethod javaMethod, Object object) throws WebServiceReflectionException {
        if (null == javaMethod) {
            return null;
        }
        JavaType javaType = javaMethod.getReturnType();
        String string = javaType.getRealName();
        TypeNodeData typeNodeData = ReflectionHelper.createTypeData(string, object);
        DefaultMutableTreeNode defaultMutableTreeNode = NodeHelper.getInstance().createResultNodeFromData(typeNodeData);
        this.setResultRootNode(new DefaultMutableTreeNode());
        this.getResultRootNode().add(defaultMutableTreeNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.getResultRootNode());
        ResultRowModel resultRowModel = new ResultRowModel();
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel(defaultTreeModel, resultRowModel, false);
        outlineModel.setNodeColumnName(NbBundle.getMessage(this.getClass(), (String)"TYPE_COLUMN_NAME"));
        Outline outline = new Outline(outlineModel);
        ResultCellEditor resultCellEditor = new ResultCellEditor(this.runtimeClassLoader);
        outline.setDefaultEditor(Object.class, resultCellEditor);
        outline.setRootVisible(false);
        outline.setRenderDataProvider(new TypeDataProvider());
        return outline;
    }

    private Outline loadParameterTreeTable(JavaMethod javaMethod) throws WebServiceReflectionException {
        Object object;
        Object object2;
        Object object32;
        if (null == javaMethod) {
            return null;
        }
        List list = javaMethod.getParametersList();
        for (Object object32 : list) {
            object2 = object32.getType();
            object = object2.getRealName();
            String string = object32.getName();
            if (object32.isHolder()) {
                object = "javax.xml.ws.Holder<" + (String)object + ">";
            }
            TypeNodeData typeNodeData = ReflectionHelper.createTypeData((String)object, string);
            typeNodeData.setTypeValue(NodeHelper.getInstance().getParameterDefaultValue(typeNodeData));
            if (object32.isHolder()) {
                if (object32.isIN()) {
                    typeNodeData.setHolderType(0);
                }
                if (object32.isOUT()) {
                    typeNodeData.setHolderType(1);
                }
                if (object32.isINOUT()) {
                    typeNodeData.setHolderType(2);
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = NodeHelper.getInstance().createNodeFromData(typeNodeData);
            this.getParamterRootNode().add(defaultMutableTreeNode);
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.getParamterRootNode());
        this.rowModel = new TypeRowModel(this.getRuntimeClassLoader());
        object32 = DefaultOutlineModel.createOutlineModel(defaultTreeModel, this.rowModel, false);
        object32.setNodeColumnName(NbBundle.getMessage(this.getClass(), (String)"TYPE_COLUMN_NAME"));
        object2 = new Outline((OutlineModel)object32);
        object = new TypeCellEditor(this.getRuntimeClassLoader());
        ((JTable)object2).setDefaultEditor(Object.class, (TableCellEditor)object);
        ((Outline)object2).setRootVisible(false);
        ((Outline)object2).setRenderDataProvider(new TypeDataProvider());
        ((JComponent)object2).putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        return object2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase(this.okString)) {
            this.okButtonAction(actionEvent);
        }
    }

    private void okButtonAction(ActionEvent actionEvent) {
        if (null != this.methodTask) {
            this.methodTask.cancel();
        }
        this.dialog.setCursor(this.normalCursor);
        this.dialog.dispose();
    }

    private static class BusyMouseAdapter
    extends MouseAdapter {
        private Cursor normalCursor;

        public BusyMouseAdapter(Cursor cursor) {
            this.normalCursor = cursor;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(this.normalCursor);
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class MethodTask
    implements Runnable {
        private String clientClassName;
        private LinkedList paramList;
        private JavaMethod javaMethod;
        private URLClassLoader urlClassLoader;
        private ArrayList listeners = new ArrayList();
        private boolean cancelled = false;

        MethodTask(String string, LinkedList linkedList, JavaMethod javaMethod, URLClassLoader uRLClassLoader) {
            this.clientClassName = string;
            this.paramList = linkedList;
            this.javaMethod = javaMethod;
            this.urlClassLoader = uRLClassLoader;
        }

        public void registerListener(MethodTaskListener methodTaskListener) {
            if (!this.listeners.contains(methodTaskListener)) {
                this.listeners.add(methodTaskListener);
            }
        }

        private void notifyListeners(Object object) {
            Iterator iterator = this.listeners.iterator();
            MethodTaskListener methodTaskListener = null;
            while (iterator.hasNext()) {
                methodTaskListener = (MethodTaskListener)iterator.next();
                methodTaskListener.methodFinished(object, this.paramList);
            }
        }

        public void run() {
            Object object = null;
            try {
                object = ReflectionHelper.callMethodWithParams(this.clientClassName, this.paramList, this.javaMethod, this.urlClassLoader, TestWebServiceMethodDlg.this.wsData.getWsdlData(), TestWebServiceMethodDlg.this.port);
            }
            catch (Exception exception) {
                if (!this.cancelled) {
                    Throwable throwable = exception;
                    if (exception.getCause() instanceof InvocationTargetException) {
                        throwable = exception.getCause();
                    }
                    MethodExceptionDialog methodExceptionDialog = new MethodExceptionDialog(throwable);
                    this.notifyListeners(null);
                    methodExceptionDialog.show();
                }
                return;
            }
            this.notifyListeners(object);
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

