/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.wsdl.websvcmgr;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModel;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModeler;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModelerFactory;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WebServiceListManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WsdlDataImpl;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class WebServiceManager {
    private static WebServiceManager wsMgr;
    public static String WEBSVC_HOME;

    private WebServiceManager() {
    }

    public static WebServiceManager getInstance() {
        if (wsMgr == null) {
            wsMgr = new WebServiceManager();
        }
        return wsMgr;
    }

    public void addWebService(WsdlDataImpl wsdlDataImpl) throws IOException {
        this.addWebService(wsdlDataImpl, false);
    }

    public void addWebService(WsdlDataImpl wsdlDataImpl, boolean bl) throws IOException {
        File file;
        if (wsdlDataImpl.getStatus().equals((Object)WsdlData.Status.WSDL_UNRETRIEVED) || wsdlDataImpl.getStatus().equals((Object)WsdlData.Status.WSDL_RETRIEVING) && !wsdlDataImpl.isReady()) {
            wsdlDataImpl.setStatus(WsdlData.Status.WSDL_RETRIEVING);
            file = null;
            try {
                file = WebServiceManager.copyWsdlResources(wsdlDataImpl.getOriginalWsdlUrl());
            }
            catch (IOException iOException) {
                wsdlDataImpl.setStatus(WsdlData.Status.WSDL_UNRETRIEVED);
                throw iOException;
            }
            wsdlDataImpl.setWsdlFile(file.getAbsolutePath());
            wsdlDataImpl.setStatus(WsdlData.Status.WSDL_RETRIEVED);
        }
        assert (wsdlDataImpl.getWsdlFile() != null);
        file = new File(wsdlDataImpl.getWsdlFile());
        URL uRL = file.toURI().toURL();
        WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(uRL);
        WsdlModel wsdlModel = wsdlModeler.getAndWaitForWsdlModel();
        boolean bl2 = WebServiceListManager.getInstance().wsdlDataExistsFor(wsdlDataImpl.getOriginalWsdlUrl());
        if (wsdlModel == null) {
            this.removeWebService(wsdlDataImpl, true, false);
            Throwable throwable = wsdlModeler.getCreationException();
            String string = NbBundle.getMessage(WebServiceManager.class, (String)"WS_MODELER_ERROR");
            if (throwable != null) {
                String string2 = throwable.getLocalizedMessage();
                String string3 = throwable.getClass().getName() + " - " + string2;
                string = string + "\n\n" + string3;
                Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)throwable, (String)string));
            } else {
                throwable = new IllegalStateException(string);
                Exceptions.printStackTrace((Throwable)throwable);
            }
            return;
        }
        if (wsdlModel.getServices().isEmpty()) {
            this.removeWebService(wsdlDataImpl, true, true);
            String string = NbBundle.getMessage(WebServiceManager.class, (String)"WS_NO_METHODS_ERROR");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (bl2) {
            boolean bl3 = false;
            for (WSService wSService : wsdlModel.getServices()) {
                if (!wSService.getName().equals(wsdlDataImpl.getName())) continue;
                bl3 = true;
                wsdlDataImpl.setWsdlService(wSService);
                wsdlDataImpl.setResolved(true);
                break;
            }
            if (!bl3) {
                WSService wSService = wsdlModel.getServices().get(0);
                wsdlDataImpl.setWsdlService(wSService);
                wsdlDataImpl.setName(wSService.getName());
                wsdlDataImpl.setResolved(true);
            }
        } else {
            boolean bl4 = true;
            for (WSService wSService : wsdlModel.getServices()) {
                WsdlDataImpl wsdlDataImpl2;
                if (bl4) {
                    bl4 = false;
                    wsdlDataImpl2 = wsdlDataImpl;
                } else {
                    wsdlDataImpl2 = new WsdlDataImpl(wsdlDataImpl.getOriginalWsdlUrl());
                }
                wsdlDataImpl2.setWsdlService(wSService);
                wsdlDataImpl2.setName(wSService.getName());
                wsdlDataImpl2.setResolved(true);
                WebServiceListManager.getInstance().addWsdlData(wsdlDataImpl2);
            }
        }
    }

    public void refreshWebService(WsdlDataImpl wsdlDataImpl) throws IOException {
        this.removeWebService(wsdlDataImpl, false, true);
        wsdlDataImpl.setWsdlFile(null);
        wsdlDataImpl.setStatus(WsdlData.Status.WSDL_RETRIEVING);
        wsdlDataImpl.setWsdlService(null);
        this.addWebService(wsdlDataImpl, true);
    }

    public void removeWebService(WsdlDataImpl wsdlDataImpl) {
        this.removeWebService(wsdlDataImpl, true, true);
    }

    private void removeWebService(WsdlDataImpl wsdlDataImpl, boolean bl, boolean bl2) {
        WebServiceListManager webServiceListManager;
        if (bl && (webServiceListManager = WebServiceListManager.getInstance()).wsdlDataExistsFor(wsdlDataImpl.getOriginalWsdlUrl())) {
            webServiceListManager.removeWsdlData(wsdlDataImpl);
        }
        if (wsdlDataImpl.getWsdlFile() == null) {
            return;
        }
        if (bl2) {
            WebServiceManager.rmDir(new File(wsdlDataImpl.getWsdlFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rmDir(File file) {
        if (file == null) {
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    static File copyWsdlResources(String string) throws IOException {
        File file = new File(WEBSVC_HOME);
        File file2 = new File(file, WsdlUtil.getCatalogForWsdl(string));
        File file3 = file2.getParentFile();
        boolean bl = false;
        file3 = file2.getParentFile();
        try {
            FileObject fileObject = FileUtil.createFolder((File)file3);
            URI uRI = file2.toURI();
            URI uRI2 = new URL(string).toURI();
            Retriever retriever = Retriever.getDefault();
            FileObject fileObject2 = retriever.retrieveResource(fileObject, uRI, uRI2);
            if (fileObject2 == null) {
                throw new IOException(NbBundle.getMessage(WebServiceManager.class, (String)"WSDL_COPY_ERROR"));
            }
            File file4 = FileUtil.toFile((FileObject)fileObject2);
            bl = true;
            File file5 = file4;
            return file5;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException.getLocalizedMessage());
        }
        finally {
            if (file2.exists() && !bl) {
                WebServiceManager.rmDir(file2.getParentFile());
            }
        }
    }

    static {
        WEBSVC_HOME = SaasServicesModel.WEBSVC_HOME;
    }
}

