/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LNE;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LNS;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.FileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfLineInfoSection
extends ElfSection {
    private HashMap<Long, DwarfStatementList> statementLists = new HashMap();

    public DwarfLineInfoSection(DwarfReader dwarfReader, int n) {
        super(dwarfReader, n);
    }

    public DwarfStatementList getStatementList(long l) {
        Long l2 = l;
        DwarfStatementList dwarfStatementList = this.statementLists.get(l2);
        if (dwarfStatementList == null) {
            try {
                dwarfStatementList = this.readStatementList(l);
                this.statementLists.put(l2, dwarfStatementList);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return dwarfStatementList;
    }

    private DwarfStatementList readStatementList(long l) throws IOException {
        long l2 = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset() + l);
        DwarfStatementList dwarfStatementList = new DwarfStatementList(l);
        dwarfStatementList.total_length = this.reader.readDWlen();
        dwarfStatementList.version = this.reader.readShort();
        dwarfStatementList.prologue_length = this.reader.read3264();
        dwarfStatementList.minimum_instruction_length = this.reader.readByte();
        dwarfStatementList.default_is_stmt = this.reader.readByte();
        dwarfStatementList.line_base = this.reader.readByte();
        dwarfStatementList.line_range = this.reader.readByte();
        dwarfStatementList.opcode_base = this.reader.readByte();
        dwarfStatementList.standard_opcode_lengths = new long[dwarfStatementList.opcode_base - 1];
        for (int i = 0; i < dwarfStatementList.opcode_base - 1; ++i) {
            dwarfStatementList.standard_opcode_lengths[i] = this.reader.readUnsignedLEB128();
        }
        String string = this.reader.readString();
        while (string.length() > 0) {
            dwarfStatementList.includeDirs.add(string);
            string = this.reader.readString();
        }
        String string2 = this.reader.readString();
        while (string2.length() > 0) {
            dwarfStatementList.fileEntries.add(new FileEntry(string2, this.reader.readUnsignedLEB128(), this.reader.readUnsignedLEB128(), this.reader.readUnsignedLEB128()));
            string2 = this.reader.readString();
        }
        this.reader.seek(l2);
        return dwarfStatementList;
    }

    @Override
    public void dump(PrintStream printStream) {
        super.dump(printStream);
        for (DwarfStatementList dwarfStatementList : this.statementLists.values()) {
            dwarfStatementList.dump(printStream);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dump(printStream);
        return byteArrayOutputStream.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineNumber getLineNumber(long l, long l2) throws IOException {
        long l3 = this.reader.getFilePointer();
        try {
            DwarfStatementList dwarfStatementList = this.getStatementList(l);
            this.reader.seek(this.header.getSectionOffset() + l + dwarfStatementList.prologue_length + (long)(this.reader.is32Bit() ? 10 : 22));
            LineNumber lineNumber = this.interpret(l2, dwarfStatementList, l);
            return lineNumber;
        }
        finally {
            this.reader.seek(l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LineNumber> getLineNumbers(long l) throws IOException {
        long l2 = this.reader.getFilePointer();
        try {
            DwarfStatementList dwarfStatementList = this.getStatementList(l);
            this.reader.seek(this.header.getSectionOffset() + l + dwarfStatementList.prologue_length + (long)(this.reader.is32Bit() ? 10 : 22));
            Set<LineNumber> set = this.interpret(dwarfStatementList, l);
            return set;
        }
        finally {
            this.reader.seek(l2);
        }
    }

    private Set<LineNumber> interpret(DwarfStatementList dwarfStatementList, long l) throws IOException {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        String string = null;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        int n5 = 245 / dwarfStatementList.line_range * dwarfStatementList.minimum_instruction_length;
        int n6 = -1;
        String string2 = null;
        HashSet<LineNumber> hashSet = new HashSet<LineNumber>();
        while (this.reader.getFilePointer() < this.header.getSectionOffset() + l + dwarfStatementList.total_length) {
            int n7;
            int n8 = this.reader.readByte() & 0xFF;
            if (n8 < dwarfStatementList.opcode_base) {
                block0 : switch (LNS.get(n8)) {
                    case DW_LNS_extended_op: {
                        n7 = this.reader.readUnsignedLEB128();
                        n8 = this.reader.readByte();
                        switch (LNE.get(n8)) {
                            case DW_LNE_end_sequence: {
                                n6 = n4;
                                String string3 = string2 = n3 >= 0 && n3 + 1 < dwarfStatementList.getFileEntries().size() ? dwarfStatementList.getFilePath(n3 + 1) : string;
                                if (string2 != null) {
                                    hashSet.add(new LineNumber(string2, n6, l4, l2));
                                }
                                n2 = 1;
                                n4 = 1;
                                n = 0;
                                n3 = 0;
                                l2 = 0L;
                                l3 = 0L;
                                break block0;
                            }
                            case DW_LNE_set_address: {
                                l4 = l3;
                                if (n7 == 9) {
                                    l3 = this.reader.readNumber(8);
                                } else if (n7 == 5) {
                                    l3 = this.reader.readNumber(4);
                                }
                                l2 = l3;
                                if (l4 != 0L) break block0;
                                l4 = l3;
                                break block0;
                            }
                            case DW_LNE_define_file: {
                                string = this.reader.readString();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                break block0;
                            }
                        }
                        this.reader.seek(this.reader.getFilePointer() + (long)n7);
                        break;
                    }
                    case DW_LNS_copy: {
                        n6 = n4 == 1 ? n2 : n4;
                        String string4 = string2 = n3 >= 0 && n3 + 1 < dwarfStatementList.getFileEntries().size() ? dwarfStatementList.getFilePath(n3 + 1) : string;
                        if (string2 != null) {
                            hashSet.add(new LineNumber(string2, n6, l4, l2));
                        }
                        n4 = n2;
                        n3 = n;
                        break;
                    }
                    case DW_LNS_advance_pc: {
                        long l5 = this.reader.readUnsignedLEB128();
                        l2 += l5 * (long)dwarfStatementList.minimum_instruction_length;
                        break;
                    }
                    case DW_LNS_advance_line: {
                        long l6 = this.reader.readSignedLEB128();
                        n4 = n2;
                        n2 += (int)l6;
                        break;
                    }
                    case DW_LNS_set_file: {
                        n3 = n;
                        n = this.reader.readUnsignedLEB128() - 1;
                        break;
                    }
                    case DW_LNS_set_column: {
                        this.reader.readUnsignedLEB128();
                        break;
                    }
                    case DW_LNS_negate_stmt: {
                        break;
                    }
                    case DW_LNS_set_basic_block: {
                        break;
                    }
                    case DW_LNS_const_add_pc: {
                        l2 += (long)n5;
                        break;
                    }
                    case DW_LNS_fixed_advance_pc: {
                        n7 = this.reader.readShort() & 0xFFFF;
                        l2 += (long)n7;
                    }
                }
                continue;
            }
            n7 = (n8 & 0xFF) - dwarfStatementList.opcode_base;
            int n9 = n7 / dwarfStatementList.line_range * dwarfStatementList.minimum_instruction_length;
            int n10 = dwarfStatementList.line_base + n7 % dwarfStatementList.line_range;
            long l7 = l2 + (long)n9;
            int n11 = n2 + n10;
            String string5 = string2 = n3 >= 0 && n3 + 1 < dwarfStatementList.getFileEntries().size() ? dwarfStatementList.getFilePath(n3 + 1) : string;
            if (string2 != null) {
                hashSet.add(new LineNumber(string2, n2, l4, l7));
            }
            n4 = n2;
            n3 = n;
            n2 = n11;
            l2 = l7;
        }
        return hashSet;
    }

    private LineNumber interpret(long l, DwarfStatementList dwarfStatementList, long l2) throws IOException {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        String string = null;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        int n5 = 245 / dwarfStatementList.line_range * dwarfStatementList.minimum_instruction_length;
        int n6 = -1;
        String string2 = null;
        while (this.reader.getFilePointer() < this.header.getSectionOffset() + l2 + dwarfStatementList.total_length) {
            int n7;
            int n8 = this.reader.readByte() & 0xFF;
            if (n8 < dwarfStatementList.opcode_base) {
                block0 : switch (LNS.get(n8)) {
                    case DW_LNS_extended_op: {
                        n7 = this.reader.readUnsignedLEB128();
                        n8 = this.reader.readByte();
                        switch (LNE.get(n8)) {
                            case DW_LNE_end_sequence: {
                                if (l5 <= l && l3 > l) {
                                    n6 = n4;
                                    String string3 = string2 = n3 >= 0 && n3 + 1 < dwarfStatementList.getFileEntries().size() ? dwarfStatementList.getFilePath(n3 + 1) : string;
                                    if (string2 != null) {
                                        return new LineNumber(string2, n6, l5, l3);
                                    }
                                }
                                n2 = 1;
                                n4 = 1;
                                n = 0;
                                n3 = 0;
                                l3 = 0L;
                                l4 = 0L;
                                break block0;
                            }
                            case DW_LNE_set_address: {
                                l5 = l4;
                                if (n7 == 9) {
                                    l4 = this.reader.readNumber(8);
                                } else if (n7 == 5) {
                                    l4 = this.reader.readNumber(4);
                                }
                                l3 = l4;
                                if (l5 != 0L) break block0;
                                l5 = l4;
                                break block0;
                            }
                            case DW_LNE_define_file: {
                                string = this.reader.readString();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                break block0;
                            }
                        }
                        this.reader.seek(this.reader.getFilePointer() + (long)n7);
                        break;
                    }
                    case DW_LNS_copy: {
                        if (l5 <= l && l3 > l) {
                            n6 = n4 == 1 ? n2 : n4;
                            String string4 = string2 = n3 >= 0 && n3 + 1 < dwarfStatementList.getFileEntries().size() ? dwarfStatementList.getFilePath(n3 + 1) : string;
                            if (string2 != null) {
                                return new LineNumber(string2, n6, l5, l3);
                            }
                        }
                        n4 = n2;
                        n3 = n;
                        break;
                    }
                    case DW_LNS_advance_pc: {
                        long l6 = this.reader.readUnsignedLEB128();
                        l3 += l6 * (long)dwarfStatementList.minimum_instruction_length;
                        break;
                    }
                    case DW_LNS_advance_line: {
                        long l7 = this.reader.readSignedLEB128();
                        n4 = n2;
                        n2 += (int)l7;
                        break;
                    }
                    case DW_LNS_set_file: {
                        n3 = n;
                        n = this.reader.readUnsignedLEB128() - 1;
                        break;
                    }
                    case DW_LNS_set_column: {
                        this.reader.readUnsignedLEB128();
                        break;
                    }
                    case DW_LNS_negate_stmt: {
                        break;
                    }
                    case DW_LNS_set_basic_block: {
                        break;
                    }
                    case DW_LNS_const_add_pc: {
                        l3 += (long)n5;
                        break;
                    }
                    case DW_LNS_fixed_advance_pc: {
                        n7 = this.reader.readShort() & 0xFFFF;
                        l3 += (long)n7;
                    }
                }
                continue;
            }
            n7 = (n8 & 0xFF) - dwarfStatementList.opcode_base;
            int n9 = n7 / dwarfStatementList.line_range * dwarfStatementList.minimum_instruction_length;
            int n10 = dwarfStatementList.line_base + n7 % dwarfStatementList.line_range;
            long l8 = l3 + (long)n9;
            int n11 = n2 + n10;
            if (l5 <= l && l8 >= l) {
                n6 = l8 == l ? n11 : n2;
                String string5 = string2 = n3 >= 0 && n3 + 1 < dwarfStatementList.getFileEntries().size() ? dwarfStatementList.getFilePath(n3 + 1) : string;
                if (string2 != null) {
                    return new LineNumber(string2, n6, l5, l8);
                }
            }
            n4 = n2;
            n3 = n;
            n2 = n11;
            l3 = l8;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LineNumber
    implements Comparable<LineNumber> {
        public String file;
        public int line;
        public long startOffset;
        public long endOffset;

        private LineNumber(String string, int n, long l, long l2) {
            assert (string != null);
            this.file = string;
            this.line = n;
            this.startOffset = l;
            this.endOffset = l2;
        }

        public boolean equals(Object object) {
            if (object instanceof LineNumber) {
                LineNumber lineNumber = (LineNumber)object;
                return this.file.equals(lineNumber.file) && this.line == lineNumber.line;
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 67 * n + (this.file != null ? this.file.hashCode() : 0);
            n = 67 * n + this.line;
            return n;
        }

        public String toString() {
            return this.file + ":" + this.line + "\t(0x" + Long.toHexString(this.startOffset) + "-0x" + Long.toHexString(this.endOffset) + ")";
        }

        @Override
        public int compareTo(LineNumber lineNumber) {
            int n = this.file.compareTo(lineNumber.file);
            if (n == 0) {
                n = this.line - lineNumber.line;
            }
            return n;
        }
    }
}

