/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.FileMagic;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.elf.ElfHeader;
import org.netbeans.modules.cnd.dwarfdump.elf.SectionHeader;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.ByteStreamReader;
import org.netbeans.modules.cnd.dwarfdump.reader.LoadCommand;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.StringTableSection;
import org.netbeans.modules.cnd.dwarfdump.trace.TraceDwarf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElfReader
extends ByteStreamReader {
    private boolean isCoffFormat;
    private boolean isMachoFormat;
    private ElfHeader elfHeader = null;
    private SectionHeader[] sectionHeadersTable;
    private ElfSection[] sections = null;
    private HashMap<String, Integer> sectionsMap = new HashMap();
    private StringTableSection stringTableSection = null;
    private long shiftIvArchive = 0L;
    private long lengthIvArchive = 0L;
    private List<String> linkedObjectFiles = new ArrayList<String>();

    public ElfReader(String string, RandomAccessFile randomAccessFile, Magic magic, long l, long l2) throws IOException {
        super(string, randomAccessFile);
        this.shiftIvArchive = l;
        this.lengthIvArchive = l2;
        if (!this.readHeader(magic)) {
            return;
        }
        this.readProgramHeaderTable();
        this.readSectionHeaderTable();
        this.sections = new ElfSection[this.sectionHeadersTable.length];
        int n = this.elfHeader.getELFStringTableSectionIndex();
        if (!this.isCoffFormat && !this.isMachoFormat) {
            this.stringTableSection = new StringTableSection(this, n);
        }
        this.sections[n] = this.stringTableSection;
        for (int i = 0; i < this.sections.length; ++i) {
            this.sectionsMap.put(this.getSectionName(i), i);
        }
    }

    public String getSectionName(int n) {
        if (!this.isCoffFormat && !this.isMachoFormat) {
            if (this.stringTableSection == null) {
                return ".shstrtab";
            }
            long l = this.sectionHeadersTable[n].sh_name;
            return this.stringTableSection.getString(l);
        }
        return this.sectionHeadersTable[n].getSectionName();
    }

    public boolean readHeader(Magic magic) throws WrongFileFormatException, IOException {
        this.elfHeader = new ElfHeader();
        this.seek(this.shiftIvArchive);
        byte[] byArray = new byte[16];
        this.read(byArray);
        switch (magic) {
            case Elf: {
                this.readElfHeader(byArray);
                return true;
            }
            case Coff: {
                this.readCoffHeader(this.shiftIvArchive);
                return true;
            }
            case Exe: {
                this.readPeHeader(true);
                return true;
            }
            case Pe: {
                this.readPeHeader(false);
                return true;
            }
            case Macho: {
                return this.readMachoHeader();
            }
        }
        throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
    }

    private void readElfHeader(byte[] byArray) throws IOException {
        this.elfHeader.elfClass = byArray[4];
        this.elfHeader.elfData = byArray[5];
        this.elfHeader.elfVersion = byArray[6];
        this.elfHeader.elfOs = byArray[7];
        this.elfHeader.elfAbi = byArray[8];
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        this.elfHeader.e_type = this.readShort();
        this.elfHeader.e_machine = this.readShort();
        this.elfHeader.e_version = this.readInt();
        this.elfHeader.e_entry = this.read3264() + this.shiftIvArchive;
        this.elfHeader.e_phoff = this.read3264() + this.shiftIvArchive;
        this.elfHeader.e_shoff = this.read3264() + this.shiftIvArchive;
        this.elfHeader.e_flags = this.readInt();
        this.elfHeader.e_ehsize = this.readShort();
        this.elfHeader.e_phentsize = this.readShort();
        this.elfHeader.e_phnum = this.readShort();
        this.elfHeader.e_shentsize = this.readShort();
        this.elfHeader.e_shnum = this.readShort();
        this.elfHeader.e_shstrndx = this.readShort();
    }

    private void readPeHeader(boolean bl) throws IOException {
        this.elfHeader.elfData = 1;
        this.elfHeader.elfClass = 1;
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        int n = 0;
        if (bl) {
            this.seek(60L);
            n = this.readInt();
            this.seek(n);
            byte[] byArray = new byte[4];
            this.read(byArray);
            if (!FileMagic.isPeMagic(byArray)) {
                throw new WrongFileFormatException("Not an PE/COFF file");
            }
        }
        this.readCoffHeader(n + 4);
    }

    private void readCoffHeader(long l) throws IOException {
        this.isCoffFormat = true;
        this.seek(2L + l);
        this.elfHeader.elfData = 1;
        this.elfHeader.elfClass = 1;
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        this.elfHeader.e_shnum = this.readShort();
        this.readInt();
        long l2 = this.shiftIvArchive + (long)this.readInt();
        int n = this.readInt();
        long l3 = l2 + (long)(n * 18);
        int n2 = (int)(this.shiftIvArchive + this.lengthIvArchive - l3);
        long l4 = this.getFilePointer();
        this.seek(l3);
        byte[] byArray = new byte[n2];
        this.read(byArray);
        this.stringTableSection = new StringTableSection(this, byArray);
        this.seek(l4);
        short s = this.readShort();
        this.readShort();
        if (s > 0) {
            this.skipBytes(s);
        }
        this.elfHeader.e_shoff = this.getFilePointer();
    }

    private boolean readMachoHeader() throws IOException {
        int n;
        this.isMachoFormat = true;
        this.elfHeader.elfData = 1;
        this.elfHeader.elfClass = 1;
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        this.seek(this.shiftIvArchive);
        boolean bl = this.readByte() == -49;
        this.seek(this.shiftIvArchive + 16L);
        int n2 = this.readInt();
        this.readInt();
        this.readInt();
        if (bl) {
            this.skipBytes(4);
        }
        ArrayList<SectionHeader> arrayList = new ArrayList<SectionHeader>();
        for (n = 0; n < n2; ++n) {
            int n3 = this.readInt();
            int n4 = this.readInt();
            if (TraceDwarf.TRACED) {
                System.out.println("Load command: " + (Object)((Object)LoadCommand.valueOf(n3)) + " (" + n3 + ")");
            }
            if (LoadCommand.LC_SEGMENT.is(n3) || LoadCommand.LC_SEGMENT_64.is(n3)) {
                this.skipBytes(16);
                if (bl) {
                    this.readLong();
                    this.readLong();
                    this.readLong();
                    this.readLong();
                } else {
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    this.readInt();
                }
                this.readInt();
                this.readInt();
                int n5 = this.readInt();
                this.readInt();
                for (int i = 0; i < n5; ++i) {
                    SectionHeader sectionHeader = this.readMachoSection(bl);
                    if (sectionHeader == null) continue;
                    arrayList.add(sectionHeader);
                }
                continue;
            }
            if (LoadCommand.LC_SYMTAB.is(n3)) {
                this.readInt();
                this.readInt();
                long l = (long)this.readInt() + this.shiftIvArchive;
                int n6 = this.readInt();
                long l2 = this.getFilePointer();
                this.seek(l);
                byte[] byArray = new byte[n6];
                this.read(byArray);
                this.stringTableSection = new StringTableSection(this, byArray);
                this.seek(l2);
                continue;
            }
            this.skipBytes(n4 - 8);
        }
        if (TraceDwarf.TRACED && this.stringTableSection != null) {
            this.stringTableSection.dump(System.out);
        }
        if (arrayList.size() == 0 || this.stringTableSection == null) {
            if (this.isThereAnyLinkedObjectFiles(this.stringTableSection)) {
                return false;
            }
            throw new WrongFileFormatException("Dwarf section not found in Mach-O file");
        }
        this.sectionHeadersTable = new SectionHeader[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.sectionHeadersTable[n] = (SectionHeader)arrayList.get(n);
        }
        this.elfHeader.e_shstrndx = (short)(arrayList.size() - 1);
        return true;
    }

    private boolean isThereAnyLinkedObjectFiles(StringTableSection stringTableSection) {
        String string;
        if (stringTableSection == null) {
            return false;
        }
        for (int i = 1; i < stringTableSection.getStringTable().length; i += string.length() + 1) {
            string = stringTableSection.getString(i);
            if (string.length() <= 2 || !".o".equals(string.substring(string.length() - 2))) continue;
            this.linkedObjectFiles.add(string);
        }
        return this.linkedObjectFiles.size() > 0;
    }

    public List<String> getLinkedObjectFiles() {
        return this.linkedObjectFiles;
    }

    private SectionHeader readMachoSection(boolean bl) throws IOException {
        long l;
        byte[] byArray = new byte[16];
        this.read(byArray);
        String string = this.getName(byArray, 0);
        byte[] byArray2 = new byte[16];
        this.read(byArray2);
        String string2 = this.getName(byArray2, 0);
        if (bl) {
            this.readLong();
            l = this.readLong();
        } else {
            this.readInt();
            l = this.readInt();
        }
        long l2 = (long)this.readInt() + this.shiftIvArchive;
        this.readInt();
        this.readInt();
        this.readInt();
        int n = this.readInt();
        this.readInt();
        this.readInt();
        if (bl) {
            this.readInt();
        }
        if ("__DWARF".equals(string2)) {
            SectionHeader sectionHeader = new SectionHeader();
            if (string.startsWith("__debug")) {
                string = "." + string.substring(2);
            }
            sectionHeader.name = string;
            sectionHeader.sh_size = l;
            sectionHeader.sh_offset = l2;
            sectionHeader.sh_flags = n;
            return sectionHeader;
        }
        if (TraceDwarf.TRACED) {
            System.out.println("Segment,Section: " + string2 + "," + string);
        }
        return null;
    }

    private String getName(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < byArray.length && byArray[i] != 0; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    private void readProgramHeaderTable() {
    }

    private void readSectionHeaderTable() throws IOException {
        long l = this.elfHeader.getSectionHeaderOffset();
        if (l > 0L) {
            this.seek(l);
            int n = this.elfHeader.getNumberOfSectionHeaders();
            this.sectionHeadersTable = new SectionHeader[n];
            for (int i = 0; i < n; ++i) {
                this.sectionHeadersTable[i] = this.isCoffFormat ? this.readCoffSectionHeader() : this.readSectionHeader();
            }
        }
    }

    private SectionHeader readSectionHeader() throws IOException {
        SectionHeader sectionHeader = new SectionHeader();
        sectionHeader.sh_name = this.readInt();
        sectionHeader.sh_type = this.readInt();
        sectionHeader.sh_flags = this.read3264();
        sectionHeader.sh_addr = this.read3264();
        sectionHeader.sh_offset = this.read3264() + this.shiftIvArchive;
        sectionHeader.sh_size = this.read3264();
        sectionHeader.sh_link = this.readInt();
        sectionHeader.sh_info = this.readInt();
        sectionHeader.sh_addralign = this.read3264();
        sectionHeader.sh_entsize = this.read3264();
        return sectionHeader;
    }

    private SectionHeader readCoffSectionHeader() throws IOException {
        SectionHeader sectionHeader = new SectionHeader();
        byte[] byArray = new byte[8];
        this.read(byArray);
        String string = null;
        if (byArray[0] == 47) {
            byte by;
            int n = 0;
            for (int i = 1; i < 8 && (by = byArray[i]) >= 48; ++i) {
                n *= 10;
                n += by - 48;
            }
            string = this.stringTableSection.getString(n);
        } else {
            string = this.getName(byArray, 0);
        }
        sectionHeader.name = string;
        this.readInt();
        this.readInt();
        sectionHeader.sh_size = this.readInt();
        sectionHeader.sh_offset = this.shiftIvArchive + (long)this.readInt();
        this.readInt();
        this.readInt();
        this.readShort();
        this.readShort();
        sectionHeader.sh_flags = this.readInt();
        return sectionHeader;
    }

    StringTableSection readStringTableSection(String string) throws IOException {
        Integer n = this.sectionsMap.get(string);
        return n == null ? null : this.readStringTableSection(n);
    }

    StringTableSection readStringTableSection(int n) throws IOException {
        this.sections[n] = new StringTableSection(this, n);
        return (StringTableSection)this.sections[n];
    }

    public ElfSection getSection(String string) {
        Integer n = this.sectionsMap.get(string);
        if (n == null) {
            return null;
        }
        if (this.sections[n] == null) {
            this.sections[n.intValue()] = this.initSection(n, string);
        }
        return this.sections[n];
    }

    ElfSection initSection(Integer n, String string) {
        return null;
    }

    public SectionHeader getSectionHeader(int n) {
        return this.sectionHeadersTable[n];
    }
}

