/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.maven;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HpiActionGoalProvider
implements MavenActionsProvider {
    private static final HashSet<String> ACTIONS = new HashSet<String>(Arrays.asList("run", "debug"));
    private static Map<Project, Boolean> IS_HPI = new WeakHashMap<Project, Boolean>();
    private static final AbstractMavenActionsProvider delegate = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            return HpiActionGoalProvider.class.getResourceAsStream("action-mappings.xml");
        }
    };

    private static synchronized boolean isHPI(Project project) {
        Boolean bl = IS_HPI.get(project);
        if (bl == null) {
            bl = "hpi".equals(((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getPackagingType());
            IS_HPI.put(project, bl);
        }
        return bl;
    }

    public RunConfig createConfigForDefaultAction(String string, Project project, Lookup lookup) {
        if (this.isActionEnable(string, project, null)) {
            return delegate.createConfigForDefaultAction(string, project, lookup);
        }
        return null;
    }

    public NetbeansActionMapping getMappingForAction(String string, Project project) {
        if (this.isActionEnable(string, project, null)) {
            return delegate.getMappingForAction(string, project);
        }
        return null;
    }

    public boolean isActionEnable(String string, Project project, Lookup lookup) {
        return ACTIONS.contains(string) && HpiActionGoalProvider.isHPI(project);
    }

    public Set<String> getSupportedDefaultActions() {
        return ACTIONS;
    }
}

