/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.xml.AntProjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntScriptUtils {
    private static final Map<FileObject, AntProjectCookie> antProjectCookies = new WeakHashMap<FileObject, AntProjectCookie>();

    private AntScriptUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AntProjectCookie antProjectCookieFor(FileObject fileObject) {
        AntProjectCookie antProjectCookie;
        Object object;
        block7: {
            try {
                object = DataObject.find((FileObject)fileObject);
                antProjectCookie = (AntProjectCookie)object.getCookie(AntProjectCookie.class);
                if (antProjectCookie != null) {
                    return antProjectCookie;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)dataObjectNotFoundException);
            }
        }
        object = antProjectCookies;
        synchronized (object) {
            antProjectCookie = antProjectCookies.get(fileObject);
            if (antProjectCookie == null) {
                antProjectCookie = new AntProjectSupport(fileObject);
                antProjectCookies.put(fileObject, antProjectCookie);
            }
            return antProjectCookie;
        }
    }

    public static String getAntScriptName(FileObject fileObject) {
        AntProjectCookie antProjectCookie = AntScriptUtils.antProjectCookieFor(fileObject);
        Element element = antProjectCookie.getProjectElement();
        if (element == null) {
            return null;
        }
        String string = element.getAttribute("name");
        return string.length() > 0 ? string : null;
    }

    public static List<String> getCallableTargetNames(FileObject fileObject) throws IOException {
        AntProjectCookie antProjectCookie = AntScriptUtils.antProjectCookieFor(fileObject);
        Set<TargetLister.Target> set = TargetLister.getTargets(antProjectCookie);
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        for (TargetLister.Target target : set) {
            if (target.isOverridden() || target.isInternal()) continue;
            treeSet.add(target.getName());
        }
        return new ArrayList<Object>(treeSet);
    }
}

