/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.ui.actions.AddGroupAction;
import org.netbeans.modules.websvc.saas.ui.actions.AddServiceAction;
import org.netbeans.modules.websvc.saas.ui.actions.DeleteGroupAction;
import org.netbeans.modules.websvc.saas.ui.actions.RenameGroupAction;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasGroupNodeChildren;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaasGroupNode
extends AbstractNode {
    private final SaasGroup group;
    private Image vendorIcon = null;

    public SaasGroupNode(SaasGroup saasGroup) {
        this(saasGroup, new InstanceContent());
    }

    protected SaasGroupNode(SaasGroup saasGroup, InstanceContent instanceContent) {
        super((Children)new SaasGroupNodeChildren(saasGroup), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.group = saasGroup;
        instanceContent.add((Object)saasGroup);
    }

    public String getName() {
        return this.group.getName();
    }

    public void setName(String string) {
        if (this.group.isUserDefined()) {
            super.setName(string);
            this.group.setName(string);
        }
    }

    public boolean canRename() {
        return this.group.isUserDefined();
    }

    private Image getUserDirFolderImage(int n) {
        DataFolder dataFolder;
        FileObject fileObject = FileUtil.toFileObject((File)new File(System.getProperty("netbeans.user")));
        if (fileObject != null && (dataFolder = DataFolder.findFolder((FileObject)fileObject)) != null) {
            return dataFolder.getNodeDelegate().getIcon(n);
        }
        return null;
    }

    private Image getVendorIcon(int n) {
        if (this.vendorIcon == null && this.group.getServices().size() > 0) {
            this.vendorIcon = SaasUtil.loadIcon((SaasGroup)this.group, (int)n);
        }
        return this.vendorIcon;
    }

    public Image getIcon(int n) {
        Image image = this.getVendorIcon(n);
        if (image != null) {
            return image;
        }
        Image image2 = this.getUserDirFolderImage(n);
        if (image2 != null) {
            return image2;
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/resources/folder-closed.png");
    }

    public Image getOpenedIcon(int n) {
        Image image = this.getVendorIcon(n);
        if (image != null) {
            return image;
        }
        Image image2 = this.getUserDirFolderImage(n);
        if (image2 != null) {
            return image2;
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/resources/folder-open.png");
    }

    public Action[] getActions(boolean bl) {
        List<Action> list = SaasNode.getActions(this.getLookup());
        list.add((Action)SystemAction.get(AddServiceAction.class));
        list.add((Action)SystemAction.get(AddGroupAction.class));
        list.add((Action)SystemAction.get(DeleteGroupAction.class));
        list.add((Action)SystemAction.get(RenameGroupAction.class));
        return list.toArray(new Action[list.size()]);
    }

    public boolean canDestroy() {
        return this.group.isUserDefined();
    }

    public void destroy() throws IOException {
        SaasServicesModel.getInstance().removeGroup(this.group);
        super.destroy();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("websvcGroupNode");
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
    }
}

