/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorContent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class NavigatorPanelUI
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private NavigatorContent content = new NavigatorContent();
    private BeanTreeView navigatorPane;
    private ExplorerManager explorerManager = new ExplorerManager();
    private final InstanceContent selectedNodes = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);
    private boolean isBusy = false;

    public NavigatorPanelUI() {
        this.initComponents();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.navigatorPane = new BeanTreeView();
        this.navigatorPane.setRootVisible(false);
        this.navigatorPane.setDropTarget(false);
        this.navigatorPane.setDragSource(false);
        this.add((Component)this.navigatorPane, "Center");
        this.explorerManager.setRootContext(this.content.getRoot());
        this.expandAll();
    }

    private void expandAll() {
        NavigatorModel navigatorModel = this.content.getModel();
        if (navigatorModel != null && navigatorModel.getFilter().isExpandAll()) {
            this.navigatorPane.expandAll();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void setBusyState(boolean bl) {
        Cursor cursor = this.isBusy ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        this.navigatorPane.setCursor(cursor);
    }

    void newContentReady() {
        this.explorerManager.setRootContext(this.content.getRoot());
        if (SwingUtilities.isEventDispatchThread()) {
            this.expandAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NavigatorPanelUI.this.expandAll();
                }
            });
        }
    }

    NavigatorContent getContent() {
        return this.content;
    }

    void selectNode(Node node) {
        try {
            this.explorerManager.setSelectedNodes(new Node[]{node});
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.navigatorPane.requestFocusInWindow();
        return bl;
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            for (Node node : (Node[])propertyChangeEvent.getOldValue()) {
                this.selectedNodes.remove((Object)node);
            }
            for (Node node : (Node[])propertyChangeEvent.getNewValue()) {
                this.selectedNodes.add((Object)node);
            }
        }
    }
}

