/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk.models;

import java.lang.ref.WeakReference;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.InstanceImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.views.DebuggerHeapFragmentWalker;
import org.netbeans.modules.debugger.jpda.heapwalk.views.InstancesView;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class HeapActionsFilter
implements NodeActionsProviderFilter {
    private JPDADebugger debugger;
    private final Action HEAP_REFERENCES_ACTION = Models.createAction((String)NbBundle.getBundle(HeapActionsFilter.class).getString("CTL_References_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object == null || !(object instanceof ObjectVariable)) {
                return false;
            }
            ObjectVariable objectVariable = (ObjectVariable)object;
            return objectVariable.getUniqueID() != 0L;
        }

        public void perform(Object[] objectArray) {
            ObjectVariable objectVariable = (ObjectVariable)objectArray[0];
            if (objectVariable.getUniqueID() == 0L) {
                return;
            }
            final InstancesView instancesView = this.openInstances(true);
            final WeakReference<ObjectVariable> weakReference = new WeakReference<ObjectVariable>(objectVariable);
            final WeakReference<JPDADebugger> weakReference2 = new WeakReference<JPDADebugger>(HeapActionsFilter.this.debugger);
            InstancesView.HeapFragmentWalkerProvider heapFragmentWalkerProvider = new InstancesView.HeapFragmentWalkerProvider(){

                public synchronized HeapFragmentWalker getHeapFragmentWalker() {
                    ObjectVariable objectVariable;
                    HeapFragmentWalker heapFragmentWalker = instancesView.getCurrentFragmentWalker();
                    HeapImpl heapImpl = heapFragmentWalker != null ? (HeapImpl)heapFragmentWalker.getHeapFragment() : null;
                    JPDADebugger jPDADebugger = (JPDADebugger)weakReference2.get();
                    if (heapImpl == null || jPDADebugger != null && heapImpl.getDebugger() != jPDADebugger) {
                        heapImpl = new HeapImpl(jPDADebugger);
                        heapFragmentWalker = new DebuggerHeapFragmentWalker(heapImpl);
                    }
                    if ((objectVariable = (ObjectVariable)weakReference.get()) != null) {
                        Instance instance = InstanceImpl.createInstance(heapImpl, objectVariable);
                        heapFragmentWalker.getInstancesController().showInstance(instance);
                    }
                    return heapFragmentWalker;
                }
            };
            instancesView.setHeapFragmentWalkerProvider(heapFragmentWalkerProvider);
        }

        private InstancesView openInstances(boolean bl) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("dbgInstances");
            if (topComponent == null) {
                throw new IllegalArgumentException("dbgInstances");
            }
            topComponent.open();
            if (bl) {
                topComponent.requestActive();
            }
            return (InstancesView)topComponent;
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public HeapActionsFilter(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Action[] actionArray = nodeActionsProvider.getActions(object);
        if (object instanceof ObjectVariable && this.debugger.canGetInstanceInfo()) {
            int n;
            for (n = 0; n < actionArray.length && actionArray[n] != null; ++n) {
            }
            Action[] actionArray2 = new Action[actionArray.length + 1];
            System.arraycopy(actionArray, 0, actionArray2, 0, n);
            actionArray2[n] = this.HEAP_REFERENCES_ACTION;
            if (n < actionArray.length) {
                System.arraycopy(actionArray, n, actionArray2, n + 1, actionArray.length - n);
            }
            actionArray = actionArray2;
        }
        return actionArray;
    }
}

