/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.api.project.rake;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public abstract class RakeArtifact {
    private final Properties PROPS = new Properties();
    private static final Set<String> warnedClasses = Collections.synchronizedSet(new HashSet());

    protected RakeArtifact() {
    }

    public abstract String getType();

    public abstract File getScriptLocation();

    public abstract String getTargetName();

    public abstract String getCleanTargetName();

    @Deprecated
    public URI getArtifactLocation() {
        return this.getArtifactLocations()[0];
    }

    public URI[] getArtifactLocations() {
        String string = this.getClass().getName();
        if (warnedClasses.add(string)) {
            ErrorManager.getDefault().log(16, "Warning: " + string + ".getArtifactLocations() must be overridden");
        }
        return new URI[]{this.getArtifactLocation()};
    }

    public String getID() {
        return this.getTargetName();
    }

    @Deprecated
    public final FileObject getArtifactFile() {
        FileObject[] fileObjectArray = this.getArtifactFiles();
        if (fileObjectArray.length > 0) {
            return fileObjectArray[0];
        }
        return null;
    }

    private FileObject getArtifactFile(URI uRI) {
        URL uRL;
        assert (!uRI.isAbsolute() || !uRI.isOpaque() && "file".equals(uRI.getScheme())) : uRI;
        try {
            uRL = this.getScriptLocation().toURI().resolve(uRI).normalize().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            return null;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject != null) {
            assert (FileUtil.toFile((FileObject)fileObject) != null) : fileObject;
            return fileObject;
        }
        return null;
    }

    public final FileObject[] getArtifactFiles() {
        URI[] uRIArray = this.getArtifactLocations();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRIArray.length; ++i) {
            FileObject fileObject = this.getArtifactFile(uRIArray[i]);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public final FileObject getScriptFile() {
        FileObject fileObject = FileUtil.toFileObject((File)this.getScriptLocation());
        assert (fileObject == null || FileUtil.toFile((FileObject)fileObject) != null) : fileObject;
        return fileObject;
    }

    public Project getProject() {
        return FileOwnerQuery.getOwner((URI)this.getScriptLocation().toURI());
    }

    public Properties getProperties() {
        return this.PROPS;
    }
}

