/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.sequece;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanelListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileDataFlavor;
import org.openide.util.NbBundle;

public class SequenceEditingPanel
extends JComponent
implements Scrollable,
MouseMotionListener,
MouseListener,
SequenceListener {
    public static final boolean DEBUG = false;
    private static final int BOUNDARY_MIN = 10;
    private static final int SEPARATOR_WIDTH_MIN = 15;
    private static final Color COLOR_SEPARATOR_VERTICAL;
    private static final Color COLOR_SEPARATOR_HORIZONTAL;
    private Color backgroundColor = Color.WHITE;
    private static final int NONE = -1;
    private Sequence sequence;
    private SequenceContainer sequenceContainer;
    private JViewport viewPort;
    private int frameWidth;
    private int frameHeight;
    private int unitWidth;
    private int unitHeight;
    private int separatorWidth;
    private int separatorHeight;
    private int outlineWidth;
    private int outlineHeight;
    private boolean centerVertically;
    private boolean centerHorizontally;
    private Point start = new Point(0, 0);
    private Point transOutlineToFrame;
    private Point transFrameToSeparator;
    private Point transOutlineToSeparator;
    private Point transSeparatorToOutline;
    private int filmUnitWidth;
    private FrameSelectionManager selection;
    private int hilitedColumn = -1;
    EventListenerList listenerList = new EventListenerList();

    public SequenceEditingPanel(Sequence sequence) {
        this.setDoubleBuffered(true);
        this.sequence = sequence;
        this.selection = new FrameSelectionManager();
        this.sequence.addSequenceListener(this);
        this.sequence.addSequenceListener(this.selection);
        this.frameWidth = this.sequence.getFrameWidth();
        this.frameHeight = this.sequence.getFrameHeight();
        this.unitWidth = Math.max(this.frameWidth / 5, 10);
        this.unitHeight = Math.max(this.frameHeight / 5, 10);
        this.outlineWidth = this.frameWidth + this.unitWidth * 2;
        this.outlineHeight = this.frameHeight + this.unitHeight * 2;
        this.separatorWidth = Math.max(this.unitWidth, 15);
        this.transSeparatorToOutline = new Point(this.separatorWidth + this.unitWidth, 0);
        this.transOutlineToFrame = new Point(this.unitWidth, this.unitHeight);
        this.transFrameToSeparator = new Point(this.frameWidth + this.unitWidth * 2, -this.unitHeight);
        this.transOutlineToSeparator = new Point(this.unitWidth, 0);
        this.filmUnitWidth = this.transSeparatorToOutline.x + this.transOutlineToFrame.x + this.transFrameToSeparator.x;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        DropTarget dropTarget = new DropTarget(this, new SequenceDropTargetListener());
        dropTarget.setActive(true);
        this.setDropTarget(dropTarget);
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 1, new DGL());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setSequenceContainer(SequenceContainer sequenceContainer) {
        this.sequenceContainer = sequenceContainer;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.getColumnForPoint(mouseEvent.getPoint());
        int n2 = this.getFrameForColumn(n);
        if (n2 == -1) {
            return null;
        }
        return NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.frame.tooltip", (Object[])new Object[]{n2, this.sequence.getFrame(n2).getIndex()});
    }

    private void updateHiLite(Point point) {
        this.handleMouseMoveOver(point);
    }

    public void setViewPort(JViewport jViewport) {
        this.viewPort = jViewport;
    }

    public Dimension getPreferredSize() {
        int n = this.filmUnitWidth * this.sequence.getFrameCount() + this.transOutlineToSeparator.x + this.transSeparatorToOutline.x;
        int n2 = 10 + this.separatorHeight;
        int n3 = 0;
        int n4 = 0;
        if (this.viewPort != null && this.viewPort.getWidth() > n) {
            n3 += this.viewPort.getWidth();
        } else {
            n3 += n + 20;
            this.start.x = 10;
        }
        this.start.y = 10;
        return new Dimension(n3, n4 += n2);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.backgroundColor);
        graphics2D.setColor(COLOR_SEPARATOR_HORIZONTAL);
        graphics2D.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        this.start = new Point(this.separatorWidth, (this.getHeight() - this.outlineHeight) / 2);
        Point point = new Point(this.start);
        int n = 0;
        for (int i = 0; i < this.sequence.getFrameCount(); ++i) {
            this.drawSeparator(graphics2D, n, point);
            ++n;
            point.translate(this.transSeparatorToOutline.x, this.transSeparatorToOutline.y);
            this.drawOutline(graphics2D, i, point);
            point.translate(this.transOutlineToFrame.x, this.transOutlineToFrame.y);
            StaticTile staticTile = this.sequence.getFrame(i);
            this.drawFrame(graphics2D, staticTile, point);
            ++n;
            point.translate(this.transFrameToSeparator.x, this.transFrameToSeparator.y);
        }
        this.drawSeparator(graphics2D, n, point);
    }

    private void drawSeparator(Graphics2D graphics2D, int n, Point point) {
        Color color = this.hilitedColumn == n ? new Color(255, 235, 140) : this.backgroundColor;
        graphics2D.setColor(color);
        graphics2D.fillRect(point.x, 0, this.separatorWidth, this.getHeight() - 1);
        graphics2D.setColor(COLOR_SEPARATOR_VERTICAL);
        int n2 = point.x + this.separatorWidth / 2;
        graphics2D.drawLine(n2, 0, n2, this.getHeight() - 1);
    }

    private void drawOutline(Graphics2D graphics2D, int n, Point point) {
        int n2 = this.getColumnForFrame(n);
        int n3 = this.unitWidth / 2;
        int n4 = this.unitHeight / 2;
        if (this.selection.isFrameSelected(n)) {
            graphics2D.setColor(new Color(175, 195, 255));
            graphics2D.fillRect(point.x - this.unitWidth, point.y - this.unitHeight, this.outlineWidth + 2 * this.unitWidth, this.outlineHeight + 2 * this.unitHeight);
        }
        if (this.hilitedColumn == n2) {
            graphics2D.setColor(new Color(255, 235, 140));
            graphics2D.fillRect(point.x - n3, point.y - n4, this.outlineWidth + this.unitWidth, this.outlineHeight + this.unitHeight);
        }
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(point.x, point.y, this.outlineWidth, this.outlineHeight);
    }

    private void drawFrame(Graphics2D graphics2D, StaticTile staticTile, Point point) {
        staticTile.paint(graphics2D, point.x, point.y);
    }

    private int getColumnForPoint(Point point) {
        if (point.x < this.start.x + this.transSeparatorToOutline.x) {
            return 0;
        }
        if (point.x > this.start.x + this.filmUnitWidth * this.sequence.getFrameCount()) {
            return this.getLastColIndex();
        }
        int n = (point.x - this.start.x) / this.filmUnitWidth;
        int n2 = 0;
        int n3 = (point.x - this.start.x) % this.filmUnitWidth;
        n2 = n3 < this.transSeparatorToOutline.x ? 0 : (n3 < this.transSeparatorToOutline.x + this.outlineWidth ? 1 : 2);
        return 2 * n + n2;
    }

    private Rectangle getAreaForColumn(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getHeight();
        if (n % 2 == 0) {
            if (n == 0) {
                n4 = this.start.x + this.transSeparatorToOutline.x;
            } else {
                n2 = this.start.x + this.sequence.getFrameCount() * this.filmUnitWidth - this.transOutlineToSeparator.x;
                n4 = n == this.getLastColIndex() ? this.getWidth() - n2 : this.transSeparatorToOutline.x + this.transOutlineToSeparator.x;
            }
        } else {
            n2 = this.start.x + this.transSeparatorToOutline.x + this.filmUnitWidth * (n / 2);
            n4 = this.outlineWidth;
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    private int getLastColIndex() {
        return this.sequence.getFrameCount() * 2;
    }

    private int getColumnForFrame(int n) {
        return n * 2 + 1;
    }

    private int getFrameForColumn(int n) {
        if (n % 2 == 0) {
            return -1;
        }
        return (n - 1) / 2;
    }

    private int getColumnCount() {
        return this.getLastColIndex() + 1;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.handleMouseMoveOver(mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.handleMouseMoveOver(mouseEvent.getPoint());
    }

    private void handleMouseMoveOver(Point point) {
        int n = this.hilitedColumn;
        this.hilitedColumn = this.getColumnForPoint(point);
        if (n != this.hilitedColumn) {
            int n2 = this.getFrameForColumn(this.hilitedColumn);
            if (n2 != -1) {
                this.fireFrameHilited(n2);
            }
            this.repaint();
        }
    }

    public void frameAdded(Sequence sequence, int n) {
        this.revalidate();
        this.repaint();
        Rectangle rectangle = n == this.sequence.getFrameCount() - 1 ? new Rectangle(new Point(this.getWidth() + this.filmUnitWidth, 0)) : this.getAreaForColumn(this.getColumnForFrame(n));
        this.scrollRectToVisible(rectangle);
    }

    public void frameRemoved(Sequence sequence, int n) {
        this.revalidate();
        this.repaint();
    }

    public void frameModified(Sequence sequence, int n) {
        this.repaint(this.getAreaForColumn(this.getColumnForFrame(n)));
    }

    public void framesChanged(Sequence sequence) {
        this.revalidate();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopUp(mouseEvent);
        } else {
            int n = this.getColumnForPoint(mouseEvent.getPoint());
            int n2 = this.getFrameForColumn(n);
            if (n2 == -1) {
                return;
            }
            if (this.isContinuousSelect(mouseEvent)) {
                int n3 = this.selection.getAnchorSelectionIndex();
                if (n3 == -1) {
                    this.selection.setSelected(n2, true);
                } else {
                    this.selection.setIntervalSelection(n3, n2, true);
                }
            } else if (this.isMultiSelect(mouseEvent)) {
                this.selection.flipSelection(n2);
            } else {
                boolean bl = this.selection.isFrameSelected(n2);
                this.selection.clearSelections();
                this.selection.setSelected(n2, !bl);
            }
            this.repaint();
            this.sequence.getGameDesign().getMainView().requestPreview(this.sequence.getFrame(n2));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopUp(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hilitedColumn = -1;
        this.repaint();
        this.fireHiliteLost();
    }

    private boolean isMultiSelect(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown();
    }

    private boolean isContinuousSelect(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    private void handlePopUp(MouseEvent mouseEvent) {
        int n;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.sequenceContainer != null) {
            for (Action iterator : this.sequenceContainer.getActionsForSequence(this.sequence)) {
                jPopupMenu.add(iterator);
            }
            jPopupMenu.addSeparator();
        }
        if (this.getFrameForColumn(n = this.getColumnForPoint(mouseEvent.getPoint())) == -1) {
            for (Action action : this.getSeparatorActions(n)) {
                jPopupMenu.add(action);
            }
        } else {
            for (Action action : this.getFrameActions(n)) {
                jPopupMenu.add(action);
            }
        }
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    private List getFrameActions(int n) {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        SelectAllAction selectAllAction = new SelectAllAction();
        arrayList.add(selectAllAction);
        RemoveAction removeAction = new RemoveAction();
        if (this.sequence.getFrameCount() == 1 || this.selection.getSelectedIndexes().size() > 1) {
            removeAction.setEnabled(false);
        }
        removeAction.putValue("PROP_COL", new Integer(n));
        arrayList.add(removeAction);
        RemoveSelectedAction removeSelectedAction = new RemoveSelectedAction();
        if (this.selection.isSelectionEmpty()) {
            removeSelectedAction.setEnabled(false);
        }
        if (this.sequence.getFrameCount() <= this.selection.getSelectedIndexes().size() || this.selection.getSelectedIndexes().size() == 0) {
            removeSelectedAction.setEnabled(false);
        }
        arrayList.add(removeSelectedAction);
        return arrayList;
    }

    private List getSeparatorActions(int n) {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        TweenAction tweenAction = new TweenAction();
        if (n == 0 || n == this.sequence.getFrameCount() * 2) {
            tweenAction.setEnabled(false);
        }
        tweenAction.putValue("PROP_COL", new Integer(n));
        arrayList.add(tweenAction);
        InsertEmptyFrameAction insertEmptyFrameAction = new InsertEmptyFrameAction();
        insertEmptyFrameAction.putValue("PROP_COL", n);
        arrayList.add(insertEmptyFrameAction);
        return arrayList;
    }

    public synchronized void addSequenceEditingPanelListener(SequenceEditingPanelListener sequenceEditingPanelListener) {
        this.listenerList.add(SequenceEditingPanelListener.class, sequenceEditingPanelListener);
    }

    public synchronized void removeSequenceEditingPanelListener(SequenceEditingPanelListener sequenceEditingPanelListener) {
        this.listenerList.remove(SequenceEditingPanelListener.class, sequenceEditingPanelListener);
    }

    private void fireFrameHilited(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SequenceEditingPanelListener.class) continue;
            ((SequenceEditingPanelListener)objectArray[i + 1]).frameHilited(this, n);
        }
    }

    private void fireHiliteLost() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SequenceEditingPanelListener.class) continue;
            ((SequenceEditingPanelListener)objectArray[i + 1]).hiliteLost(this);
        }
    }

    private void fireSelectioChange(int[] nArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SequenceEditingPanelListener.class) continue;
            ((SequenceEditingPanelListener)objectArray[i + 1]).frameSelectionChange(this, nArray);
        }
    }

    static {
        COLOR_SEPARATOR_HORIZONTAL = COLOR_SEPARATOR_VERTICAL = new Color(204, 218, 228);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FrameSelectionManager
    implements SequenceListener {
        public static final int NONE = -1;
        private ArrayList<Boolean> frameSelections;
        private int anchorSelectionIndex = -1;
        private int leadSelectionIndex = -1;

        public FrameSelectionManager() {
            this.clearSelections();
        }

        public int getAnchorSelectionIndex() {
            return this.anchorSelectionIndex;
        }

        public int getLeadSelectionIndex() {
            return this.leadSelectionIndex;
        }

        public void clearSelections() {
            int n = SequenceEditingPanel.this.sequence.getFrameCount();
            this.frameSelections = new ArrayList();
            this.frameSelections.ensureCapacity(n);
            for (int i = 0; i < n; ++i) {
                this.frameSelections.add(Boolean.FALSE);
            }
            this.anchorSelectionIndex = -1;
            this.leadSelectionIndex = -1;
        }

        public boolean flipSelection(int n) {
            Boolean bl = this.frameSelections.get(n);
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            bl = bl == false;
            this.frameSelections.set(n, bl);
            return bl;
        }

        public void setSelected(int n, boolean bl) {
            this.frameSelections.set(n, bl);
            this.anchorSelectionIndex = bl ? n : -1;
            this.leadSelectionIndex = -1;
        }

        public void setIntervalSelection(int n, int n2, boolean bl) {
            if (n <= n2) {
                for (int i = n; i <= n2; ++i) {
                    this.frameSelections.set(i, bl);
                }
            } else {
                for (int i = n; i >= n2; --i) {
                    this.frameSelections.set(i, bl);
                }
            }
            if (bl) {
                this.anchorSelectionIndex = n;
                this.leadSelectionIndex = n2;
            }
        }

        public boolean isFrameSelected(int n) {
            Boolean bl = this.frameSelections.get(n);
            assert (bl != null);
            return bl;
        }

        public Set<Integer> getSelectedIndexes() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < this.frameSelections.size(); ++i) {
                if (!this.frameSelections.get(i).equals(Boolean.TRUE)) continue;
                hashSet.add(i);
            }
            return hashSet;
        }

        public boolean isSelectionEmpty() {
            return this.frameSelections.isEmpty();
        }

        @Override
        public void frameAdded(Sequence sequence, int n) {
            this.clearSelections();
            this.frameSelections.add(n, true);
        }

        @Override
        public void frameRemoved(Sequence sequence, int n) {
            this.frameSelections.remove(n);
            this.clearSelections();
        }

        @Override
        public void frameModified(Sequence sequence, int n) {
        }

        @Override
        public void framesChanged(Sequence sequence) {
            this.clearSelections();
        }
    }

    private class InsertEmptyFrameAction
    extends AbstractAction {
        public static final String PROP_COL = "PROP_COL";

        private InsertEmptyFrameAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuInsertFrame.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = (Integer)this.getValue(PROP_COL);
            int n2 = SequenceEditingPanel.this.getFrameForColumn(n + 1);
            Sequence sequence = SequenceEditingPanel.this.sequence;
            sequence.insertFrame(null, n2);
        }
    }

    private class TweenAction
    extends AbstractAction {
        public static final String PROP_COL = "PROP_COL";

        private TweenAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuTweenFrames.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = (Integer)this.getValue(PROP_COL);
            int n3 = SequenceEditingPanel.this.getFrameForColumn(n2 - 1);
            int n4 = SequenceEditingPanel.this.getFrameForColumn(n2 + 1);
            Sequence sequence = SequenceEditingPanel.this.sequence;
            StaticTile staticTile = sequence.getFrame(n3);
            StaticTile staticTile2 = sequence.getFrame(n4);
            int n5 = staticTile.getIndex();
            if (n5 == (n = staticTile2.getIndex()) || n5 == n + 1 || n5 == n - 1) {
                return;
            }
            int n6 = 1;
            if (n5 > n) {
                n6 = -1;
            }
            int n7 = n4;
            while ((n5 += n6) != n) {
                ImageResource imageResource = sequence.getImageResource();
                StaticTile staticTile3 = (StaticTile)imageResource.getTile(n5, SequenceEditingPanel.this.frameWidth, SequenceEditingPanel.this.frameHeight, sequence.isZeroBasedIndex());
                sequence.insertFrame(staticTile3, n7);
                SequenceEditingPanel.this.selection.setSelected(n7, true);
                ++n7;
            }
        }
    }

    private class RemoveSelectedAction
    extends AbstractAction {
        private RemoveSelectedAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuRemoveSelectedFrames.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set<Integer> set = SequenceEditingPanel.this.selection.getSelectedIndexes();
            SequenceEditingPanel.this.sequence.removeFrames(set);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public static final String PROP_COL = "PROP_COL";

        private RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuRemoveFrame.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = (Integer)this.getValue(PROP_COL);
            Sequence sequence = SequenceEditingPanel.this.sequence;
            sequence.removeFrame(SequenceEditingPanel.this.getFrameForColumn(n));
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuSelectAll.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Sequence sequence = SequenceEditingPanel.this.sequence;
            SequenceEditingPanel.this.selection.setIntervalSelection(0, sequence.getFrameCount() - 1, true);
            SequenceEditingPanel.this.repaint();
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            SequenceEditingPanel.this.validate();
        }
    }

    private class SequenceDropTargetListener
    implements DropTargetListener {
        private SequenceDropTargetListener() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            SequenceEditingPanel.this.updateHiLite(dropTargetDragEvent.getLocation());
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            SequenceEditingPanel.this.hilitedColumn = -1;
            SequenceEditingPanel.this.repaint();
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            block9: {
                Point point = dropTargetDropEvent.getLocation();
                Transferable transferable = dropTargetDropEvent.getTransferable();
                try {
                    TileDataFlavor tileDataFlavor = new TileDataFlavor();
                    if (transferable.isDataFlavorSupported(tileDataFlavor)) {
                        dropTargetDropEvent.acceptDrop(1);
                        List list = (List)transferable.getTransferData(tileDataFlavor);
                        int n = SequenceEditingPanel.this.getColumnForPoint(point);
                        if (n % 2 == 0) {
                            for (int i = 0; i < list.size(); ++i) {
                                SequenceEditingPanel.this.sequence.insertFrame((StaticTile)list.get(i), (n + i * 2) / 2);
                            }
                        } else {
                            for (Tile tile : list) {
                                SequenceEditingPanel.this.sequence.setFrame((StaticTile)tile, SequenceEditingPanel.this.getFrameForColumn(n));
                            }
                        }
                        dropTargetDropEvent.dropComplete(true);
                        break block9;
                    }
                    dropTargetDropEvent.dropComplete(false);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    dropTargetDropEvent.dropComplete(false);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                    dropTargetDropEvent.dropComplete(false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    dropTargetDropEvent.dropComplete(false);
                }
            }
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            int n = SequenceEditingPanel.this.getColumnForPoint(point);
            int n2 = SequenceEditingPanel.this.getFrameForColumn(n);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            super.dragDropEnd(dragSourceDropEvent);
            if (dragSourceDropEvent.getDropSuccess()) {
                // empty if block
            }
        }
    }
}

