/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.groovy.grailsproject.templates.GrailsTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private static final String FOLDER_TO_DELETE = "folderToDelete";
    private static Logger LOGGER = Logger.getLogger(GrailsTargetChooserPanel.class.getName());
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private GrailsTargetChooserPanelGUI gui;
    private WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private final Project project;
    private final SourceGroup folder;
    private final String suffix;

    public GrailsTargetChooserPanel(Project project, SourceGroup sourceGroup, WizardDescriptor.Panel<WizardDescriptor> panel, String string) {
        this.project = project;
        this.folder = sourceGroup;
        this.suffix = string;
        this.bottomPanel = panel;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new GrailsTargetChooserPanelGUI(this.project, this.folder, this.bottomPanel == null ? null : this.bottomPanel.getComponent());
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx;
        if (this.bottomPanel != null && (helpCtx = this.bottomPanel.getHelp()) != null) {
            return helpCtx;
        }
        return null;
    }

    public boolean isValid() {
        if (this.gui == null) {
            this.setErrorMessage(null);
            return false;
        }
        if (this.gui.getTargetName() == null) {
            this.setInfoMessage("INFO_GrailsTargetChooser_ProvideArtifact");
            return false;
        }
        if (!GrailsTargetChooserPanel.isValidTypeIdentifier(this.gui.getTargetName())) {
            this.setErrorMessage("ERR_GrailsTargetChooser_InvalidArtifactName");
            return false;
        }
        if (!GrailsTargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
            this.setErrorMessage("ERR_GrailsTargetChooser_InvalidPackage");
            return false;
        }
        if (!GrailsTargetChooserPanel.isValidPackage(this.gui.getRootFolder(), this.gui.getPackageName())) {
            this.setErrorMessage("ERR_GrailsTargetChooser_InvalidFolder");
            return false;
        }
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        boolean bl = true;
        FileObject fileObject2 = this.gui.getRootFolder();
        String string = GrailsTargetChooserPanel.canUseFileName(fileObject2, this.gui.getPackageFileName(), this.gui.getTargetName(), this.suffix != null ? this.suffix : "." + fileObject.getExt());
        if (this.gui != null) {
            this.wizard.getNotificationLineSupport().setErrorMessage(string);
        }
        if (string != null) {
            bl = false;
        }
        if (bl && this.bottomPanel != null && !this.bottomPanel.isValid()) {
            return false;
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        Object object;
        this.wizard = wizardDescriptor;
        if (this.gui != null) {
            object = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)wizardDescriptor), (FileObject)object, this.suffix);
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)wizardDescriptor);
        }
        if (this.gui != null && (object = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            wizardDescriptor.putProperty("NewFileWizard_Title", object);
        }
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(object) || WizardDescriptor.CANCEL_OPTION.equals(object) || WizardDescriptor.CLOSED_OPTION.equals(object)) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)wizardDescriptor);
            }
            Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)this.getTargetFolderFromGUI(wizardDescriptor));
            Templates.setTargetName((WizardDescriptor)wizardDescriptor, (String)this.gui.getTargetName());
        }
        wizardDescriptor.putProperty("NewFileWizard_Title", null);
        if (WizardDescriptor.FINISH_OPTION.equals(object)) {
            wizardDescriptor.putProperty(FOLDER_TO_DELETE, null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    private void setErrorMessage(String string) {
        if (string == null) {
            this.wizard.getNotificationLineSupport().clearMessages();
        } else {
            this.wizard.getNotificationLineSupport().setErrorMessage(NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)string));
        }
    }

    private void setInfoMessage(String string) {
        if (string == null) {
            this.wizard.getNotificationLineSupport().clearMessages();
        } else {
            this.wizard.getNotificationLineSupport().setInformationMessage(NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)string));
        }
    }

    private FileObject getTargetFolderFromGUI(WizardDescriptor wizardDescriptor) {
        assert (this.gui != null);
        FileObject fileObject = this.gui.getRootFolder();
        FileObject fileObject2 = null;
        String string = this.gui.getPackageFileName();
        fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            try {
                FileObject fileObject3;
                fileObject2 = fileObject;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                String string2 = null;
                while (stringTokenizer.hasMoreTokens() && (fileObject3 = fileObject2.getFileObject(string2 = stringTokenizer.nextToken(), "")) != null) {
                    fileObject2 = fileObject3;
                }
                fileObject2 = fileObject2.createFolder(string2);
                fileObject3 = (FileObject)wizardDescriptor.getProperty(FOLDER_TO_DELETE);
                if (fileObject3 == null) {
                    wizardDescriptor.putProperty(FOLDER_TO_DELETE, (Object)fileObject2);
                } else if (!fileObject3.equals(fileObject2)) {
                    fileObject3.delete();
                    wizardDescriptor.putProperty(FOLDER_TO_DELETE, (Object)fileObject2);
                }
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    fileObject2 = fileObject2.createFolder(string2);
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
        }
        return fileObject2;
    }

    static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPackage(FileObject fileObject, String string) {
        assert (fileObject != null);
        assert (string != null);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if ((fileObject = fileObject.getFileObject(stringTokenizer.nextToken())) == null) {
                return true;
            }
            if (!fileObject.isData()) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String string) {
        return string != null && !"".equals(string) && Utilities.isJavaIdentifier((String)string);
    }

    public static final String canUseFileName(FileObject fileObject, String string, String string2, String string3) {
        File file;
        CharSequence charSequence;
        String string4 = string2;
        if (string2 != null) {
            string2 = string2.replace('.', '/');
        }
        if (string3 != null && string3.length() > 0) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(string3);
            string2 = ((StringBuilder)charSequence).toString();
        }
        if (string3 != null && string3.length() > 0) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string4);
            ((StringBuilder)charSequence).append(string3);
            string4 = ((StringBuilder)charSequence).toString();
        }
        charSequence = string + "/" + string2;
        if (fileObject == null) {
            return NbBundle.getMessage(GrailsTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        File file2 = file = string != null ? new File(FileUtil.toFile((FileObject)fileObject), string) : FileUtil.toFile((FileObject)fileObject);
        if (file != null ? file.exists() && !file.canWrite() : !fileObject.canWrite()) {
            return NbBundle.getMessage(GrailsTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (GrailsTargetChooserPanel.existFileName(fileObject, (String)charSequence)) {
            return NbBundle.getMessage(GrailsTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)string4);
        }
        return null;
    }

    private static boolean existFileName(FileObject fileObject, String string) {
        boolean bl = false;
        File file = FileUtil.toFile((FileObject)fileObject);
        bl = file.exists() ? new File(file, string).exists() : fileObject.getFileObject(string) != null;
        return bl;
    }
}

