/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.device;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayDataFlavorSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.injector.ScreenInjectorPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.ScreenAccessController;
import org.netbeans.modules.vmd.screen.device.DevicePanel;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopPanel
extends JPanel {
    private static final Color COLOR_SELECTION_DRAW = MainPanel.SELECT_COLOR;
    private static final Color COLOR_HOVER_DRAW = MainPanel.HOVER_COLOR;
    private static final Color COLOR_DRAW_DND_LINE = new Color(36, 76, 114);
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private static final Stroke STROKE_DND_LINE = new BasicStroke(3.0f, 2, 0, 2.0f, new float[]{5.0f, 10.0f}, 0.0f);
    private static final Image IMAGE_INJECT = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/screen/resources/inject.png");
    private DevicePanel devicePanel;
    private List<SelectionShape> selectionShapes = Collections.emptyList();
    private ScreenDeviceInfo.Edge horizontalPosition;
    private ScreenDeviceInfo.Edge verticalPosition;
    private Point lastHoverPoint = null;
    private SelectionShape hoverShape = null;
    private DragSource dragSource;
    private DesignComponent dragedComponent;
    private boolean innerDragingInProgress;

    public TopPanel(final DevicePanel devicePanel) {
        this.devicePanel = devicePanel;
        this.setOpaque(false);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, new DragGestureListener(){

            public void dragGestureRecognized(final DragGestureEvent dragGestureEvent) {
                devicePanel.getController().getDocument().getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        TopPanel.this.dragedComponent = devicePanel.getDesignComponentAt(dragGestureEvent.getDragOrigin());
                        if (TopPanel.this.dragedComponent == null) {
                            return;
                        }
                        ScreenDisplayPresenter screenDisplayPresenter = (ScreenDisplayPresenter)TopPanel.this.dragedComponent.getPresenter(ScreenDisplayPresenter.class);
                        if (screenDisplayPresenter == null || !screenDisplayPresenter.isDraggable()) {
                            TopPanel.this.innerDragingInProgress = false;
                            return;
                        }
                        TopPanel.this.dragSource.startDrag(dragGestureEvent, null, new ScreenDisplaylTransferable(TopPanel.this.dragedComponent), null);
                    }
                });
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (TopPanel.this.injectorWindow(mouseEvent, true)) {
                    return;
                }
                TopPanel.this.select(mouseEvent);
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    TopPanel.this.editProperty(mouseEvent);
                }
                if (mouseEvent.isPopupTrigger()) {
                    TopPanel.this.popupMenu(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (TopPanel.this.injectorWindow(mouseEvent, false)) {
                    return;
                }
                TopPanel.this.select(mouseEvent);
                if (mouseEvent.isPopupTrigger()) {
                    TopPanel.this.popupMenu(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (TopPanel.this.injectorWindow(mouseEvent, false)) {
                    return;
                }
                TopPanel.this.select(mouseEvent);
                if (mouseEvent.isPopupTrigger()) {
                    TopPanel.this.popupMenu(mouseEvent);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                TopPanel.this.hover(mouseEvent.getPoint());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                TopPanel.this.hover(mouseEvent.getPoint());
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                TopPanel.this.hover(mouseEvent.getPoint());
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                TopPanel.this.hover(mouseEvent.getPoint());
            }
        });
        this.setDropTarget(new DropTarget(this, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                if (dropTargetDragEvent.getTransferable().isDataFlavorSupported(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR)) {
                    TopPanel.this.innerDragingInProgress = true;
                }
                TopPanel.this.updatePosition(dropTargetDragEvent.getLocation());
                AcceptSuggestion acceptSuggestion = TopPanel.this.getSugestion(dropTargetDragEvent.getTransferable());
                if (TopPanel.this.isAcceptable(dropTargetDragEvent.getLocation(), dropTargetDragEvent.getTransferable(), acceptSuggestion)) {
                    dropTargetDragEvent.acceptDrag(3);
                } else {
                    dropTargetDragEvent.rejectDrag();
                }
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                TopPanel.this.updatePosition(dropTargetDragEvent.getLocation());
                AcceptSuggestion acceptSuggestion = TopPanel.this.getSugestion(dropTargetDragEvent.getTransferable());
                if (TopPanel.this.isAcceptable(dropTargetDragEvent.getLocation(), dropTargetDragEvent.getTransferable(), acceptSuggestion)) {
                    dropTargetDragEvent.acceptDrag(3);
                    TopPanel.this.hoverDnD(dropTargetDragEvent.getLocation());
                } else {
                    TopPanel.this.hover(dropTargetDragEvent.getLocation());
                    dropTargetDragEvent.rejectDrag();
                }
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                TopPanel.this.updatePosition(dropTargetDragEvent.getLocation());
                AcceptSuggestion acceptSuggestion = TopPanel.this.getSugestion(dropTargetDragEvent.getTransferable());
                if (TopPanel.this.isAcceptable(dropTargetDragEvent.getLocation(), dropTargetDragEvent.getTransferable(), acceptSuggestion)) {
                    dropTargetDragEvent.acceptDrag(3);
                } else {
                    dropTargetDragEvent.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
                TopPanel.this.innerDragingInProgress = false;
                TopPanel.this.hover(TopPanel.this.lastHoverPoint);
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                TopPanel.this.updatePosition(dropTargetDropEvent.getLocation());
                AcceptSuggestion acceptSuggestion = TopPanel.this.getSugestion(dropTargetDropEvent.getTransferable());
                if (TopPanel.this.isAcceptable(dropTargetDropEvent.getLocation(), dropTargetDropEvent.getTransferable(), acceptSuggestion)) {
                    TopPanel.this.accept(dropTargetDropEvent.getLocation(), dropTargetDropEvent.getTransferable(), acceptSuggestion);
                    dropTargetDropEvent.acceptDrop(3);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
                TopPanel.this.innerDragingInProgress = false;
                TopPanel.this.hover(dropTargetDropEvent.getLocation());
            }
        }));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE);
        for (SelectionShape selectionShape : this.selectionShapes) {
            graphics2D.translate(selectionShape.x, selectionShape.y);
            graphics2D.setColor(COLOR_SELECTION_DRAW);
            graphics2D.draw(selectionShape.shape);
            graphics2D.translate(-selectionShape.x, -selectionShape.y);
        }
        if (this.hoverShape != null) {
            graphics2D.translate(this.hoverShape.x, this.hoverShape.y);
            if (this.innerDragingInProgress) {
                int n;
                int n2;
                int n3;
                graphics2D.translate(-this.hoverShape.x, -this.hoverShape.y);
                graphics2D.setColor(COLOR_DRAW_DND_LINE);
                graphics2D.setStroke(STROKE_DND_LINE);
                graphics2D.setColor(COLOR_DRAW_DND_LINE);
                int n4 = 3;
                if (this.verticalPosition == ScreenDeviceInfo.Edge.BOTTOM) {
                    int n5 = this.hoverShape.x + n4;
                    n3 = this.hoverShape.y + (int)this.hoverShape.shape.getBounds().getHeight();
                    n2 = this.hoverShape.x + (int)this.hoverShape.shape.getBounds().getWidth() - n4;
                    n = this.hoverShape.y + (int)this.hoverShape.shape.getBounds().getHeight();
                    graphics2D.drawLine(n5, n3, n2, n);
                } else if (this.verticalPosition == ScreenDeviceInfo.Edge.TOP) {
                    int n6 = this.hoverShape.x + n4;
                    n3 = this.hoverShape.y;
                    n2 = this.hoverShape.x + (int)this.hoverShape.shape.getBounds().getWidth() - n4;
                    n = this.hoverShape.y;
                    graphics2D.drawLine(n6, n3, n2, n);
                }
            } else {
                graphics2D.setColor(COLOR_HOVER_DRAW);
                graphics2D.draw(this.hoverShape.shape);
                graphics2D.translate(-this.hoverShape.x, -this.hoverShape.y);
            }
        }
        graphics2D.setStroke(stroke);
        for (SelectionShape selectionShape : this.selectionShapes) {
            if (!selectionShape.enableInjector) continue;
            graphics2D.translate(selectionShape.x, selectionShape.y);
            Rectangle rectangle = selectionShape.shape.getBounds();
            graphics2D.drawImage(IMAGE_INJECT, rectangle.x + rectangle.width - 20, rectangle.y - 8, null);
            graphics2D.translate(-selectionShape.x, -selectionShape.y);
        }
    }

    public void reload() {
        ScreenAccessController screenAccessController = this.devicePanel.getController();
        DesignComponent designComponent = screenAccessController.getEditedScreen();
        ArrayList<SelectionShape> arrayList = new ArrayList<SelectionShape>();
        this.reloadSelectionShapes(arrayList, designComponent);
        this.selectionShapes = arrayList;
        this.repaint();
    }

    private void reloadSelectionShapes(ArrayList<SelectionShape> arrayList, DesignComponent designComponent) {
        Object object;
        ScreenDisplayPresenter screenDisplayPresenter;
        ScreenDisplayPresenter screenDisplayPresenter2 = screenDisplayPresenter = designComponent != null ? (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class) : null;
        if (screenDisplayPresenter == null) {
            return;
        }
        Collection collection = this.devicePanel.getController().getDocument().getSelectedComponents();
        if (collection.contains(designComponent) && (object = screenDisplayPresenter.getSelectionShape()) != null) {
            Object object2 = this.devicePanel.calculateTranslation(screenDisplayPresenter.getView(), screenDisplayPresenter.getLocation());
            boolean bl = false;
            for (ScreenInjectorPresenter screenInjectorPresenter : designComponent.getPresenters(ScreenInjectorPresenter.class)) {
                if (!screenInjectorPresenter.isEnabled()) continue;
                bl = true;
                break;
            }
            arrayList.add(new SelectionShape(object2.x, object2.y, (Shape)object, designComponent.getComponentID(), bl));
        }
        for (Object object2 : screenDisplayPresenter.getChildren()) {
            this.reloadSelectionShapes(arrayList, (DesignComponent)object2);
        }
    }

    public void select(final MouseEvent mouseEvent) {
        final DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (designDocument == null) {
            return;
        }
        designDocument.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(mouseEvent.getPoint());
                if ((mouseEvent.getModifiers() & 2) == 2) {
                    if (designComponent != null) {
                        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>(designDocument.getSelectedComponents());
                        if (!arrayList.remove(designComponent)) {
                            arrayList.add(designComponent);
                        }
                        designDocument.setSelectedComponents("screen", arrayList);
                    }
                } else if (designComponent == null) {
                    designDocument.setSelectedComponents("screen", Collections.emptySet());
                } else if (!designDocument.getSelectedComponents().contains(designComponent)) {
                    if (designComponent.getPresenter(ScreenDisplayPresenter.class) != null) {
                        ((ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class)).getView().requestFocusInWindow();
                    }
                    designDocument.setSelectedComponents("screen", Collections.singleton(designComponent));
                }
            }
        });
    }

    private void hover(final Point point) {
        this.lastHoverPoint = point != null ? point : null;
        DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (this.lastHoverPoint != null && designDocument != null) {
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    Collection<Object> collection;
                    DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(TopPanel.this.lastHoverPoint);
                    ScreenDisplayPresenter screenDisplayPresenter = designComponent != null ? (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class) : null;
                    Collection<Object> collection2 = collection = screenDisplayPresenter != null ? screenDisplayPresenter.getPropertyDescriptors() : Collections.emptySet();
                    if (collection == null) {
                        return;
                    }
                    for (Object object : collection) {
                        Point point2 = TopPanel.this.devicePanel.calculateTranslation(((ScreenPropertyDescriptor)object).getRelatedView(), ((ScreenPropertyDescriptor)object).getViewLocation());
                        Shape shape = ((ScreenPropertyDescriptor)object).getSelectionShape();
                        if (!shape.contains(new Point(point.x - point2.x, point.y - point2.y))) continue;
                        TopPanel.this.hoverShape = new SelectionShape(point2.x, point2.y, shape, Long.MIN_VALUE, false);
                        return;
                    }
                    if (screenDisplayPresenter != null) {
                        Object object;
                        Point point3 = TopPanel.this.devicePanel.calculateTranslation(screenDisplayPresenter.getView(), screenDisplayPresenter.getLocation());
                        object = screenDisplayPresenter.getSelectionShape();
                        if (object != null) {
                            TopPanel.this.hoverShape = new SelectionShape(point3.x, point3.y, (Shape)object, designComponent.getComponentID(), false);
                            return;
                        }
                    }
                    TopPanel.this.hoverShape = null;
                }
            });
        }
        this.repaint();
    }

    private void hoverDnD(final Point point) {
        this.lastHoverPoint = point != null ? point : null;
        DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (this.lastHoverPoint != null && designDocument != null) {
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(TopPanel.this.lastHoverPoint);
                    ScreenDisplayPresenter screenDisplayPresenter = designComponent != null ? (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class) : null;
                    Point point2 = TopPanel.this.devicePanel.calculateTranslation(screenDisplayPresenter.getView(), screenDisplayPresenter.getLocation());
                    Shape shape = screenDisplayPresenter.getSelectionShape();
                    if (shape != null && shape.contains(new Point(point.x - point2.x, point.y - point2.y))) {
                        TopPanel.this.hoverShape = new SelectionShape(point2.x, point2.y, shape, Long.MIN_VALUE, false);
                        return;
                    }
                    TopPanel.this.hoverShape = null;
                }
            });
        }
        this.repaint();
    }

    private void updatePosition(final Point point) {
        DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (designDocument != null) {
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    ScreenDisplayPresenter screenDisplayPresenter;
                    if (point == null) {
                        return;
                    }
                    DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(point);
                    ScreenDisplayPresenter screenDisplayPresenter2 = screenDisplayPresenter = designComponent != null ? (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class) : null;
                    if (screenDisplayPresenter == null) {
                        return;
                    }
                    Point point2 = TopPanel.this.devicePanel.calculateTranslation(screenDisplayPresenter.getView(), screenDisplayPresenter.getLocation());
                    double d = screenDisplayPresenter.getView().getHeight() / 2;
                    double d2 = screenDisplayPresenter.getView().getWidth() / 2;
                    if (point2.getY() + d > point.getY()) {
                        TopPanel.this.verticalPosition = ScreenDeviceInfo.Edge.TOP;
                    } else if (point2.getY() + d < point.getY()) {
                        TopPanel.this.verticalPosition = ScreenDeviceInfo.Edge.BOTTOM;
                    }
                    if (point2.getX() + d2 > point.getX()) {
                        TopPanel.this.horizontalPosition = ScreenDeviceInfo.Edge.LEFT;
                    } else if (point2.getX() + d2 < point.getX()) {
                        TopPanel.this.horizontalPosition = ScreenDeviceInfo.Edge.RIGHT;
                    }
                }
            });
        }
    }

    public boolean isAcceptable(final Point point, final Transferable transferable, final AcceptSuggestion acceptSuggestion) {
        DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (designDocument == null) {
            return false;
        }
        final boolean[] blArray = new boolean[1];
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(point);
                blArray[0] = AcceptSupport.isAcceptable((DesignComponent)designComponent, (Transferable)transferable, (AcceptSuggestion)acceptSuggestion);
            }
        });
        return blArray[0];
    }

    public void accept(final Point point, final Transferable transferable, final AcceptSuggestion acceptSuggestion) {
        DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (designDocument == null) {
            return;
        }
        designDocument.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(point);
                ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)designComponent, (Transferable)transferable, (AcceptSuggestion)acceptSuggestion);
                AcceptSupport.selectComponentProducerResult((ComponentProducer.Result)result);
            }
        });
    }

    public void popupMenu(final MouseEvent mouseEvent) {
        DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (designDocument == null) {
            return;
        }
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(mouseEvent.getPoint());
                if (designComponent == null) {
                    return;
                }
                JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)designComponent), (Component)TopPanel.this);
                jPopupMenu.show(TopPanel.this, mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    private boolean injectorWindow(MouseEvent mouseEvent, boolean bl) {
        for (SelectionShape selectionShape : this.selectionShapes) {
            if (!selectionShape.enableInjector) continue;
            Rectangle rectangle = selectionShape.shape.getBounds();
            if (!new Rectangle(rectangle.x + rectangle.width - 20, rectangle.y - 8, 16, 16).contains(mouseEvent.getX() - selectionShape.x, mouseEvent.getY() - selectionShape.y)) continue;
            if (bl) {
                this.invokeInjectorWindow(selectionShape.componentID, selectionShape.x + rectangle.x + rectangle.width - 20, selectionShape.y + rectangle.y + 8);
            }
            return true;
        }
        return false;
    }

    private void invokeInjectorWindow(final long l, int n, int n2) {
        final DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (designDocument == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = designDocument.getComponentByUID(l);
                ArrayList arrayList2 = new ArrayList(designComponent.getPresenters(ScreenInjectorPresenter.class));
                DocumentSupport.sortPresentersByOrder(arrayList2);
                for (ScreenInjectorPresenter screenInjectorPresenter : arrayList2) {
                    JComponent jComponent;
                    if (!screenInjectorPresenter.isEnabled() || (jComponent = screenInjectorPresenter.getViewComponent()) == null) continue;
                    arrayList.add(jComponent);
                }
            }
        });
        if (arrayList.isEmpty()) {
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        jPanel.setLayout(new GridBagLayout());
        for (JComponent jComponent : arrayList) {
            jPanel.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 6));
        }
        Point point = this.getLocationOnScreen();
        PopupUtil.showPopup((JComponent)jPanel, (String)NbBundle.getMessage(TopPanel.class, (String)"TITLE_ActionsMenu"), (int)(point.x + n), (int)(point.y + n2), (boolean)true);
    }

    private void editProperty(final MouseEvent mouseEvent) {
        DesignDocument designDocument = this.devicePanel.getController().getDocument();
        if (designDocument == null) {
            return;
        }
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                ScreenDisplayPresenter screenDisplayPresenter;
                DesignComponent designComponent = TopPanel.this.devicePanel.getDesignComponentAt(mouseEvent.getPoint());
                ScreenDisplayPresenter screenDisplayPresenter2 = screenDisplayPresenter = designComponent != null ? (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class) : null;
                if (screenDisplayPresenter == null) {
                    return;
                }
                Collection<ScreenPropertyDescriptor> collection = screenDisplayPresenter.getPropertyDescriptors();
                if (collection == null) {
                    return;
                }
                for (ScreenPropertyDescriptor screenPropertyDescriptor : collection) {
                    JComponent jComponent = screenPropertyDescriptor.getRelatedView();
                    Point point = screenPropertyDescriptor.getViewLocation();
                    Shape shape = screenPropertyDescriptor.getSelectionShape();
                    Point point2 = TopPanel.this.devicePanel.calculateTranslation(jComponent, point);
                    if (!shape.contains(new Point(mouseEvent.getX() - point2.x, mouseEvent.getY() - point2.y))) continue;
                    Rectangle rectangle = shape.getBounds();
                    JComponent jComponent2 = screenPropertyDescriptor.getEditor().createEditorComponent(screenPropertyDescriptor);
                    if (jComponent2 == null) {
                        return;
                    }
                    Insets insets = screenPropertyDescriptor.getEditor().getEditorComponentInsets(jComponent2);
                    rectangle.x -= insets.left;
                    rectangle.width += insets.left + insets.right;
                    rectangle.y -= insets.top;
                    rectangle.height += insets.top + insets.bottom;
                    jComponent2.setPreferredSize(rectangle.getSize());
                    Point point3 = jComponent.getLocationOnScreen();
                    rectangle.translate(point3.x, point3.y);
                    PopupUtil.showPopup((JComponent)jComponent2, (String)NbBundle.getMessage(TopPanel.class, (String)"TITLE_EditorMenu"), (int)rectangle.x, (int)rectangle.y, (boolean)true);
                }
            }
        });
    }

    private AcceptSuggestion getSugestion(final Transferable transferable) {
        final ScreenDisplayPresenter[] screenDisplayPresenterArray = new ScreenDisplayPresenter[1];
        if (!transferable.isDataFlavorSupported(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR)) {
            return null;
        }
        this.devicePanel.getController().getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                try {
                    DesignComponent designComponent = (DesignComponent)transferable.getTransferData(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR);
                    screenDisplayPresenterArray[0] = (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
        if (screenDisplayPresenterArray[0] == null) {
            return null;
        }
        return screenDisplayPresenterArray[0].createSuggestion(transferable);
    }

    private class ScreenDisplaylTransferable
    implements Transferable {
        private List DATA_FLAVORS = Arrays.asList(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR, ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR, ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR);
        private WeakReference<DesignComponent> component;

        public ScreenDisplaylTransferable(DesignComponent designComponent) {
            this.component = new WeakReference<DesignComponent>(designComponent);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])this.DATA_FLAVORS.toArray();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.DATA_FLAVORS.contains(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR) {
                return this.component.get();
            }
            if (dataFlavor == ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR) {
                return TopPanel.this.horizontalPosition;
            }
            if (dataFlavor == ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR) {
                return TopPanel.this.verticalPosition;
            }
            return null;
        }
    }

    private static class SelectionShape {
        private int x;
        private int y;
        private Shape shape;
        private long componentID;
        private boolean enableInjector;

        public SelectionShape(int n, int n2, Shape shape, long l, boolean bl) {
            this.x = n;
            this.y = n2;
            this.shape = shape;
            this.componentID = l;
            this.enableInjector = bl;
        }
    }
}

