/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.upgrade.systemoptions.DefaultResult;
import org.netbeans.upgrade.systemoptions.JUnitContentProcessor;
import org.netbeans.upgrade.systemoptions.PropertyProcessor;
import org.netbeans.upgrade.systemoptions.Result;
import org.netbeans.upgrade.systemoptions.SerParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContentProcessor {
    private static Map<String, ContentProcessor> clsname2Delegate = new HashMap<String, ContentProcessor>();
    protected String systemOptionInstanceName;

    private static void registerContentProcessor(ContentProcessor contentProcessor) {
        if (clsname2Delegate.put(contentProcessor.systemOptionInstanceName, contentProcessor) != null) {
            throw new IllegalArgumentException();
        }
    }

    protected ContentProcessor(String string) {
        this.systemOptionInstanceName = string;
    }

    protected Result parseContent(Iterator<Object> iterator, boolean bl) {
        DefaultResult defaultResult = null;
        try {
            Map<String, Object> map = this.parseProperties(iterator);
            assert (map != null);
            Map<String, String> map2 = this.processProperties(map, bl);
            defaultResult = new DefaultResult(this.systemOptionInstanceName, map2);
        }
        catch (IllegalStateException illegalStateException) {
            Logger.getLogger(ContentProcessor.class.getName()).log(Level.WARNING, this.systemOptionInstanceName + " not parsed", illegalStateException);
        }
        return defaultResult;
    }

    static Result parseContent(String string, boolean bl, Iterator<Object> iterator) {
        ContentProcessor contentProcessor = clsname2Delegate.get(string);
        if (contentProcessor == null) {
            contentProcessor = new ContentProcessor(string);
        }
        return contentProcessor.parseContent(iterator, bl);
    }

    private final Map<String, String> processProperties(Map<String, Object> map, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            hashMap.putAll(PropertyProcessor.processProperty(string, object, bl));
        }
        return hashMap;
    }

    private final Map<String, Object> parseProperties(Iterator<Object> iterator) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if ("null".equals(object) || object == null) {
                return hashMap;
            }
            if (!(object instanceof String)) {
                throw new IllegalStateException(object.getClass().getName());
            }
            if (!iterator.hasNext()) {
                throw new IllegalStateException(object.toString());
            }
            Object object2 = iterator.next();
            hashMap.put((String)object, object2);
            Object object3 = iterator.next();
            if (!(object3 instanceof SerParser.ObjectWrapper)) {
                throw new IllegalStateException(object3.getClass().getName());
            }
            SerParser.ObjectWrapper objectWrapper = (SerParser.ObjectWrapper)object3;
            if (objectWrapper.classdesc.name.endsWith("java.lang.Boolean;")) continue;
            throw new IllegalStateException(objectWrapper.classdesc.name);
        }
        throw new IllegalStateException("Unexpected end");
    }

    static {
        ContentProcessor.registerContentProcessor(new JUnitContentProcessor("org.netbeans.modules.junit.JUnitSettings"));
    }
}

