/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;

public class X11ForwardingChecker {
    private final ExecutionEnvironment execEnv;

    public X11ForwardingChecker(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
    }

    public boolean check() throws IOException, CancellationException {
        CndUtils.assertNonUiThread();
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            ConnectionManager.getInstance().connectTo(this.execEnv);
        }
        if (!this.check6000()) {
            return false;
        }
        return this.checkSshdConfig();
    }

    private boolean checkSshdConfig() {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.execEnv, "grep -i X11Forwarding /etc/ssh/sshd_config");
        int n = remoteCommandSupport.run();
        if (n == 0) {
            String[] stringArray;
            for (String string : stringArray = remoteCommandSupport.getOutput().split("\n")) {
                String string2;
                if (!string.startsWith("X11Forwarding") || !"no".equalsIgnoreCase(string2 = string.substring("X11Forwarding".length()).trim())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean check6000() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            int n = 6000;
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
            Socket socket = new Socket();
            socket.connect(inetSocketAddress, 1000);
            boolean bl = socket.isConnected();
            socket.close();
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

