/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.microedition.m2g.SVGImage;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGListCellRenderer;
import org.netbeans.modules.vmd.midpnb.screen.display.UpdatableSVGComponentDisplayPresenter;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGListDisplayPresenter
extends UpdatableSVGComponentDisplayPresenter {
    private static final String CONTENT = "content";
    private static final String HIDDEN_TEXT = "hidden_text";
    private static final String BOUNDS = "bound";
    private static final String CONTENT_SUFFIX = "_content";
    private static final String BOUNDS_SUFIX = "_bound";
    private static final String HIDDEN_TEXT_SUFFIX = "_hidden_text";
    protected static final String TRAIT_FONT_SIZE = "font-size";
    protected static final String TRAIT_FONT_FAMILY = "font-family";
    protected static final String TEXT = "text";
    public static final String METADATA_METADATA = "text";
    public static final String METADATA_DISPLAY = "display";
    public static final String METADATA_NONE = "none";

    @Override
    protected void reloadSVGComponent(SVGImage sVGImage, DesignComponent designComponent, String string) {
        SVGLocatableElement sVGLocatableElement = (SVGLocatableElement)Util.getElementById((SVGImage)sVGImage, (String)(string + HIDDEN_TEXT_SUFFIX));
        SVGLocatableElement sVGLocatableElement2 = (SVGLocatableElement)Util.getElementById((SVGImage)sVGImage, (String)(string + BOUNDS_SUFIX));
        SVGLocatableElement sVGLocatableElement3 = (SVGLocatableElement)Util.getElementById((SVGImage)sVGImage, (String)(string + CONTENT_SUFFIX));
        if (sVGLocatableElement == null || sVGLocatableElement2 == null) {
            return;
        }
        float f = sVGLocatableElement.getFloatTrait(TRAIT_FONT_SIZE);
        int n = (int)(sVGLocatableElement2.getBBox().getHeight() / f);
        SVGListCellRenderer sVGListCellRenderer = new SVGListCellRenderer(sVGImage.getDocument(), f, sVGLocatableElement, sVGLocatableElement2, sVGLocatableElement3);
        List<String> list = this.getListModelElements(designComponent);
        this.renderList(list, sVGListCellRenderer, n);
    }

    private Vector<SVGLocatableElement> renderList(List<String> list, SVGListCellRenderer sVGListCellRenderer, int n) {
        sVGListCellRenderer.clearContent();
        Vector<SVGLocatableElement> vector = new Vector<SVGLocatableElement>();
        int n2 = list.size();
        if (n2 == 0) {
            return vector;
        }
        int n3 = 0;
        do {
            SVGLocatableElement sVGLocatableElement = sVGListCellRenderer.getCellRendererComponent(list.get(n3), n3);
            vector.addElement(sVGLocatableElement);
        } while (++n3 < Math.min(n, n2));
        return vector;
    }

    public SVGRect getBounds(SVGLocatableElement sVGLocatableElement) {
        if (sVGLocatableElement == null) {
            return null;
        }
        SVGRect sVGRect = sVGLocatableElement.getScreenBBox();
        return sVGRect;
    }

    private List<String> getListModelElements(DesignComponent designComponent) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (SVGListCD.TYPEID != designComponent.getType()) {
            return arrayList;
        }
        PropertyValue propertyValue = designComponent.readProperty("listElements");
        if (propertyValue == null) {
            return arrayList;
        }
        if (propertyValue.getKind().equals((Object)PropertyValue.Kind.USERCODE)) {
            arrayList.add("<code>");
        } else {
            List list = propertyValue.getArray();
            if (list == null || list.isEmpty()) {
                return arrayList;
            }
            for (PropertyValue propertyValue2 : list) {
                PropertyValue propertyValue3 = propertyValue2.getComponent().readProperty("name");
                arrayList.add((String)propertyValue3.getPrimitiveValue());
            }
        }
        return arrayList;
    }
}

