/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.utils.Iterators;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.KenaiImpl;
import org.netbeans.modules.kenai.KenaiREST;
import org.netbeans.modules.kenai.LicensesListData;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.ServicesListData;
import org.netbeans.modules.kenai.UserData;
import org.netbeans.modules.kenai.api.KenaiActivity;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.api.Persistence;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Kenai {
    public static final String PROP_LOGIN = "login";
    public static final String PROP_XMPP_LOGIN = "xmpp_login";
    public static final String PROP_LOGIN_STARTED = "login_started";
    public static final String PROP_XMPP_LOGIN_STARTED = "xmpp_login_started";
    public static final String PROP_LOGIN_FAILED = "login_failed";
    public static final String PROP_XMPP_LOGIN_FAILED = "xmpp_login_failed";
    public static final String PROP_URL_CHANGED = "url";
    private static Kenai instance;
    private PasswordAuthentication auth = null;
    private KenaiImpl impl;
    private XMPPConnection xmppConnection;
    private PacketListener packetListener;
    private static Preferences prefs;
    private static final String DEFAULT_INSTANCE_PREF = "kenai.default.instance";
    private static final String INSTANCES_PREF = "kenai.instances";
    final HashMap<String, WeakReference<KenaiProject>> projectsCache = new HashMap();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    Collection<KenaiProject> myProjects = null;

    public static synchronized Kenai getDefault() {
        if (instance == null) {
            try {
                String string = prefs.get(DEFAULT_INSTANCE_PREF, "https://kenai.com/");
                string = System.getProperty("kenai.com.url", string);
                assert (string.startsWith("https://")) : "the only supported protocol is https";
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                URL uRL = new URL(string);
                KenaiREST kenaiREST = new KenaiREST(uRL);
                instance = new Kenai(kenaiREST);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return instance;
    }

    public URL getUrl() {
        return this.impl.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUrl(URL uRL) {
        try {
            if (this.impl.getUrl().toURI().equals(uRL.toURI())) {
                return;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        if (this.getStatus() != Status.OFFLINE) {
            this.logout(true);
        }
        URL uRL2 = this.impl.getUrl();
        Class<Kenai> clazz = Kenai.class;
        synchronized (Kenai.class) {
            this.impl = new KenaiREST(uRL);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            prefs.put(DEFAULT_INSTANCE_PREF, uRL.toString());
            this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_URL_CHANGED, null, this.impl.getUrl()));
            return;
        }
    }

    public String getName() {
        String string = prefs.get(INSTANCES_PREF, "");
        if (string.length() > 1) {
            for (String string2 : string.split(";")) {
                if (string2.length() <= 0) continue;
                String[] stringArray = string2.split(",");
                if (!string2.split(",")[0].equals(this.getUrl().toString())) continue;
                return stringArray[1];
            }
        }
        return this.getUrl().toString().substring("https://".length());
    }

    Kenai(KenaiImpl kenaiImpl) {
        this.impl = kenaiImpl;
    }

    public synchronized XMPPConnection getXMPPConnection() {
        return this.xmppConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String string, char[] cArray, boolean bl) throws KenaiException {
        if (this.auth != null && Arrays.equals(cArray, this.auth.getPassword()) && string.equals(this.auth.getUserName())) {
            if (bl && this.xmppConnection != null && this.xmppConnection.isConnected()) {
                return;
            }
            if (bl) {
                this.xmppConnect();
                return;
            }
            if (!bl && this.xmppConnection == null) {
                return;
            }
            this.xmppDisconnect(false);
            return;
        }
        PasswordAuthentication passwordAuthentication = this.auth;
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN_STARTED, null, string));
        try {
            Kenai kenai = this;
            synchronized (kenai) {
                String string2 = this.impl.verify(string, cArray);
                this.auth = new PasswordAuthentication(string2, cArray);
                this.myProjects = null;
                if (bl) {
                    this.xmppConnect();
                }
            }
        }
        catch (KenaiException kenaiException) {
            this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN_FAILED, null, null));
            throw kenaiException;
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN, passwordAuthentication, this.auth));
    }

    public void login(String string, char[] cArray) throws KenaiException {
        this.login(string, cArray, true);
    }

    public void logout() {
        this.logout(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logout(boolean bl) {
        PasswordAuthentication passwordAuthentication = this.auth;
        Object object = this;
        synchronized (object) {
            this.auth = null;
            this.myProjects = null;
            this.xmppDisconnect(bl);
        }
        object = new PropertyChangeEvent(this, PROP_LOGIN, passwordAuthentication, this.auth);
        if (bl) {
            ((PropertyChangeEvent)object).setPropagationId(PROP_URL_CHANGED);
        }
        this.propertyChangeSupport.firePropertyChange((PropertyChangeEvent)object);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void register(String string, char[] cArray) throws KenaiException {
        this.impl.register(string, cArray);
    }

    public Collection<KenaiProject> searchProjects(String string) throws KenaiException {
        Collection<ProjectData> collection = this.impl.searchProjects(string);
        return new LazyCollection(collection);
    }

    Collection<KenaiProjectMember> getProjectMembers(String string) throws KenaiException {
        Collection<UserData> collection = this.impl.getProjectMembers(string);
        return new LazyCollection(collection);
    }

    public Collection<KenaiLicense> getLicenses() throws KenaiException {
        Collection<LicensesListData.LicensesListItem> collection = this.impl.getLicenses();
        return new LazyCollection(collection);
    }

    public Collection<KenaiService> getServices() throws KenaiException {
        Collection<ServicesListData.ServicesListItem> collection = this.impl.getServices();
        return new LazyCollection(collection);
    }

    public KenaiProject getProject(String string, boolean bl) throws KenaiException {
        if (bl) {
            return this._getProject(string);
        }
        KenaiProject kenaiProject = KenaiProject.get(string);
        if (kenaiProject != null) {
            return kenaiProject;
        }
        return this._getProject(string);
    }

    public KenaiProject getProject(String string) throws KenaiException {
        return this.getProject(string, false);
    }

    ProjectData getDetails(String string) throws KenaiException {
        return this.impl.getProject(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KenaiProject createProject(String string, String string2, String string3, String[] stringArray, String string4) throws KenaiException {
        if (this.auth.getUserName() == null) {
            throw new KenaiException("Guest user is not allowed to create new domains");
        }
        ProjectData projectData = this.impl.createProject(string, string2, string3, stringArray, string4);
        KenaiProject kenaiProject = KenaiProject.get(projectData);
        Kenai kenai = this;
        synchronized (kenai) {
            if (this.myProjects != null) {
                this.myProjects.add(kenaiProject);
            }
        }
        return kenaiProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void joinProject(KenaiProject kenaiProject) throws KenaiException {
        if (this.getStatus() == Status.OFFLINE) {
            throw new KenaiException("Cannot join project. You must be logged in");
        }
        this.impl.joinProject(kenaiProject.getName(), this.auth.getUserName());
        Kenai kenai = this;
        synchronized (kenai) {
            if (this.myProjects != null) {
                this.myProjects.add(kenaiProject);
            }
        }
    }

    KenaiFeature createProjectFeature(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws KenaiException {
        if (this.getPasswordAuthentication() == null) {
            throw new KenaiException("Guest user is not allowed to create new domains");
        }
        FeatureData featureData = this.impl.createProjectFeature(string, string2, string3, string4, string6, string7, string8, string5);
        return new KenaiFeature(featureData);
    }

    String checkName(String string) throws KenaiException {
        return this.impl.checkName(string);
    }

    public boolean isAuthorized(KenaiProject kenaiProject, KenaiActivity kenaiActivity) throws KenaiException {
        return this.impl.isAuthorized(kenaiProject.getName(), kenaiActivity.getFeature().getId(), kenaiActivity.getName());
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.auth;
    }

    public synchronized Collection<KenaiProject> getMyProjects() throws KenaiException {
        if (this.auth == null) {
            return Collections.emptyList();
        }
        if (this.myProjects != null) {
            return this.myProjects;
        }
        return this.getMyProjects(true);
    }

    public Status getStatus() {
        if (this.auth == null) {
            return Status.OFFLINE;
        }
        if (this.xmppConnection == null) {
            return Status.LOGGED_IN;
        }
        return Status.ONLINE;
    }

    public synchronized Collection<KenaiProject> getMyProjects(boolean bl) throws KenaiException {
        if (this.auth == null) {
            return Collections.emptyList();
        }
        if (!bl) {
            return this.getMyProjects();
        }
        Collection<ProjectData> collection = this.impl.getMyProjects();
        this.myProjects = new LinkedList<KenaiProject>(new LazyCollection(collection));
        return this.myProjects;
    }

    Collection<KenaiProject> loadProjects() {
        return Persistence.getInstance().loadProjects();
    }

    void storeProjects(Collection<KenaiProject> collection) {
        Persistence.getInstance().storeProjects(collection);
    }

    private KenaiProject _getProject(String string) throws KenaiException {
        ProjectData projectData = this.impl.getProject(string);
        return KenaiProject.get(projectData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmppConnect() throws KenaiException {
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN_STARTED, null, null));
        Kenai kenai = this;
        synchronized (kenai) {
            this.xmppConnection = new XMPPConnection(this.getUrl().getHost());
            this.packetListener = new KenaiUser.KenaiPacketListener();
            try {
                this.xmppConnection.removePacketListener(this.packetListener);
                this.xmppConnection.connect();
                this.xmppConnection.addPacketListener(this.packetListener, (PacketFilter)new PacketTypeFilter(Presence.class));
                this.xmppConnection.login(this.auth.getUserName(), new String(this.auth.getPassword()), "NetBeans");
            }
            catch (XMPPException xMPPException) {
                this.xmppConnection = null;
                this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN_FAILED, null, null));
                throw new KenaiException(xMPPException);
            }
            catch (IllegalStateException illegalStateException) {
                this.xmppConnection = null;
                this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN_FAILED, null, null));
                throw new KenaiException(illegalStateException);
            }
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN, null, this.xmppConnection));
    }

    private void xmppDisconnect(boolean bl) {
        if (this.xmppConnection == null) {
            return;
        }
        this.xmppConnection.disconnect();
        KenaiUser.clear();
        XMPPConnection xMPPConnection = this.xmppConnection;
        this.xmppConnection = null;
        xMPPConnection.removePacketListener(this.packetListener);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_XMPP_LOGIN, xMPPConnection, null);
        if (bl) {
            propertyChangeEvent.setPropagationId(PROP_URL_CHANGED);
        }
        this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    static {
        prefs = NbPreferences.forModule(Kenai.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ONLINE,
        LOGGED_IN,
        OFFLINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyCollection<I, O>
    extends AbstractCollection<O> {
        private Collection<I> delegate;

        private LazyCollection(Collection<I> collection) {
            this.delegate = collection;
        }

        @Override
        public Iterator<O> iterator() {
            return Iterators.translating(this.delegate.iterator(), new Factory<O, I>(){

                @Override
                public O create(I i) {
                    if (i instanceof ProjectData) {
                        return KenaiProject.get((ProjectData)i);
                    }
                    if (i instanceof LicensesListData.LicensesListItem) {
                        return new KenaiLicense((LicensesListData.LicensesListItem)i);
                    }
                    if (i instanceof ServicesListData.ServicesListItem) {
                        return new KenaiService((ServicesListData.ServicesListItem)i);
                    }
                    if (i instanceof UserData) {
                        return new KenaiProjectMember((UserData)i);
                    }
                    throw new IllegalStateException();
                }
            });
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

