/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.codeviation.commons.utils.StreamUtil;

public class ZipUtil {
    private static final int BUFFER_SIZE = 2048;

    public static void zip(File file, OutputStream outputStream) throws IOException {
        ZipUtil.zip(file, outputStream, true);
    }

    public static void zip(File file, OutputStream outputStream, boolean bl) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        if (!bl && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                ZipUtil.add("", file2, zipOutputStream);
            }
        } else {
            ZipUtil.add("", file, zipOutputStream);
        }
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    public static void unzip(InputStream inputStream, File file) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        byte[] byArray = new byte[2048];
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            System.out.println("" + zipEntry.getName() + ":" + " " + zipEntry.getSize());
            if (zipEntry.isDirectory()) {
                new File(file, zipEntry.getName()).mkdirs();
            } else {
                File file2 = new File(file, zipEntry.getName());
                if (!file2.getParentFile().isDirectory()) {
                    file2.getParentFile().mkdirs();
                }
                file2.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                int n = -1;
                do {
                    if ((n = zipInputStream.read(byArray)) == -1) continue;
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    fileOutputStream.flush();
                } while (n != -1);
                ((OutputStream)fileOutputStream).close();
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    private static void add(String string, File file, ZipOutputStream zipOutputStream) throws IOException {
        string = string + "/" + file.getName();
        if (file.isFile()) {
            zipOutputStream.putNextEntry(new ZipEntry(string));
            StreamUtil.copy(new FileInputStream(file), zipOutputStream);
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
            } else {
                for (File file2 : fileArray) {
                    ZipUtil.add(string, file2, zipOutputStream);
                }
            }
        }
    }
}

