/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueProcessor<E>
implements Runnable,
Iterable<E> {
    private volatile int rt;
    private LinkedBlockingQueue<E> q;
    private Semaphore s;
    private String name;
    private int permits;
    private volatile boolean stop;
    private Thread t;

    public QueueProcessor(String string, int n) {
        this.name = string;
        this.q = new LinkedBlockingQueue();
        this.s = n == -1 ? null : new Semaphore(n, true);
        this.permits = n;
    }

    public synchronized void start() {
        this.t = new Thread((Runnable)this, this.name);
        this.t.start();
    }

    public synchronized void stop() {
        this.stop = true;
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    public void add(E e) {
        this.q.add(e);
    }

    public int size() {
        return this.q.size();
    }

    public int runningTasks() {
        return this.rt;
    }

    @Override
    public Iterator<E> iterator() {
        return this.q.iterator();
    }

    public boolean isDone() {
        return this.q.isEmpty() && !this.s.hasQueuedThreads();
    }

    protected abstract void processEvent(E var1);

    @Override
    public void run() {
        while (!this.stop) {
            try {
                E e = this.q.take();
                if (this.s != null) {
                    this.s.acquire();
                }
                Processor processor = new Processor(e);
                new Thread(processor).start();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Processor
    implements Runnable {
        private E e;

        public Processor(E e) {
            this.e = e;
        }

        @Override
        public void run() {
            QueueProcessor.this.rt++;
            QueueProcessor.this.processEvent(this.e);
            if (QueueProcessor.this.s != null) {
                QueueProcessor.this.s.release();
            }
            QueueProcessor.this.rt--;
        }
    }
}

