/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.visual.model.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssRuleContent {
    private final List<PropertyChangeListener> LISTENERS = new ArrayList<PropertyChangeListener>();
    private final CssRule rule;

    public static CssRuleContent create(CssRule cssRule) {
        return new CssRuleContent(cssRule);
    }

    private CssRuleContent(CssRule cssRule) {
        this.rule = cssRule;
    }

    public CssRule rule() {
        return this.rule;
    }

    public List<CssRuleItem> ruleItems() {
        return this.rule.items();
    }

    public String getProperty(String string) {
        CssRuleItem cssRuleItem = this.findItem(string);
        if (cssRuleItem != null) {
            return cssRuleItem.value().name();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof CssRuleContent) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void modifyProperty(String string, String string2) throws BadLocationException {
        CssRuleItem cssRuleItem = this.findItem(string);
        string2 = string2.trim();
        if (cssRuleItem == null && string2.length() == 0) {
            return;
        }
        if (cssRuleItem != null && string2.length() == 0) {
            this.firePropertyChange(cssRuleItem, null);
        } else {
            String string3;
            String string4 = string3 = cssRuleItem == null ? null : cssRuleItem.value().name();
            if (string3 == null || !string2.equals(string3)) {
                CssRuleItem cssRuleItem2 = new CssRuleItem(string, string2);
                this.firePropertyChange(cssRuleItem, cssRuleItem2);
            }
        }
    }

    public String getFormattedString() {
        StringWriter stringWriter = new StringWriter();
        for (CssRuleItem cssRuleItem : this.ruleItems()) {
            String string = cssRuleItem.key().name();
            String string2 = cssRuleItem.value().name().trim();
            if (!string2.equals(Utils.NOT_SET) && !string2.equals("")) {
                stringWriter.write("   " + string);
                stringWriter.write(": ");
                stringWriter.write(string2);
                stringWriter.write("; ");
            }
            stringWriter.write("\n");
        }
        return stringWriter.toString();
    }

    public String toString() {
        return this.getFormattedString();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.LISTENERS.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.LISTENERS.remove(propertyChangeListener);
    }

    private synchronized void firePropertyChange(CssRuleItem cssRuleItem, CssRuleItem cssRuleItem2) {
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(this.LISTENERS);
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "property", cssRuleItem, cssRuleItem2));
        }
    }

    private CssRuleItem findItem(String string) {
        for (CssRuleItem cssRuleItem : this.ruleItems()) {
            if (!cssRuleItem.key().name().equals(string)) continue;
            return cssRuleItem;
        }
        return null;
    }
}

