/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import hidden.org.codehaus.plexus.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;

public final class RepositoryUtil {
    private static Logger LOGGER = Logger.getLogger(RepositoryUtil.class.getName());

    private RepositoryUtil() {
    }

    public static Artifact createArtifact(NBVersionInfo nBVersionInfo) {
        return RepositoryUtil.createArtifact(nBVersionInfo, null);
    }

    public static Artifact createJavadocArtifact(NBVersionInfo nBVersionInfo) {
        return RepositoryUtil.createArtifact(nBVersionInfo, "javadoc");
    }

    private static Artifact createArtifact(NBVersionInfo nBVersionInfo, String string) {
        MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
        Artifact artifact = nBVersionInfo.getClassifier() != null || string != null ? mavenEmbedder.createArtifactWithClassifier(nBVersionInfo.getGroupId(), nBVersionInfo.getArtifactId(), nBVersionInfo.getVersion(), nBVersionInfo.getType() != null ? nBVersionInfo.getType() : "jar", string == null ? nBVersionInfo.getClassifier() : string) : mavenEmbedder.createArtifact(nBVersionInfo.getGroupId(), nBVersionInfo.getArtifactId(), nBVersionInfo.getVersion(), null, nBVersionInfo.getType() != null ? nBVersionInfo.getType() : "jar");
        ArtifactRepository artifactRepository = mavenEmbedder.getLocalRepository();
        String string2 = artifactRepository.pathOf(artifact);
        artifact.setFile(new File(artifactRepository.getBasedir(), string2));
        return artifact;
    }

    public static String calculateMD5Checksum(File file) throws IOException {
        byte[] byArray = RepositoryUtil.readFile(file);
        String string = DigestUtils.md5Hex((byte[])byArray);
        return string;
    }

    public static String calculateSHA1Checksum(File file) throws IOException {
        byte[] byArray = RepositoryUtil.readFile(file);
        String string = DigestUtils.shaHex((byte[])byArray);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[(int)file.length()];
        try {
            fileInputStream = new FileInputStream(file);
            int n = 0;
            for (int i = 0; i < byArray.length && (n = ((InputStream)fileInputStream).read(byArray, i, byArray.length - i)) >= 0; i += n) {
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fileInputStream);
            throw throwable;
        }
        IOUtil.close((InputStream)fileInputStream);
        return byArray;
    }

    @Deprecated
    public static MavenProject readMavenProject(String string, String string2, String string3, ArtifactRepository artifactRepository) {
        MavenProject mavenProject = null;
        try {
            MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
            ArtifactFactory artifactFactory = (ArtifactFactory)mavenEmbedder.getPlexusContainer().lookup(ArtifactFactory.class);
            Artifact artifact = artifactFactory.createProjectArtifact(string, string2, string3, null);
            MavenProjectBuilder mavenProjectBuilder = (MavenProjectBuilder)mavenEmbedder.getPlexusContainer().lookup(MavenProjectBuilder.class);
            mavenProject = mavenProjectBuilder.buildFromRepository(artifact, new ArrayList(), artifactRepository);
        }
        catch (InvalidProjectModelException invalidProjectModelException) {
            LOGGER.log(Level.FINE, "Failed to load project model from repository.", invalidProjectModelException);
        }
        catch (ProjectBuildingException projectBuildingException) {
            LOGGER.log(Level.FINE, "Failed to load project model from repository.", projectBuildingException);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Failed to load project model from repository.", exception);
        }
        return mavenProject;
    }
}

