/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIndexTransferListener
implements TransferListener {
    private ProgressHandle handle;
    private RepositoryInfo info;
    private int lastunit;
    private boolean debug;
    private InputOutput io;
    private OutputWriter writer;
    private int units;
    private static Map<Thread, Integer> transfers = new HashMap<Thread, Integer>();
    private static final Object TRANSFERS_LOCK = new Object();

    public RemoteIndexTransferListener(RepositoryInfo repositoryInfo) {
        this.info = repositoryInfo;
        if (this.debug) {
            this.io = IOProvider.getDefault().getIO(NbBundle.getMessage(RemoteIndexTransferListener.class, (String)"LBL_Transfer_TAG") + repositoryInfo.getName(), true);
            this.writer = this.io.getOut();
        }
    }

    public void transferInitiated(TransferEvent transferEvent) {
    }

    public void transferStarted(TransferEvent transferEvent) {
        long l = transferEvent.getResource().getContentLength();
        this.handle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(RemoteIndexTransferListener.class, (String)"LBL_Transfer_TAG") + this.info.getName()));
        this.units = (int)l / 1024;
        this.handle.start(this.units);
        if (this.debug) {
            this.writer.println("File Size :" + (int)l / 1024);
        }
    }

    public void transferProgress(TransferEvent transferEvent, byte[] byArray, int n) {
        int n2 = n / 1024;
        if (this.handle != null) {
            this.handle.progress(Math.min(this.units, this.lastunit += n2));
        }
        if (this.debug) {
            this.writer.println("Units completed :" + this.lastunit);
        }
    }

    public void transferCompleted(TransferEvent transferEvent) {
        if (this.handle != null) {
            this.handle.finish();
        }
        if (this.debug) {
            this.writer.println("Completed");
        }
    }

    public void transferError(TransferEvent transferEvent) {
        if (this.debug) {
            this.writer.println("Finish with Errors");
        }
    }

    public void debug(String string) {
        if (this.debug) {
            this.writer.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToActive(Thread thread) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer n = transfers.get(thread);
            n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
            transfers.put(thread, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromActive(Thread thread) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer n = transfers.get(thread);
            if (n == null) {
                return;
            }
            if (n <= 1) {
                transfers.remove(thread);
            } else {
                n = n - 1;
                transfers.put(thread, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Thread> getActiveTransfersOrScans() {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            return transfers.keySet();
        }
    }
}

