/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.WeakListeners;

public final class ProxyPreferences
extends AbstractPreferences {
    private static final Logger LOG = Logger.getLogger(ProxyPreferences.class.getName());
    private static final String[] EMPTY = new String[0];
    private final Preferences[] delegates;
    private final Preferences[] roots;
    private final String[] paths;
    private final PreferenceChangeListener[] prefTrackers;

    public ProxyPreferences(Preferences ... preferencesArray) {
        this("", null, preferencesArray);
    }

    protected void putSpi(String string, String string2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String getSpi(String string) {
        this.checkDelegates();
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.delegates[i] == null) continue;
            try {
                String string2 = this.delegates[i].get(string, null);
                if (string2 == null) continue;
                return string2;
            }
            catch (Exception exception) {
                this.delegates[i] = null;
            }
        }
        return null;
    }

    protected void removeSpi(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void removeNodeSpi() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String[] keysSpi() throws BackingStoreException {
        HashSet<String> hashSet = new HashSet<String>();
        this.checkDelegates();
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.delegates[i] == null) continue;
            try {
                hashSet.addAll(Arrays.asList(this.delegates[i].keys()));
                continue;
            }
            catch (Exception exception) {
                this.delegates[i] = null;
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        return EMPTY;
    }

    protected AbstractPreferences childSpi(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void syncSpi() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void flushSpi() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private ProxyPreferences(String string, ProxyPreferences proxyPreferences, Preferences ... preferencesArray) {
        super(proxyPreferences, string);
        assert (preferencesArray.length > 0) : "There must be at least one delegate";
        this.delegates = preferencesArray;
        this.roots = new Preferences[preferencesArray.length];
        this.paths = new String[preferencesArray.length];
        this.prefTrackers = new PreferenceChangeListener[preferencesArray.length];
        for (int i = 0; i < preferencesArray.length; ++i) {
            this.roots[i] = preferencesArray[i].node("/");
            this.paths[i] = preferencesArray[i].absolutePath();
            this.prefTrackers[i] = new PrefTracker(i);
            preferencesArray[i].addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefTrackers[i], (Object)preferencesArray[i]));
        }
    }

    private void checkDelegates() {
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.delegates[i] != null) {
                try {
                    if (this.delegates[i].nodeExists("")) {
                        continue;
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                this.delegates[i] = null;
            }
            assert (this.delegates[i] == null);
            try {
                if (!this.roots[i].nodeExists(this.paths[i])) continue;
                this.delegates[i] = this.roots[i].node(this.paths[i]);
                continue;
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    private void firePrefChange(String string, String string2) {
        try {
            Method method = AbstractPreferences.class.getDeclaredMethod("enqueuePreferenceChangeEvent", String.class, String.class);
            method.setAccessible(true);
            method.invoke((Object)this, string, string2);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, null, exception);
        }
    }

    private class PrefTracker
    implements PreferenceChangeListener {
        private final int delegateIdx;

        public PrefTracker(int n) {
            this.delegateIdx = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            Object object = ProxyPreferences.this.lock;
            synchronized (object) {
                if (preferenceChangeEvent.getKey() != null) {
                    ProxyPreferences.this.checkDelegates();
                    for (int i = 0; i < this.delegateIdx; ++i) {
                        if (ProxyPreferences.this.delegates[i] == null || ProxyPreferences.this.delegates[i].get(preferenceChangeEvent.getKey(), null) == null) continue;
                        return;
                    }
                }
            }
            ProxyPreferences.this.firePrefChange(preferenceChangeEvent.getKey(), preferenceChangeEvent.getNewValue());
        }
    }
}

