/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.util;

import java.io.File;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpElement;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SymfonyUtils {
    public static final String ACTION_METHOD_PREFIX = "execute";
    private static final String FILE_ACTION = "actions.class.php";
    private static final String FILE_ACTION_RELATIVE = "../actions/actions.class.php";
    private static final String DIR_TEMPLATES = "templates";
    private static final String VIEW_FILE_SUFFIX = "Success.php";
    private static final String FILE_VIEW = "../templates/%sSuccess.php";
    private static final String FILE_DEFAULT_VIEW = "index";

    private SymfonyUtils() {
    }

    public static boolean isView(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        return DIR_TEMPLATES.equals(file.getParentFile().getName());
    }

    public static boolean isViewWithAction(FileObject fileObject) {
        return SymfonyUtils.isView(fileObject) && SymfonyUtils.getAction(fileObject) != null;
    }

    public static boolean isAction(FileObject fileObject) {
        return FILE_ACTION.equals(fileObject.getNameExt());
    }

    public static FileObject getAction(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject).getParentFile();
        File file2 = PropertyUtils.resolveFile((File)file, (String)FILE_ACTION_RELATIVE);
        if (file2.isFile()) {
            return FileUtil.toFileObject((File)file2);
        }
        return null;
    }

    public static FileObject getView(FileObject fileObject, PhpElement phpElement) {
        String string;
        FileObject fileObject2 = null;
        if (phpElement instanceof PhpClass.Method && (string = phpElement.getName()).startsWith(ACTION_METHOD_PREFIX)) {
            String string2 = string.substring(ACTION_METHOD_PREFIX.length());
            fileObject2 = SymfonyUtils.getView(fileObject, string2.substring(0, 1).toLowerCase() + string2.substring(1));
        }
        if (fileObject2 == null) {
            fileObject2 = SymfonyUtils.getDefaultView(fileObject);
        }
        return fileObject2;
    }

    private static FileObject getDefaultView(FileObject fileObject) {
        return SymfonyUtils.getView(fileObject, FILE_DEFAULT_VIEW);
    }

    private static FileObject getView(FileObject fileObject, String string) {
        File file = FileUtil.toFile((FileObject)fileObject).getParentFile();
        File file2 = PropertyUtils.resolveFile((File)file, (String)String.format(FILE_VIEW, string));
        if (file2.isFile()) {
            return FileUtil.toFileObject((File)file2);
        }
        return null;
    }
}

