/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.junit.TypeNameIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestMethodNameGenerator {
    private static final int MAX_SUFFIX_TYPES = 2;
    private Collection<String> reservedNames;
    private final WorkingCopy workingCopy;
    private final List<ExecutableElement> srcMethods;
    private final TypeElement tstClassElem;
    private final List<ExecutableElement> existingMethods;
    private final String[] testMethodNames;

    private TestMethodNameGenerator(List<ExecutableElement> list, TypeElement typeElement, WorkingCopy workingCopy) {
        this.srcMethods = list;
        this.tstClassElem = typeElement;
        this.workingCopy = workingCopy;
        this.existingMethods = typeElement != null ? TestMethodNameGenerator.getExistingMethods(typeElement) : Collections.emptyList();
        this.reservedNames = new HashSet<String>((this.existingMethods.size() * 3 + 1) / 2);
        this.testMethodNames = new String[list.size()];
    }

    static List<String> getTestMethodNames(List<ExecutableElement> list, TypeElement typeElement, Collection<String> collection, WorkingCopy workingCopy) {
        TestMethodNameGenerator testMethodNameGenerator = new TestMethodNameGenerator(list, typeElement, workingCopy);
        if (collection != null) {
            testMethodNameGenerator.reservedNames.addAll(collection);
        }
        return testMethodNameGenerator.getTestMethodNames();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getTestMethodNames() {
        void var8_14;
        CharSequence charSequence;
        Object object;
        Object object2;
        int n;
        String[] stringArray;
        String[] stringArray2;
        Object object3;
        if (this.tstClassElem != null) {
            this.collectExistingMethodNames(this.tstClassElem, this.reservedNames);
        }
        int n2 = this.srcMethods.size();
        String[] stringArray3 = new String[n2];
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n2 * 3 + 0);
        BitSet bitSet = new BitSet(n2);
        int n3 = 0;
        int n4 = -1;
        assert (hashMap.isEmpty());
        for (ExecutableElement object42 : this.srcMethods) {
            object3 = object42.getSimpleName().toString();
            stringArray2 = TestMethodNameGenerator.buildTestMethodName((String)object3);
            this.testMethodNames[++n4] = stringArray2;
            n3 += this.registerTestMethodName((String)stringArray2, n4, hashMap, bitSet);
        }
        hashMap.clear();
        assert (n3 <= n2);
        assert (n3 == bitSet.cardinality());
        int n5 = n2 - n3;
        if (n5 > 0) {
            n4 = bitSet.nextClearBit(0);
            while (n4 >= 0 && n4 < n2) {
                String string;
                stringArray3[n4] = string = this.testMethodNames[n4];
                this.reservedNames.add(string);
                n4 = bitSet.nextClearBit(n4 + 1);
            }
        }
        Object var8_12 = null;
        object3 = null;
        if (n3 > 0) {
            String string;
            int[] nArray = new int[this.srcMethods.size()];
            object3 = this.collectParamTypes(nArray);
            stringArray2 = TestMethodNameGenerator.findNoArgMethods(nArray, bitSet);
            stringArray = new BitSet(this.srcMethods.size());
            int n6 = stringArray2.cardinality();
            assert (hashMap.isEmpty());
            n = 0;
            n4 = stringArray2.nextSetBit(0);
            while (n4 >= 0) {
                n += this.registerTestMethodName(this.testMethodNames[n4], n4, hashMap, (BitSet)stringArray);
                n4 = stringArray2.nextSetBit(n4 + 1);
            }
            hashMap.clear();
            assert (n <= n6);
            assert (n == stringArray.cardinality());
            int n7 = n2 - n3;
            if (n7 > 0) {
                object2 = new BitSet(stringArray2.size());
                ((BitSet)object2).or((BitSet)stringArray2);
                ((BitSet)object2).andNot((BitSet)stringArray);
                n4 = ((BitSet)object2).nextSetBit(0);
                while (n4 >= 0) {
                    stringArray3[n4] = string = this.testMethodNames[n4];
                    this.reservedNames.add(string);
                    n4 = ((BitSet)object2).nextSetBit(n4 + 1);
                }
            }
            if (n > 0) {
                object2 = new HashMap((n + 1) * 3 / 2);
                stringArray = stringArray2;
                n4 = stringArray.nextSetBit(0);
                while (n4 >= 0) {
                    int n8;
                    string = this.testMethodNames[n4];
                    object = (Integer)object2.get(string);
                    int n9 = n8 = object == null ? 0 : (Integer)object;
                    while (this.reservedNames.contains(charSequence = string + ++n8)) {
                    }
                    object2.put(string, n8);
                    stringArray3[n4] = charSequence;
                    this.reservedNames.add((String)charSequence);
                    n4 = stringArray.nextSetBit(n4 + 1);
                }
            }
            bitSet.andNot((BitSet)stringArray);
            assert ((n3 -= n) + (n5 += n) == n2);
        }
        stringArray2 = null;
        stringArray = null;
        if (n3 > 0) {
            BitSet bitSet2 = (BitSet)bitSet.clone();
            n = n3;
            bitSet.clear();
            n3 = 0;
            assert (var8_14 != null);
            assert (object3 != null);
            TypeNameIdGenerator typeNameIdGenerator = null;
            if (!object3.isEmpty()) {
                typeNameIdGenerator = TypeNameIdGenerator.createFor((Collection<TypeMirror>)object3, this.workingCopy.getElements(), this.workingCopy.getTypes());
            }
            assert (hashMap.isEmpty());
            object2 = new String[n2];
            stringArray2 = new String[n2];
            stringArray = new String[n2];
            n4 = bitSet2.nextSetBit(0);
            while (n4 >= 0) {
                Object object4;
                int n10 = var8_14[n4];
                if (n10 > 2) {
                    stringArray[n4] = TestMethodNameGenerator.makeParamCountSuffix(n10);
                    object = stringArray[n4];
                } else {
                    object4 = this.srcMethods.get(n4).getParameters();
                    charSequence = new StringBuilder(40);
                    for (int i = 0; i < n10; ++i) {
                        charSequence.append('_');
                        charSequence.append(typeNameIdGenerator.getParamTypeId(((VariableElement)object4.get(i)).asType()));
                    }
                    stringArray2[n4] = charSequence.toString();
                    object = stringArray2[n4];
                }
                object4 = object2[n4] = this.testMethodNames[n4] + (String)object;
                n3 += this.registerTestMethodName((String)object4, n4, hashMap, bitSet);
                n4 = bitSet2.nextSetBit(n4 + 1);
            }
            hashMap.clear();
            n5 = n - n3;
            if (n5 > 0) {
                BitSet bitSet3 = (BitSet)bitSet2.clone();
                bitSet3.andNot(bitSet);
                assert (bitSet3.cardinality() == n5);
                n4 = bitSet3.nextSetBit(0);
                while (n4 >= 0) {
                    stringArray3[n4] = object = object2[n4];
                    this.reservedNames.add((String)object);
                    n4 = bitSet3.nextSetBit(n4 + 1);
                }
            }
        }
        if (n3 > 0) {
            assert (stringArray2 != null);
            assert (stringArray != null);
            BitSet bitSet4 = (BitSet)bitSet.clone();
            n = n3;
            bitSet.clear();
            n3 = 0;
            assert (hashMap.isEmpty());
            String[] stringArray4 = new String[n2];
            n4 = bitSet4.nextSetBit(0);
            while (n4 >= 0) {
                void var15_29 = var8_14[n4];
                StringBuilder stringBuilder = new StringBuilder(60);
                stringBuilder.append(this.testMethodNames[n4]);
                if (var15_29 <= 2) {
                    assert (stringArray2[n4] != null);
                    stringBuilder.append(stringArray2[n4]);
                }
                if ((object = stringArray[n4]) == null) {
                    assert (var15_29 <= 2);
                    stringArray[n4] = TestMethodNameGenerator.makeParamCountSuffix((int)var15_29);
                    object = stringArray[n4];
                }
                stringBuilder.append((String)object);
                String string = stringArray4[n4] = stringBuilder.toString();
                n3 += this.registerTestMethodName(string, n4, hashMap, bitSet);
                n4 = bitSet4.nextSetBit(n4 + 1);
            }
            hashMap.clear();
            n5 = n - n3;
            if (n5 > 0) {
                object2 = (BitSet)bitSet4.clone();
                ((BitSet)object2).andNot(bitSet);
                assert (((BitSet)object2).cardinality() == n5);
                n4 = ((BitSet)object2).nextSetBit(0);
                while (n4 >= 0) {
                    String string;
                    stringArray3[n4] = string = stringArray4[n4];
                    this.reservedNames.add(string);
                    n4 = ((BitSet)object2).nextSetBit(n4 + 1);
                }
            }
        }
        if (n3 > 0) {
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>((n3 * 3 + 1) / 2);
            assert (stringArray != null);
            n4 = bitSet.nextSetBit(0);
            while (n4 >= 0) {
                String string;
                int n11;
                String string2 = this.testMethodNames[n4] + stringArray[n4] + '_';
                Integer n12 = (Integer)hashMap2.get(string2);
                int n13 = n11 = n12 == null ? 0 : n12;
                while (this.reservedNames.contains(string = string2 + ++n11)) {
                }
                hashMap2.put(string, n11);
                stringArray3[n4] = string;
                this.reservedNames.add(string);
                n4 = bitSet.nextSetBit(n4 + 1);
            }
        }
        return Arrays.asList(stringArray3);
    }

    private static final String makeParamCountSuffix(int n) {
        return new StringBuilder(8).append('_').append(n).append("args").toString();
    }

    private int registerTestMethodName(String string, int n, Map<String, Object> map, BitSet bitSet) {
        boolean bl;
        Object object = map.put(string, n);
        boolean bl2 = bl = object != null || this.reservedNames != null && this.reservedNames.contains(string);
        assert (!bitSet.get(n));
        int n2 = 0;
        if (bl) {
            if (object != null && object != Boolean.TRUE) {
                assert (object.getClass() == Integer.class);
                int n3 = (Integer)object;
                assert (!bitSet.get(n3));
                bitSet.set(n3);
                ++n2;
            }
            bitSet.set(n);
            map.put(string, Boolean.TRUE);
            ++n2;
        }
        return n2;
    }

    private void collectExistingMethodNames(TypeElement typeElement, Collection<String> collection) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> list = elements.getAllMembers(typeElement);
        List<ExecutableElement> list2 = ElementFilter.methodsIn(list);
        if (!list2.isEmpty()) {
            for (ExecutableElement executableElement : list2) {
                if (!executableElement.getParameters().isEmpty()) continue;
                collection.add(executableElement.getSimpleName().toString());
            }
        }
    }

    private Collection<TypeMirror> collectParamTypes(int[] nArray) {
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(this.srcMethods.size());
        int n = -1;
        for (ExecutableElement executableElement : this.srcMethods) {
            int n2;
            ++n;
            List<? extends VariableElement> list = executableElement.getParameters();
            if (list.isEmpty()) {
                nArray[n] = 0;
                continue;
            }
            nArray[n] = n2 = list.size();
            if (n2 > 2) continue;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(list.get(i).asType());
            }
        }
        return !arrayList.isEmpty() ? arrayList : Collections.emptyList();
    }

    private static List<ExecutableElement> getExistingMethods(TypeElement typeElement) {
        List<? extends Element> list = typeElement.getEnclosedElements();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        List<ExecutableElement> list2 = ElementFilter.methodsIn(list);
        return !list2.isEmpty() ? list2 : Collections.emptyList();
    }

    private static String buildTestMethodName(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 4);
        stringBuilder.append("test");
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        if (n != 1) {
            stringBuilder.append(string.substring(1));
        }
        return stringBuilder.toString();
    }

    private static BitSet findNoArgMethods(int[] nArray, BitSet bitSet) {
        BitSet bitSet2 = new BitSet(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0 || !bitSet.get(i)) continue;
            bitSet2.set(i);
        }
        return bitSet2;
    }
}

