/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.model;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.StringInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.profile.ProfilesModel;
import org.netbeans.modules.maven.model.profile.ProfilesModelFactory;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.netbeans.modules.maven.model.settings.SettingsModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());
    private static final String PROFILES_SKELETON = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<profilesXml xmlns=\"http://maven.apache.org/PROFILES/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://maven.apache.org/PROFILES/1.0.0 http://maven.apache.org/xsd/profiles-1.0.0.xsd\">\n</profilesXml>";

    public static ModelSource createModelSourceForMissingFile(File file, boolean bl, String string, String string2) {
        try {
            BaseDocument baseDocument = new BaseDocument(false, string2);
            baseDocument.insertString(0, string, null);
            InstanceContent instanceContent = new InstanceContent();
            AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
            instanceContent.add((Object)file);
            instanceContent.add((Object)baseDocument);
            ModelSource modelSource = new ModelSource((Lookup)abstractLookup, bl);
            return modelSource;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            assert (false) : "Failed to load the model for non-existing file";
            return null;
        }
    }

    public static Document getDocument(FileObject fileObject) {
        Document document = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.openDocument();
            if (styledDocument instanceof BaseDocument) {
                return styledDocument;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return document;
    }

    private static Document _getDocument(DataObject dataObject) throws IOException {
        StyledDocument styledDocument = null;
        if (dataObject != null && dataObject.isValid()) {
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            assert (editorCookie != null) : "Data object " + dataObject.getPrimaryFile().getPath() + " has no editor cookies.";
            StyledDocument styledDocument2 = null;
            try {
                styledDocument2 = editorCookie.openDocument();
            }
            catch (UserQuestionException userQuestionException) {
                userQuestionException.confirmed();
                styledDocument2 = editorCookie.openDocument();
            }
            styledDocument = styledDocument2;
        }
        return styledDocument;
    }

    protected static Document _getDocument(FileObject fileObject) throws DataObjectNotFoundException, IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return Utilities._getDocument(dataObject);
    }

    public static FileObject getFileObject(ModelSource modelSource) {
        return (FileObject)modelSource.getLookup().lookup(FileObject.class);
    }

    public static CatalogModel getCatalogModel(ModelSource modelSource) throws CatalogModelException {
        return CatalogModelFactory.getDefault().getCatalogModel(modelSource);
    }

    public static ModelSource createModelSource(FileObject fileObject) {
        assert (fileObject != null) : "Null file object.";
        boolean bl = true;
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        InstanceContent instanceContent = new InstanceContent();
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        if (dataObject != null) {
            instanceContent.add((Object)dataObject);
        }
        instanceContent.add((Object)fileObject);
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            instanceContent.add((Object)file);
        } else {
            bl = false;
            if (FileUtil.getArchiveFile((FileObject)fileObject) == null && fileObject.canWrite()) {
                Logger.getLogger(Utilities.class.getName()).warning("Creating a non-editable ModelSource for '" + fileObject.getPath() + "'. As these models get cached, one gets errors down the road eventually.");
            }
        }
        ModelSource modelSource = new ModelSource((Lookup)abstractLookup, bl);
        try {
            CatalogModel catalogModel = CatalogModelFactory.getDefault().getCatalogModel(modelSource);
            assert (catalogModel != null);
            if (catalogModel != null) {
                instanceContent.add((Object)catalogModel);
            }
        }
        catch (CatalogModelException catalogModelException) {
            Exceptions.printStackTrace((Throwable)catalogModelException);
        }
        Document document = null;
        try {
            document = Utilities._getDocument(dataObject);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage());
        }
        if (document != null) {
            instanceContent.add((Object)document);
        }
        return modelSource;
    }

    public static void saveChanges(AbstractDocumentModel abstractDocumentModel) throws IOException {
        if (abstractDocumentModel.isIntransaction()) {
            abstractDocumentModel.endTransaction();
        }
        abstractDocumentModel.sync();
        DataObject dataObject = (DataObject)abstractDocumentModel.getModelSource().getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            FileObject fileObject;
            final Document document = (Document)abstractDocumentModel.getModelSource().getLookup().lookup(Document.class);
            final File file = (File)abstractDocumentModel.getModelSource().getLookup().lookup(File.class);
            File file2 = file.getParentFile();
            FileObject fileObject2 = FileUtil.toFileObject((File)file2);
            if (fileObject2 == null) {
                file2.mkdirs();
                FileUtil.refreshFor((File[])new File[]{file2});
                fileObject2 = FileUtil.toFileObject((File)file2);
            }
            if ((fileObject = fileObject2) != null) {
                FileSystem fileSystem = fileObject2.getFileSystem();
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        FileObject fileObject2 = fileObject.getFileObject(file.getName());
                        if (fileObject2 == null) {
                            fileObject2 = fileObject.createData(file.getName());
                        }
                        OutputStream outputStream = null;
                        try {
                            String string = document.getText(0, document.getLength());
                            StringInputStream stringInputStream = new StringInputStream(string);
                            outputStream = fileObject2.getOutputStream();
                            FileUtil.copy((InputStream)stringInputStream, (OutputStream)outputStream);
                            outputStream.close();
                            IOUtil.close((OutputStream)outputStream);
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                        finally {
                            IOUtil.close(outputStream);
                        }
                    }
                });
            }
        } else {
            SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performPOMModelOperations(FileObject fileObject, List<ModelOperation<POMModel>> list) {
        assert (fileObject != null);
        assert (list != null);
        ModelSource modelSource = Utilities.createModelSource(fileObject);
        POMModel pOMModel = POMModelFactory.getDefault().getModel(modelSource);
        if (pOMModel != null) {
            try {
                pOMModel.sync();
                if (Model.State.VALID != pOMModel.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_POM", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                pOMModel.startTransaction();
                for (ModelOperation<POMModel> modelOperation : list) {
                    modelOperation.performOperation(pOMModel);
                }
                pOMModel.endTransaction();
                Utilities.saveChanges(pOMModel);
            }
            catch (IOException iOException) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_POM", (Object)iOException.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Canot write POM", iOException);
            }
            finally {
                if (pOMModel.isIntransaction()) {
                    pOMModel.rollbackTransaction();
                }
            }
        } else {
            Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Cannot create model from current content of " + fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performProfilesModelOperations(FileObject fileObject, List<ModelOperation<ProfilesModel>> list) {
        assert (fileObject != null);
        assert (list != null);
        ModelSource modelSource = fileObject.getSize() == 0L ? Utilities.createModelSourceForMissingFile(FileUtil.toFile((FileObject)fileObject), true, PROFILES_SKELETON, "text/x-maven-profile+xml") : Utilities.createModelSource(fileObject);
        ProfilesModel profilesModel = ProfilesModelFactory.getDefault().getModel(modelSource);
        if (profilesModel != null) {
            try {
                profilesModel.sync();
                if (Model.State.VALID != profilesModel.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_PROFILE", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                profilesModel.startTransaction();
                for (ModelOperation<ProfilesModel> modelOperation : list) {
                    modelOperation.performOperation(profilesModel);
                }
                profilesModel.endTransaction();
                Utilities.saveChanges(profilesModel);
            }
            catch (IOException iOException) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_PROFILE", (Object)iOException.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Cannot write profiles.xml", iOException);
            }
            finally {
                if (profilesModel.isIntransaction()) {
                    profilesModel.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performSettingsModelOperations(FileObject fileObject, List<ModelOperation<SettingsModel>> list) {
        assert (fileObject != null);
        assert (list != null);
        ModelSource modelSource = Utilities.createModelSource(fileObject);
        SettingsModel settingsModel = SettingsModelFactory.getDefault().getModel(modelSource);
        if (settingsModel != null) {
            try {
                settingsModel.sync();
                if (Model.State.VALID != settingsModel.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_PROFILE", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                settingsModel.startTransaction();
                for (ModelOperation<SettingsModel> modelOperation : list) {
                    modelOperation.performOperation(settingsModel);
                }
                settingsModel.endTransaction();
                Utilities.saveChanges(settingsModel);
            }
            catch (IOException iOException) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_SETTINGS", (Object)iOException.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Cannot write settings.xml", iOException);
            }
            finally {
                if (settingsModel.isIntransaction()) {
                    settingsModel.rollbackTransaction();
                }
            }
        }
    }
}

