/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;

public class StringUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.utils.Bundle");
    private static final String THIS_WEEK_FORMAT = messages.getString("StringUtils_ThisWeekFormat");
    private static final String LAST_WEEK_FORMAT = messages.getString("StringUtils_LastWeekFormat");
    private static final String YESTERDAY_FORMAT = messages.getString("StringUtils_YesterdayFormat");
    private static final String TODAY_FORMAT = messages.getString("StringUtils_TodayFormat");
    private static final String OTHER_DAY_FORMAT = messages.getString("StringUtils_OtherDayFormat");
    private static final String FULL_FORMAT = messages.getString("StringUtils_FullFormat");
    private static SimpleDateFormat thisWeekFormat = new SimpleDateFormat(THIS_WEEK_FORMAT);
    private static SimpleDateFormat lastWeekFormat = new SimpleDateFormat(LAST_WEEK_FORMAT);
    private static SimpleDateFormat yesterdayFormat = new SimpleDateFormat(YESTERDAY_FORMAT);
    private static SimpleDateFormat todayFormat = new SimpleDateFormat(TODAY_FORMAT);
    private static SimpleDateFormat otherFormat = new SimpleDateFormat(OTHER_DAY_FORMAT);
    private static SimpleDateFormat fullFormat = new SimpleDateFormat(FULL_FORMAT);
    static StringBuffer tmpBuf = new StringBuffer();
    private static char[] strBuf;

    public static void appendSplittedLongString(StringBuffer stringBuffer, String string, int n) {
        int n2 = string.length() / n + (string.length() % n != 0 ? 1 : 0);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (i > 0) {
                stringBuffer.append('\n');
            }
            if ((n4 = n3 + n) > string.length()) {
                n4 = string.length();
            }
            stringBuffer.append(string.substring(n3, n4));
            n3 = n4;
        }
    }

    public static String[][] convertPackedStringsIntoStringArrays(byte[] byArray, int[] nArray, int n) {
        int n2;
        String[][] stringArray = new String[n][];
        int n3 = nArray.length / n;
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2] = new String[n3];
        }
        n2 = 0;
        int n4 = nArray.length - 1;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = n2 < n4 ? nArray[n2 + 1] - nArray[n2] : byArray.length - nArray[n2];
                stringArray[j][i] = StringUtils.utf8ToString(byArray, nArray[n2], n5);
                ++n2;
            }
        }
        return stringArray;
    }

    public static String floatPerCentToString(float f) {
        tmpBuf.setLength(0);
        double d = Math.floor(f);
        double d2 = (double)f - d;
        if (d2 >= 0.95) {
            d = Math.round(f);
            d2 = 0.0;
        }
        tmpBuf.append((int)d);
        tmpBuf.append('.');
        tmpBuf.append((int)Math.round(d2 * 10.0));
        return tmpBuf.toString();
    }

    public static String formatFullDate(Date date) {
        return fullFormat.format(date);
    }

    public static String formatUserDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        if (calendar2.getTimeInMillis() <= calendar.getTimeInMillis()) {
            int n = StringUtils.getDaysDifference(calendar2, calendar);
            if (n == 0) {
                return todayFormat.format(date);
            }
            if (n == 1) {
                return yesterdayFormat.format(date);
            }
            int n2 = StringUtils.getWeekDifference(calendar2, calendar);
            if (n2 == 0) {
                return thisWeekFormat.format(date);
            }
            if (n2 == 1) {
                return lastWeekFormat.format(date);
            }
        }
        return otherFormat.format(date);
    }

    public static String mcsTimeToString(long l) {
        tmpBuf.setLength(0);
        if (l >= 100000L) {
            return Long.toString(l / 1000L);
        }
        if (l >= 10000L) {
            long l2 = l / 1000L;
            tmpBuf.append(Long.toString(l2));
            tmpBuf.append('.');
            tmpBuf.append(Long.toString((l - l2 * 1000L) / 100L));
            return tmpBuf.toString();
        }
        if (l >= 1000L) {
            long l3 = l / 1000L;
            tmpBuf.append(Long.toString(l3));
            tmpBuf.append('.');
            tmpBuf.append(Long.toString((l - l3 * 1000L) / 10L));
            return tmpBuf.toString();
        }
        if (l >= 100L) {
            tmpBuf.append("0.");
        } else if (l >= 10L) {
            tmpBuf.append("0.0");
        } else {
            tmpBuf.append("0.00");
        }
        return tmpBuf.append(Long.toString(l)).toString();
    }

    public static String nBytesToString(long l) {
        tmpBuf.setLength(0);
        if (l < 102400L) {
            return Long.toString(l) + " B";
        }
        if (l < 0x6400000L) {
            long l2 = l >> 10;
            tmpBuf.append(Long.toString(l2));
            if (l < 0x6400000L) {
                tmpBuf.append('.');
                tmpBuf.append(Long.toString((l - (l2 << 10)) / 102L));
            }
            tmpBuf.append(" KB");
            return tmpBuf.toString();
        }
        long l3 = l >> 20;
        tmpBuf.append(Long.toString(l3));
        if (l < 0x280000000L) {
            tmpBuf.append('.');
            tmpBuf.append(Long.toString((l - (l3 << 20)) / 104858L));
        }
        tmpBuf.append(" MB");
        return tmpBuf.toString();
    }

    public static String[] parseArgsString(String string) {
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            for (n3 = n; n3 < n2 && string.charAt(n3) != ' ' && string.charAt(n3) != '\b'; ++n3) {
            }
            arrayList.add(string.substring(n, n3));
            for (n = n3 + 1; n < n2 && (string.charAt(n) == ' ' || string.charAt(n) == '\b'); ++n) {
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String userFormClassName(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.replace('/', '.')).startsWith("[")) {
            String string2 = null;
            int n = string.lastIndexOf(91);
            if (n == string.length() - 2) {
                switch (string.charAt(n + 1)) {
                    case 'C': {
                        string2 = "char";
                        break;
                    }
                    case 'B': {
                        string2 = "byte";
                        break;
                    }
                    case 'I': {
                        string2 = "int";
                        break;
                    }
                    case 'Z': {
                        string2 = "boolean";
                        break;
                    }
                    case 'F': {
                        string2 = "float";
                        break;
                    }
                    case 'D': {
                        string2 = "double";
                        break;
                    }
                    case 'S': {
                        string2 = "short";
                        break;
                    }
                    case 'J': {
                        string2 = "long";
                    }
                }
            } else {
                string2 = string.substring(n + 1);
            }
            int n2 = n + 1;
            tmpBuf.setLength(0);
            tmpBuf.append(string2);
            for (int i = 0; i < n2; ++i) {
                tmpBuf.append("[]");
            }
            return tmpBuf.toString();
        }
        return string;
    }

    public static String utf8ToString(byte[] byArray, int n, int n2) {
        if (strBuf == null || strBuf.length < n2) {
            strBuf = new char[n2];
        }
        int n3 = n;
        int n4 = 0;
        int n5 = n + n2;
        while (n3 < n5) {
            int n6;
            if ((n6 = byArray[n3++] & 0xFF) >= 224) {
                n6 = (n6 & 0xF) << 12;
                n6 |= (byArray[n3++] & 0x3F) << 6;
                n6 |= byArray[n3++] & 0x3F;
            } else if (n6 >= 192) {
                n6 = (n6 & 0x1F) << 6;
                n6 |= byArray[n3++] & 0x3F;
            }
            StringUtils.strBuf[n4++] = (char)n6;
        }
        return new String(strBuf, 0, n4).intern();
    }

    private static int getDaysDifference(Calendar calendar, Calendar calendar2) {
        int n = calendar2.get(6) - calendar.get(6);
        return n += calendar.getMaximum(6) * (calendar2.get(1) - calendar.get(1));
    }

    private static int getWeekDifference(Calendar calendar, Calendar calendar2) {
        int n = calendar2.get(3) - calendar.get(3);
        return n += calendar.getMaximum(3) * (calendar2.get(1) - calendar.get(1));
    }
}

