/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofFieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.TagBounds;

class ClassDump
extends HprofObject
implements JavaClass {
    private static final boolean DEBUG = false;
    final ClassDumpSegment classDumpSegment;
    private int instances;
    private long loadClassOffset;

    ClassDump(ClassDumpSegment classDumpSegment, long l) {
        super(l);
        this.classDumpSegment = classDumpSegment;
        assert (this.getHprofBuffer().get(l) == 32);
    }

    public long getAllInstancesSize() {
        if (this.isArray()) {
            return (Long)this.classDumpSegment.arrayMap.get(this);
        }
        return (long)this.getInstancesCount() * (long)this.getInstanceSize();
    }

    public boolean isArray() {
        return this.classDumpSegment.arrayMap.get(this) != null;
    }

    public Instance getClassLoader() {
        long l = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset);
        return this.getHprof().getInstanceByID(l);
    }

    public Field getField(String string) {
        for (Field field : this.getFields()) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public List getFields() {
        List list = (List)this.classDumpSegment.fieldsCache.get(this);
        if (list == null) {
            list = this.computeFields();
            this.classDumpSegment.fieldsCache.put(this, list);
        }
        return list;
    }

    public int getInstanceSize() {
        if (this.isArray()) {
            return -1;
        }
        return this.classDumpSegment.getMinimumInstanceSize() + this.getHprofBuffer().getInt(this.fileOffset + (long)this.classDumpSegment.instanceSizeOffset);
    }

    public List getInstances() {
        int n = this.getInstancesCount();
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        long l = this.getJavaClassId();
        HprofHeap hprofHeap = this.getHprof();
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n2 = hprofByteBuffer.getIDSize();
        ArrayList<InstanceDump> arrayList = new ArrayList<InstanceDump>(n);
        TagBounds tagBounds = hprofHeap.getAllInstanceDumpBounds();
        long[] lArray = new long[]{tagBounds.startOffset};
        while (lArray[0] < tagBounds.endOffset) {
            InstanceDump instanceDump;
            long l2 = lArray[0];
            int n3 = 0;
            long l3 = 0L;
            int n4 = hprofHeap.readDumpTag(lArray);
            if (n4 == 33) {
                n3 = n2 + 4;
            } else if (n4 == 34) {
                n3 = n2 + 4 + 4;
            } else if (n4 == 35) {
                byte by = hprofByteBuffer.get(l2 + 1L + (long)n2 + 4L + 4L);
                l3 = this.classDumpSegment.getPrimitiveArrayClass(by).getJavaClassId();
            }
            if (n3 != 0) {
                l3 = hprofByteBuffer.getID(l2 + 1L + (long)n3);
            }
            if (l3 != l) continue;
            if (n4 == 33) {
                instanceDump = new InstanceDump(this, l2);
            } else if (n4 == 34) {
                instanceDump = new ObjectArrayDump(this, l2);
            } else if (n4 == 35) {
                instanceDump = new PrimitiveArrayDump(this, l2);
            } else {
                throw new IllegalArgumentException("Illegal tag " + n4);
            }
            arrayList.add(instanceDump);
            if (--n != 0) continue;
            return arrayList;
        }
        return arrayList;
    }

    public int getInstancesCount() {
        if (this.instances == 0) {
            this.getHprof().computeInstances();
        }
        return this.instances;
    }

    public long getJavaClassId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classIDOffset);
    }

    public String getName() {
        return this.getLoadClass().getName();
    }

    public List getStaticFieldValues() {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        long l = this.fileOffset + (long)this.getStaticFieldOffset();
        HprofHeap hprofHeap = this.getHprof();
        int n = hprofByteBuffer.getShort(l);
        l += 2L;
        ArrayList<HprofFieldObjectValue> arrayList = new ArrayList<HprofFieldObjectValue>(n);
        for (int i = 0; i < n; ++i) {
            byte by = hprofByteBuffer.get(l + (long)this.classDumpSegment.fieldTypeOffset);
            int n2 = this.classDumpSegment.fieldSize + hprofHeap.getValueSize(by);
            HprofFieldValue hprofFieldValue = by == 2 ? new HprofFieldObjectValue(this, l) : new HprofFieldValue(this, l);
            arrayList.add((HprofFieldObjectValue)hprofFieldValue);
            l += (long)n2;
        }
        return arrayList;
    }

    public Collection getSubClasses() {
        List list = this.classDumpSegment.hprofHeap.getAllClasses();
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>(list.size() / 10);
        HashMap<ClassDump, Boolean> hashMap = new HashMap<ClassDump, Boolean>(list.size() * 4 / 3);
        hashMap.put(this, Boolean.TRUE);
        for (int i = 0; i < list.size(); ++i) {
            JavaClass javaClass = (JavaClass)list.get(i);
            Boolean bl = (Boolean)hashMap.get(javaClass);
            if (bl == null) {
                bl = ClassDump.isSubClass(javaClass, hashMap);
            }
            if (bl != Boolean.TRUE || javaClass == this) continue;
            arrayList.add(javaClass);
        }
        return arrayList;
    }

    public JavaClass getSuperClass() {
        long l = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.superClassIDOffset);
        return this.classDumpSegment.getClassDumpByID(l);
    }

    public Object getValueOfStaticField(String string) {
        for (FieldValue fieldValue : this.getStaticFieldValues()) {
            if (!fieldValue.getField().getName().equals(string)) continue;
            if (fieldValue instanceof HprofFieldObjectValue) {
                return ((HprofFieldObjectValue)fieldValue).getInstance();
            }
            return ((HprofFieldValue)fieldValue).getTypeValue();
        }
        return null;
    }

    private List computeFields() {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        long l = this.fileOffset + (long)this.getInstanceFieldOffset();
        int n = hprofByteBuffer.getShort(l);
        ArrayList<HprofField> arrayList = new ArrayList<HprofField>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new HprofField(this, l + 2L + (long)(i * this.classDumpSegment.fieldSize)));
        }
        return arrayList;
    }

    List getAllInstanceFields() {
        ArrayList arrayList = new ArrayList(50);
        for (JavaClass javaClass = this; javaClass != null; javaClass = javaClass.getSuperClass()) {
            arrayList.addAll(javaClass.getFields());
        }
        return arrayList;
    }

    void setClassLoadOffset(long l) {
        this.loadClassOffset = l;
    }

    int getConstantPoolSize() {
        long l = this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset;
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n = hprofByteBuffer.getShort(l);
        HprofHeap hprofHeap = this.getHprof();
        l += 2L;
        for (int i = 0; i < n; ++i) {
            byte by = hprofByteBuffer.get(l + 2L);
            int n2 = hprofHeap.getValueSize(by);
            l += (long)(3 + n2);
        }
        return (int)(l - (this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset));
    }

    HprofHeap getHprof() {
        return this.classDumpSegment.hprofHeap;
    }

    HprofByteBuffer getHprofBuffer() {
        return this.classDumpSegment.hprofHeap.dumpBuffer;
    }

    int getInstanceFieldOffset() {
        int n = this.getStaticFieldOffset();
        return n + this.getStaticFiledSize(n);
    }

    LoadClass getLoadClass() {
        return new LoadClass(this.getHprof().getLoadClassSegment(), this.loadClassOffset);
    }

    List getReferences() {
        return this.getHprof().findReferencesFor(this.getJavaClassId());
    }

    int getStaticFieldOffset() {
        return this.classDumpSegment.constantPoolSizeOffset + this.getConstantPoolSize();
    }

    int getStaticFiledSize(int n) {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n2 = hprofByteBuffer.getIDSize();
        long l = this.fileOffset + (long)n;
        int n3 = this.getHprofBuffer().getShort(l);
        HprofHeap hprofHeap = this.getHprof();
        l += 2L;
        for (int i = 0; i < n3; ++i) {
            byte by = hprofByteBuffer.get(l + (long)n2);
            int n4 = hprofHeap.getValueSize(by);
            l += (long)(n2 + 1 + n4);
        }
        return (int)(l - (long)n - this.fileOffset);
    }

    void findStaticReferencesFor(long l, List list) {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n = hprofByteBuffer.getIDSize();
        long l2 = this.fileOffset + (long)this.getStaticFieldOffset();
        int n2 = this.getHprofBuffer().getShort(l2);
        List list2 = null;
        HprofHeap hprofHeap = this.getHprof();
        l2 += 2L;
        for (int i = 0; i < n2; ++i) {
            byte by = hprofByteBuffer.get(l2 + (long)n);
            int n3 = hprofHeap.getValueSize(by);
            if (by == 2 && l == hprofByteBuffer.getID(l2 + (long)n + 1L)) {
                if (list2 == null) {
                    list2 = this.getStaticFieldValues();
                }
                list.add(list2.get(i));
            }
            l2 += (long)(n + 1 + n3);
        }
    }

    void incrementInstance() {
        ++this.instances;
    }

    private static Boolean isSubClass(JavaClass javaClass, Map map) {
        Boolean bl;
        JavaClass javaClass2 = javaClass.getSuperClass();
        if (javaClass2 == null) {
            bl = Boolean.FALSE;
        } else {
            bl = (Boolean)map.get(javaClass2);
            if (bl == null) {
                bl = ClassDump.isSubClass(javaClass2, map);
            }
        }
        map.put(javaClass, bl);
        return bl;
    }
}

