/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.nodes.RubyServerNode;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WEBrick
implements RubyServer,
ServerInstanceImplementation {
    private static final Pattern[] STARTUP_PATTERNS = new Pattern[]{Pattern.compile(".*Rails.*application started on.+", 32), Pattern.compile(".*WEBrick::HTTPServer#start:.*pid=.+", 32)};
    private final RubyPlatform platform;
    private final List<RailsApplication> applications = new ArrayList<RailsApplication>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Node node;

    WEBrick(RubyPlatform rubyPlatform) {
        Parameters.notNull((CharSequence)"platform", (Object)rubyPlatform);
        this.platform = rubyPlatform;
    }

    private Node getNode() {
        if (this.node == null) {
            this.node = new RubyServerNode(this);
        }
        return this.node;
    }

    @Override
    public String getNodeName() {
        return NbBundle.getMessage(WEBrick.class, (String)"LBL_ServerNodeName", (Object)this.getDisplayName(), (Object)this.platform.getLabel());
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public String getStartupParam() {
        return "webrick";
    }

    @Override
    public String getScriptPrefix() {
        return null;
    }

    @Override
    public String getServerPath() {
        return "script" + File.separator + "server";
    }

    @Override
    public boolean isStartupMsg(String string) {
        for (Pattern pattern : STARTUP_PATTERNS) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(WEBrick.class, (String)"LBL_WEBrick");
    }

    @Override
    public List<RailsApplication> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public boolean addApplication(RailsApplication railsApplication) {
        boolean bl = this.applications.add(railsApplication);
        this.changeSupport.fireChange();
        return bl;
    }

    @Override
    public boolean removeApplication(int n) {
        boolean bl = false;
        for (RailsApplication railsApplication : this.applications) {
            if (railsApplication.getPort() != n) continue;
            bl = this.applications.remove(railsApplication);
            this.changeSupport.fireChange();
            break;
        }
        return bl;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public String getServerDisplayName() {
        return this.getNodeName();
    }

    public Node getFullNode() {
        return this.getNode();
    }

    public Node getBasicNode() {
        return this.getNode();
    }

    public JComponent getCustomizer() {
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRemovable() {
        return false;
    }

    @Override
    public String getServerUri() {
        return "WEBRICK";
    }

    @Override
    public RubyInstance.ServerState getServerState() {
        return null;
    }

    @Override
    public Future<RubyInstance.OperationState> startServer(RubyPlatform rubyPlatform) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stopServer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> deploy(String string, File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stop(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> runApplication(RubyPlatform rubyPlatform, String string, File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPlatformSupported(RubyPlatform rubyPlatform) {
        return this.platform.equals((Object)rubyPlatform);
    }

    @Override
    public String getContextRoot(String string) {
        return "";
    }

    @Override
    public int getRailsPort() {
        return 3000;
    }

    @Override
    public String getServerCommand(RubyPlatform rubyPlatform, String string, File file, int n, boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WEBrick wEBrick = (WEBrick)object;
        return this.platform == wEBrick.platform || this.platform != null && this.platform.equals((Object)wEBrick.platform);
    }

    public int hashCode() {
        int n = 3;
        n = 11 * n + (this.platform != null ? this.platform.hashCode() : 0);
        return n;
    }
}

