/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.highlighting;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public final class NonLexerSyntaxHighlighting
extends AbstractHighlightsContainer
implements DocumentListener {
    private static final Logger LOG = Logger.getLogger(NonLexerSyntaxHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.oldlibbridge.NonLexerSyntaxHighlighting";
    private final Document document;
    private long version = 0L;
    private final MimePath mimePath;
    private final WeakHashMap<TokenID, AttributeSet> attribsCache = new WeakHashMap();

    public NonLexerSyntaxHighlighting(Document document, String string) {
        this.mimePath = MimePath.parse((String)string);
        this.document = document;
        this.document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        NonLexerSyntaxHighlighting nonLexerSyntaxHighlighting = this;
        synchronized (nonLexerSyntaxHighlighting) {
            if (this.document instanceof BaseDocument) {
                return new HSImpl(this.version, (BaseDocument)this.document, n, n2);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged(documentEvent.getOffset(), documentEvent.getLength());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged(documentEvent.getOffset(), documentEvent.getLength());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged(documentEvent.getOffset(), documentEvent.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeSet findAttribs(TokenItem tokenItem) {
        NonLexerSyntaxHighlighting nonLexerSyntaxHighlighting = this;
        synchronized (nonLexerSyntaxHighlighting) {
            AttributeSet attributeSet = this.attribsCache.get(tokenItem.getTokenID());
            if (attributeSet == null) {
                FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
                if (fontColorSettings != null) {
                    attributeSet = NonLexerSyntaxHighlighting.findFontAndColors(fontColorSettings, tokenItem);
                    if (attributeSet == null) {
                        attributeSet = SimpleAttributeSet.EMPTY;
                    }
                    this.attribsCache.put(tokenItem.getTokenID(), attributeSet);
                } else {
                    LOG.warning("Can't find FCS for mime path: '" + this.mimePath.getPath() + "'");
                }
            }
            return attributeSet == null ? SimpleAttributeSet.EMPTY : attributeSet;
        }
    }

    private static AttributeSet findFontAndColors(FontColorSettings fontColorSettings, TokenItem tokenItem) {
        String string;
        AttributeSet attributeSet = null;
        TokenContextPath tokenContextPath = tokenItem.getTokenContextPath();
        String string2 = tokenContextPath.getFullTokenName((TokenCategory)tokenItem.getTokenID());
        if (string2 != null) {
            attributeSet = fontColorSettings.getTokenFontColors(string2);
        }
        if (attributeSet == null && (string2 = tokenItem.getTokenID().getCategory()) != null && (string = tokenContextPath.getFullTokenName((TokenCategory)string2)) != null) {
            attributeSet = fontColorSettings.getTokenFontColors(string);
        }
        return attributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentChanged(int n, int n2) {
        NonLexerSyntaxHighlighting nonLexerSyntaxHighlighting = this;
        synchronized (nonLexerSyntaxHighlighting) {
            ++this.version;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Document changed: changeStart = " + n + ", changeEnd = " + (n + n2));
        }
        if (n < 0 || n > this.document.getLength()) {
            n = 0;
        }
        if (n2 <= 0 || n + n2 > this.document.getLength()) {
            n2 = this.document.getLength() - n;
        }
        this.fireHighlightsChange(n, n + n2);
    }

    private final class HSImpl
    implements HighlightsSequence {
        private final long version;
        private final BaseDocument baseDocument;
        private final int startOffset;
        private final int endOffset;
        private boolean init = false;
        private TokenItem tokenItem;

        public HSImpl(long l, BaseDocument baseDocument, int n, int n2) {
            this.version = l;
            this.baseDocument = baseDocument;
            this.startOffset = n;
            this.endOffset = n2;
        }

        public boolean moveNext() {
            if (!this.init) {
                this.init = true;
                try {
                    ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)this.baseDocument.getSyntaxSupport();
                    this.tokenItem = extSyntaxSupport.getTokenChain(this.startOffset, this.endOffset);
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, "Can't get token sequence: document " + this.baseDocument + ", startOffset = " + this.startOffset + ", endOffset = " + this.endOffset, badLocationException);
                    this.tokenItem = null;
                }
                while (null != this.tokenItem && this.tokenItem.getOffset() + this.tokenItem.getImage().length() <= this.startOffset) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Skipping tokenId: " + this.tokenItem.getTokenID() + ", tokenStart = " + this.tokenItem.getOffset() + ", tokenEnd = " + (this.tokenItem.getOffset() + this.tokenItem.getImage().length()) + ", startOffset = " + this.startOffset + ", endOffset = " + this.endOffset);
                    }
                    this.tokenItem = this.tokenItem.getNext();
                }
            } else if (this.tokenItem != null) {
                this.tokenItem = this.tokenItem.getNext();
            }
            if (this.tokenItem != null && this.tokenItem.getOffset() > this.endOffset) {
                this.tokenItem = null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                if (this.tokenItem != null) {
                    LOG.fine("Next tokenId: " + this.tokenItem.getTokenID() + ", tokenStart = " + this.tokenItem.getOffset() + ", tokenEnd = " + (this.tokenItem.getOffset() + this.tokenItem.getImage().length()) + ", startOffset = " + this.startOffset + ", endOffset = " + this.endOffset);
                } else {
                    LOG.fine("Next tokenId: null");
                }
            }
            return this.tokenItem != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            NonLexerSyntaxHighlighting nonLexerSyntaxHighlighting = NonLexerSyntaxHighlighting.this;
            synchronized (nonLexerSyntaxHighlighting) {
                this.checkVersion();
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.tokenItem == null) {
                    throw new NoSuchElementException();
                }
                return Math.max(this.tokenItem.getOffset(), this.startOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            NonLexerSyntaxHighlighting nonLexerSyntaxHighlighting = NonLexerSyntaxHighlighting.this;
            synchronized (nonLexerSyntaxHighlighting) {
                this.checkVersion();
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.tokenItem == null) {
                    throw new NoSuchElementException();
                }
                return Math.min(this.tokenItem.getOffset() + this.tokenItem.getImage().length(), this.endOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            NonLexerSyntaxHighlighting nonLexerSyntaxHighlighting = NonLexerSyntaxHighlighting.this;
            synchronized (nonLexerSyntaxHighlighting) {
                this.checkVersion();
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.tokenItem == null) {
                    throw new NoSuchElementException();
                }
                return NonLexerSyntaxHighlighting.this.findAttribs(this.tokenItem);
            }
        }

        private void checkVersion() {
            if (this.version != NonLexerSyntaxHighlighting.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

