/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeModelSourceFileInfoProvider
implements SourceFileInfoProvider {
    private static final boolean TRACE = false;
    private WeakReference<Map<String, Set<SourceFileInfoProvider.SourceFileInfo>>> staticFileCache = new WeakReference<Object>(null);

    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(String string, int n, long l, Map<String, String> map) {
        try {
            String string2 = map.get("GizmoProjectFolder");
            if (string2 == null) {
                return null;
            }
            Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)new File(string2)));
            if (project.getLookup().lookup(NativeProject.class) == null) {
                return null;
            }
            CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)project);
            if (csmProject == null) {
                return null;
            }
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = this.findFunction(csmProject, string, n);
            if (sourceFileInfo == null) {
                sourceFileInfo = this.findStaticFunction(csmProject, string);
            }
            return sourceFileInfo;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private SourceFileInfoProvider.SourceFileInfo findFunction(CsmProject csmProject, String string, int n) {
        CsmFunction csmFunction = CodeModelSourceFileInfoProvider.getFunction(csmProject, string);
        if (csmFunction == null) {
            return null;
        }
        String string2 = ((Object)csmFunction.getContainingFile().getAbsolutePath()).toString();
        int n2 = csmFunction.getStartOffset();
        if (n > 0) {
            return new SourceFileInfoProvider.SourceFileInfo((CharSequence)string2, n, 0);
        }
        return new SourceFileInfoProvider.SourceFileInfo(string2, (long)n2);
    }

    private static CsmFunction getFunction(CsmProject csmProject, CharSequence charSequence) {
        Iterator iterator = CsmSelect.getFunctions((CsmProject)csmProject, (CharSequence)charSequence);
        CsmFunction csmFunction = null;
        while (iterator.hasNext()) {
            CsmFunction csmFunction2 = (CsmFunction)iterator.next();
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmFunction2)) {
                return csmFunction2;
            }
            CsmFunctionDefinition csmFunctionDefinition = csmFunction2.getDefinition();
            if (csmFunctionDefinition != null) {
                return csmFunctionDefinition;
            }
            csmFunction = csmFunction2;
        }
        return csmFunction;
    }

    private SourceFileInfoProvider.SourceFileInfo findStaticFunction(CsmProject csmProject, String string) {
        Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> map = this.getCache(csmProject);
        Set<SourceFileInfoProvider.SourceFileInfo> set = map.get(string);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    private synchronized Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> getCache(CsmProject csmProject) {
        Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> map = (Map<String, Set<SourceFileInfoProvider.SourceFileInfo>>)this.staticFileCache.get();
        if (map == null) {
            map = this.initStaticFunctions(csmProject);
            this.staticFileCache = new WeakReference<Map<String, Set<SourceFileInfoProvider.SourceFileInfo>>>(map);
        }
        return map;
    }

    private Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> initStaticFunctions(CsmProject csmProject) {
        HashMap<String, Set<SourceFileInfoProvider.SourceFileInfo>> hashMap = new HashMap<String, Set<SourceFileInfoProvider.SourceFileInfo>>();
        for (CsmFile csmFile : csmProject.getAllFiles()) {
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmFile.getDeclarations()) {
                if (!CsmKindUtilities.isFileLocalFunction((CsmObject)csmOffsetableDeclaration)) continue;
                CsmFunction csmFunction = (CsmFunction)csmOffsetableDeclaration;
                String string = ((Object)csmFunction.getQualifiedName()).toString();
                HashSet<SourceFileInfoProvider.SourceFileInfo> hashSet = (HashSet<SourceFileInfoProvider.SourceFileInfo>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<SourceFileInfoProvider.SourceFileInfo>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(new SourceFileInfoProvider.SourceFileInfo(((Object)csmFile.getAbsolutePath()).toString(), (long)csmFunction.getStartPosition().getOffset()));
            }
        }
        return hashMap;
    }
}

