/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.MultivalueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveSession {
    private SchemaModelImpl mInitialSModel;
    private String mSoughtNamespace;
    private Map<SchemaModel, Checked> mModelToChecked = new HashMap<SchemaModel, Checked>();
    private Set<SchemaModelImpl> mImported = null;
    private Set<SchemaModelImpl> mMegaImported = null;
    private MultivalueMap.BidirectionalGraph<SchemaModelImpl> mFirstIncludeGraph = null;
    private MultivalueMap.BidirectionalGraph<SchemaModelImpl> mSecondIncludeGraph = null;

    public ResolveSession(SchemaModelImpl schemaModelImpl, String string) {
        this.mInitialSModel = schemaModelImpl;
        this.mSoughtNamespace = string;
        SchemaImpl schemaImpl = this.mInitialSModel.getSchema();
        assert (schemaImpl != null);
    }

    public Checked getChecked(SchemaModel schemaModel) {
        Checked checked = this.mModelToChecked.get(schemaModel);
        if (checked == null) {
            checked = new Checked();
            this.mModelToChecked.put(schemaModel, checked);
        }
        return checked;
    }

    public Set<SchemaModelImpl> getImported() {
        if (this.mImported == null) {
            this.mImported = new HashSet<SchemaModelImpl>();
        }
        return this.mImported;
    }

    public Set<SchemaModelImpl> getMegaImported() {
        if (this.mMegaImported == null) {
            this.mMegaImported = new HashSet<SchemaModelImpl>();
        }
        return this.mMegaImported;
    }

    public MultivalueMap.BidirectionalGraph<SchemaModelImpl> getInclusionGraph(SchemaModelImpl schemaModelImpl, String string) {
        Object object;
        Set<SchemaModelImpl> set = null;
        MultivalueMap.BidirectionalGraph<SchemaModelImpl> bidirectionalGraph = null;
        if (Util.equal(string, this.mSoughtNamespace)) {
            if (this.mSecondIncludeGraph == null) {
                this.mSecondIncludeGraph = new MultivalueMap.BidirectionalGraph();
                set = this.populateInclusionGraph(this.mSoughtNamespace, this.mSecondIncludeGraph);
            }
            bidirectionalGraph = this.mSecondIncludeGraph;
        } else {
            object = this.mInitialSModel.getSchema().getTargetNamespace();
            if (Util.equal(string, object)) {
                if (this.mFirstIncludeGraph == null) {
                    this.mFirstIncludeGraph = new MultivalueMap.BidirectionalGraph();
                    set = this.populateInclusionGraph((String)object, this.mFirstIncludeGraph);
                }
                bidirectionalGraph = this.mFirstIncludeGraph;
            } else assert (false) : "Namespace can be either the sought one or equal to target namespace of the initial schema!";
        }
        object = bidirectionalGraph.getRoots(schemaModelImpl, false);
        HashSet<SchemaModelImpl> hashSet = new HashSet<SchemaModelImpl>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            SchemaModelImpl schemaModelImpl2 = (SchemaModelImpl)iterator.next();
            this.checkAllDependingModelsLoaded(schemaModelImpl2, bidirectionalGraph, set, hashSet);
        }
        return bidirectionalGraph;
    }

    private Set<SchemaModelImpl> populateInclusionGraph(String string, MultivalueMap.BidirectionalGraph<SchemaModelImpl> bidirectionalGraph) {
        List list = SchemaModelFactory.getDefault().getModels();
        HashSet<SchemaModelImpl> hashSet = new HashSet<SchemaModelImpl>();
        for (SchemaModel schemaModel : list) {
            String string2;
            Schema schema;
            if (schemaModel == null || schemaModel.getSchema() == null || (schema = schemaModel.getSchema()) == null || !Util.equal(string, string2 = schema.getTargetNamespace())) continue;
            assert (schemaModel instanceof SchemaModelImpl);
            SchemaModelImpl schemaModelImpl = (SchemaModelImpl)SchemaModelImpl.class.cast(schemaModel);
            hashSet.add(schemaModelImpl);
            Collection<Include> collection = schema.getIncludes();
            for (Include include : collection) {
                SchemaModelImpl schemaModelImpl2 = schemaModelImpl.resolve(include);
                if (schemaModelImpl2 == null) continue;
                bidirectionalGraph.put(schemaModelImpl, schemaModelImpl2);
            }
        }
        return hashSet;
    }

    private void checkAllDependingModelsLoaded(SchemaModelImpl schemaModelImpl, MultivalueMap.BidirectionalGraph<SchemaModelImpl> bidirectionalGraph, Set<SchemaModelImpl> set, Set<SchemaModelImpl> set2) {
        if (set2.contains(schemaModelImpl)) {
            return;
        }
        set2.add(schemaModelImpl);
        boolean bl = !set.contains(schemaModelImpl);
        for (SchemaModelReference schemaModelReference : schemaModelImpl.getNotImportRefrences()) {
            SchemaModelImpl schemaModelImpl2 = schemaModelImpl.resolve(schemaModelReference);
            if (schemaModelImpl2 == null) continue;
            if (bl) {
                bidirectionalGraph.put(schemaModelImpl, schemaModelImpl2);
            }
            this.checkAllDependingModelsLoaded(schemaModelImpl2, bidirectionalGraph, set, set2);
        }
    }

    public static class Checked {
        boolean itself = false;
        boolean included = false;
        boolean imports = false;

        public String toString() {
            return "inself=" + this.itself + "; included=" + this.included + "; imports=" + this.imports;
        }
    }
}

