/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.MissingResourceException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;
import org.netbeans.mobility.antext.EMapFormat;

public class PreverifyTask
extends Task {
    private static final String DEFAULT_PLATFORM_TYPE = "UEI-1.0";
    private File srcDir;
    private File destDir;
    private Path classPath;
    private String configuration;
    private File platformHome;
    private String platformType;
    private String commandLine = null;

    public void execute() throws BuildException {
        long l;
        int n;
        if (this.platformHome == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "platformHome"));
        }
        if (this.srcDir == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "srcDir"));
        }
        if (this.destDir == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "destDir"));
        }
        if (!this.platformHome.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_MissingPlatformHome", this.platformHome.toString()));
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_MissingSrcDir", this.srcDir.toString()));
        }
        if (!this.destDir.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_MissingDestDir", this.destDir.toString()));
        }
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MAX_VALUE;
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.srcDir);
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file = directoryScanner.getBasedir();
        String[] stringArray = directoryScanner.getIncludedFiles();
        long l4 = stringArray.length;
        for (n = 0; n < stringArray.length; ++n) {
            l = new File(file, stringArray[n]).lastModified();
            if (l <= l2) continue;
            l2 = l;
        }
        fileSet = new FileSet();
        fileSet.setDir(this.destDir);
        directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        file = directoryScanner.getBasedir();
        stringArray = directoryScanner.getIncludedFiles();
        for (n = 0; n < stringArray.length; ++n) {
            l = new File(file, stringArray[n]).lastModified();
            if (l >= l3) continue;
            l3 = l;
        }
        if (l3 != Long.MAX_VALUE && l2 <= l3) {
            this.log(Bundle.getMessage("MSG_PreverifiedClassesAreUpToDate", this.destDir.getAbsolutePath()), 3);
            return;
        }
        this.log(Bundle.getMessage("MSG_Preverifying", "" + l4, this.destDir.getAbsolutePath()), 2);
        if (this.platformType == null) {
            this.log(Bundle.getMessage("WARN_DefaultPlatform", DEFAULT_PLATFORM_TYPE), 1);
            this.platformType = DEFAULT_PLATFORM_TYPE;
        }
        if (Bundle.getMessage("NAME_CUSTOM").equals(this.platformType)) {
            if (this.commandLine == null) {
                this.log(Bundle.getMessage("WARN_MissingCommandLine", DEFAULT_PLATFORM_TYPE), 1);
                this.platformType = DEFAULT_PLATFORM_TYPE;
            }
        } else {
            this.commandLine = null;
        }
        if (this.commandLine == null) {
            String string;
            try {
                string = Bundle.getMessage("CFG_Preverify_" + this.platformType);
            }
            catch (MissingResourceException missingResourceException) {
                throw new BuildException(Bundle.getMessage("ERR_UnsupportedPlatform", this.platformType));
            }
            if (this.configuration != null) {
                try {
                    this.commandLine = Bundle.getMessage("CMD_Preverify_" + this.platformType + "_" + this.configuration);
                }
                catch (MissingResourceException missingResourceException) {
                    this.log(Bundle.getMessage("WARN_UnsupportedConfig", this.platformType, this.configuration, string), 1);
                    this.commandLine = Bundle.getMessage("CMD_Preverify_" + this.platformType + "_" + string);
                }
            } else {
                this.log(Bundle.getMessage("MSG_DefaultConfig", this.platformType, string), 1);
                this.commandLine = Bundle.getMessage("CMD_Preverify_" + this.platformType + "_" + string);
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("platformhome", this.platformHome.getAbsolutePath());
        if (this.classPath != null) {
            hashMap.put("classpath", this.classPath.toString());
        }
        hashMap.put("destdir", this.destDir.getAbsolutePath());
        hashMap.put("srcdir", this.srcDir.getAbsolutePath());
        hashMap.put("/", File.separator);
        this.commandLine = EMapFormat.format(this.commandLine, hashMap);
        String[] stringArray2 = Commandline.translateCommandline((String)this.commandLine);
        this.log(Bundle.getMessage("MSG_ExecCmd", this.commandLine), 3);
        for (int i = 0; i < stringArray2.length; ++i) {
            this.log(">" + stringArray2[i] + "<", 3);
        }
        try {
            Execute execute = new Execute();
            execute.setAntRun(this.getProject());
            execute.setVMLauncher(true);
            execute.setCommandline(stringArray2);
            int n2 = execute.execute();
            if (n2 != 0) {
                throw new BuildException(Bundle.getMessage("ERR_PreverifyFailed", String.valueOf(n2)));
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    public void setSrcDir(File file) {
        this.srcDir = file;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void setClassPath(Path path) {
        this.createClassPath().append(path);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public void setConfiguration(String string) {
        this.configuration = string.toUpperCase();
    }

    public void setPlatformHome(File file) {
        this.platformHome = file;
    }

    public void setPlatformType(String string) {
        this.platformType = string.toUpperCase();
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }
}

