/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class WebSampleProjectGenerator {
    public static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/web-project/3";
    public static final String JSPC_CLASSPATH = "jspc.classpath";
    static final /* synthetic */ boolean $assertionsDisabled;

    private WebSampleProjectGenerator() {
    }

    public static FileObject createProjectFromTemplate(FileObject fileObject, File file, String string) throws IOException {
        if (!($assertionsDisabled || fileObject != null && file != null && string != null)) {
            throw new AssertionError();
        }
        FileObject fileObject2 = WebSampleProjectGenerator.createProjectFolder(file);
        if (fileObject.getExt().endsWith("zip")) {
            WebSampleProjectGenerator.unzip(fileObject.getInputStream(), fileObject2);
            try {
                File file2 = FileUtil.toFile((FileObject)fileObject2.getFileObject("nbproject/project.xml"));
                Document document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, null, null);
                NodeList nodeList = document.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element element = (Element)node;
                        WebSampleProjectGenerator.replaceText(element, string);
                    }
                    WebSampleProjectGenerator.saveXml(document, fileObject2, "nbproject/project.xml");
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
            fileObject2.refresh(false);
        }
        return fileObject2;
    }

    private static FileObject createProjectFolder(File file) throws IOException {
        FileObject fileObject;
        Stack<String> stack = new Stack<String>();
        while ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            stack.push(file.getName());
            file = file.getParentFile();
        }
        while (!stack.empty()) {
            fileObject = fileObject.createFolder((String)stack.pop());
            if (!$assertionsDisabled && fileObject == null) {
                throw new AssertionError();
            }
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream inputStream, FileObject fileObject) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    private static void replaceText(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            text.setNodeValue(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document document, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    static {
        $assertionsDisabled = !WebSampleProjectGenerator.class.desiredAssertionStatus();
    }
}

