/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.keybindings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.ProfilesTracker;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyBindingSettingsImpl
extends KeyBindingSettingsFactory {
    private static final Logger LOG = Logger.getLogger(KeyBindingSettingsImpl.class.getName());
    private static final Map<MimePath, WeakReference<KeyBindingSettingsImpl>> INSTANCES = new WeakHashMap<MimePath, WeakReference<KeyBindingSettingsImpl>>();
    private MimePath mimePath;
    private PropertyChangeSupport pcs;
    private KeyBindingSettingsImpl baseKBS;
    private Listener listener;
    private String logActionName = null;
    private boolean init = false;

    public static synchronized KeyBindingSettingsImpl get(MimePath mimePath) {
        KeyBindingSettingsImpl keyBindingSettingsImpl;
        WeakReference<KeyBindingSettingsImpl> weakReference = INSTANCES.get(mimePath);
        KeyBindingSettingsImpl keyBindingSettingsImpl2 = keyBindingSettingsImpl = weakReference == null ? null : (KeyBindingSettingsImpl)weakReference.get();
        if (keyBindingSettingsImpl == null) {
            keyBindingSettingsImpl = new KeyBindingSettingsImpl(mimePath);
            INSTANCES.put(mimePath, new WeakReference<KeyBindingSettingsImpl>(keyBindingSettingsImpl));
        }
        return keyBindingSettingsImpl;
    }

    private KeyBindingSettingsImpl(MimePath mimePath) {
        this.mimePath = mimePath;
        this.pcs = new PropertyChangeSupport(this);
        String string = KeyBindingSettingsImpl.class.getName();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            if (!string2.equals("true")) {
                this.logActionName = System.getProperty(string);
            }
        } else if (mimePath.size() == 1) {
            this.logActionName = System.getProperty(string + '.' + mimePath.getMimeType(0));
        }
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.mimePath.size() > 0) {
            this.baseKBS = KeyBindingSettingsImpl.get(MimePath.EMPTY);
        }
        this.listener = new Listener(this, this.baseKBS);
    }

    private String getInternalKeymapProfile(String string) {
        ProfilesTracker profilesTracker = ProfilesTracker.get("Keybindings", "Editors");
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription == null ? string : profileDescription.getId();
    }

    @Override
    public List<MultiKeyBinding> getKeyBindings() {
        return this.getKeyBindings(EditorSettingsImpl.getInstance().getCurrentKeyMapProfile());
    }

    @Override
    public List<MultiKeyBinding> getKeyBindings(String string) {
        string = this.getInternalKeymapProfile(string);
        return Collections.unmodifiableList(new ArrayList<MultiKeyBinding>(this.getShortcuts(string, false).values()));
    }

    private Map<Collection<KeyStroke>, MultiKeyBinding> getShortcuts(String string, boolean bl) {
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get("Keybindings");
        try {
            return editorSettingsStorage.load(this.mimePath, string, bl);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return Collections.emptyMap();
        }
    }

    @Override
    public List<MultiKeyBinding> getKeyBindingDefaults(String string) {
        string = this.getInternalKeymapProfile(string);
        return Collections.unmodifiableList(new ArrayList<MultiKeyBinding>(this.getShortcuts(string, true).values()));
    }

    @Override
    public void setKeyBindings(String string, List<MultiKeyBinding> list) {
        this.init();
        string = this.getInternalKeymapProfile(string);
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get("Keybindings");
        try {
            if (list == null) {
                editorSettingsStorage.delete(this.mimePath, string, false);
            } else {
                HashMap<List, MultiKeyBinding> hashMap = new HashMap<List, MultiKeyBinding>();
                for (MultiKeyBinding multiKeyBinding : list) {
                    hashMap.put(multiKeyBinding.getKeyStrokeList(), multiKeyBinding);
                }
                this.listener.removeListeners();
                editorSettingsStorage.save(this.mimePath, string, false, hashMap);
                this.listener.addListeners();
                this.pcs.firePropertyChange(null, null, null);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void log(String string, Collection collection) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        if (string.length() != 0) {
            if (this.mimePath.size() == 1) {
                string = string + " " + this.mimePath.getMimeType(0);
            }
            string = string + " " + EditorSettingsImpl.getInstance().getCurrentKeyMapProfile();
        }
        if (collection == null) {
            LOG.fine(string + " : null");
            return;
        }
        LOG.fine(string);
        for (Object e : collection) {
            if (this.logActionName == null || !(e instanceof MultiKeyBinding)) {
                LOG.fine("  " + e);
                continue;
            }
            if (!(e instanceof MultiKeyBinding) || !this.logActionName.equals(((MultiKeyBinding)e).getActionName())) continue;
            LOG.fine("  " + e);
        }
    }

    public Object createInstanceForLookup() {
        Map<Collection<KeyStroke>, MultiKeyBinding> map;
        this.init();
        String string = this.getInternalKeymapProfile(EditorSettingsImpl.getInstance().getCurrentKeyMapProfile());
        HashMap<Collection<KeyStroke>, MultiKeyBinding> hashMap = new HashMap<Collection<KeyStroke>, MultiKeyBinding>();
        if (this.baseKBS != null) {
            map = this.baseKBS.getShortcuts(string, false);
            hashMap.putAll(map);
        }
        map = this.getShortcuts(string, false);
        hashMap.putAll(map);
        ArrayList<MultiKeyBinding> arrayList = new ArrayList<MultiKeyBinding>(hashMap.values());
        return new Immutable(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Immutable
    extends KeyBindingSettings {
        private List<MultiKeyBinding> keyBindings;

        public Immutable(List<MultiKeyBinding> list) {
            this.keyBindings = list;
        }

        public List<MultiKeyBinding> getKeyBindings() {
            return Collections.unmodifiableList(this.keyBindings);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Listener
    extends WeakReference<KeyBindingSettingsImpl>
    implements PropertyChangeListener,
    Runnable {
        private final KeyBindingSettingsFactory baseKBS;
        private final EditorSettingsStorage<Collection<KeyStroke>, MultiKeyBinding> storage;

        public Listener(KeyBindingSettingsImpl keyBindingSettingsImpl, KeyBindingSettingsFactory keyBindingSettingsFactory) {
            super(keyBindingSettingsImpl, Utilities.activeReferenceQueue());
            this.baseKBS = keyBindingSettingsFactory;
            this.storage = EditorSettingsStorage.get("Keybindings");
            this.addListeners();
        }

        private KeyBindingSettingsImpl getSettings() {
            KeyBindingSettingsImpl keyBindingSettingsImpl = (KeyBindingSettingsImpl)this.get();
            if (keyBindingSettingsImpl != null) {
                return keyBindingSettingsImpl;
            }
            this.removeListeners();
            return null;
        }

        private void addListeners() {
            EditorSettingsImpl.getInstance().addPropertyChangeListener("currentKeyMapProfile", this);
            this.storage.addPropertyChangeListener(this);
            if (this.baseKBS != null) {
                this.baseKBS.addPropertyChangeListener(this);
            }
        }

        private void removeListeners() {
            if (this.baseKBS != null) {
                this.baseKBS.removePropertyChangeListener(this);
            }
            this.storage.removePropertyChangeListener(this);
            EditorSettingsImpl.getInstance().removePropertyChangeListener("currentKeyMapProfile", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            KeyBindingSettingsImpl keyBindingSettingsImpl = this.getSettings();
            if (keyBindingSettingsImpl == null) {
                return;
            }
            keyBindingSettingsImpl.log("refresh2", Collections.EMPTY_SET);
            keyBindingSettingsImpl.pcs.firePropertyChange(null, null, null);
        }

        @Override
        public void run() {
            this.removeListeners();
        }
    }
}

