/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.groovy.support.customizer.GroovyCustomizerPanel;
import org.netbeans.modules.groovy.support.spi.GroovyFeature;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class GroovyProjectExtender
implements GroovyFeature {
    private static final String EXTENSIBLE_TARGET_NAME = "-pre-pre-compile";
    private static final String GROOVY_EXTENSION_ID = "groovy";
    private static final String GROOVY_BUILD_XSL = "org/netbeans/modules/groovy/support/resources/groovy-build.xsl";
    private static final String GROOVY_BUILD_65_XML = "org/netbeans/modules/groovy/support/resources/groovy-build-65.xml";
    private static final String GROOVY_BUILD_SAMPLE_65_XML = "org/netbeans/modules/groovy/support/resources/groovy-build-sample-65.xml";
    private static final String J2SE_PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    private static final String J2SE_EXCLUDE_PROPERTY = "build.classes.excludes";
    private static final String J2SE_DISABLE_COMPILE_ON_SAVE = "compile.on.save.unsupported.groovy";
    private static final String EXCLUSION_PATTERN = "**/*.groovy";
    private final Project project;
    private GroovyCustomizerPanel panel;

    public GroovyProjectExtender(Project project) {
        this.project = project;
    }

    public GroovyCustomizerPanel createPanel() {
        this.panel = new GroovyCustomizerPanel(this);
        return this.panel;
    }

    public GroovyCustomizerPanel getPanel() {
        return this.panel;
    }

    public boolean enableGroovy() {
        boolean bl = this.addClasspath() && this.addExcludes() && this.addBuildScript() && this.addDisableCompileOnSaveProperty();
        return bl;
    }

    public boolean disableGroovy() {
        boolean bl = this.removeClasspath() && this.removeExcludes() && this.removeBuildScript() && this.removeDisableCompileOnSaveProperty();
        return bl;
    }

    public void refreshBuildScript(boolean bl) {
        if (this.isGroovyEnabled()) {
            GeneratedFilesHelper generatedFilesHelper = new GeneratedFilesHelper(this.project.getProjectDirectory());
            URL uRL = this.getClass().getClassLoader().getResource(GROOVY_BUILD_XSL);
            try {
                FileObject fileObject;
                int n = generatedFilesHelper.getBuildScriptState("nbproject/groovy-build.xml", uRL);
                if ((4 & n) != 0 && (8 & n) != 0 && (0x10 & n) != 0 && (GroovyProjectExtender.hasBuildScriptFrom65(this.project, GROOVY_BUILD_65_XML) || GroovyProjectExtender.hasBuildScriptFrom65(this.project, GROOVY_BUILD_SAMPLE_65_XML)) && (fileObject = this.project.getProjectDirectory().getFileObject("nbproject/groovy-build.xml")) != null) {
                    fileObject.delete();
                    generatedFilesHelper.generateBuildScriptFromStylesheet("nbproject/groovy-build.xml", uRL);
                    return;
                }
                generatedFilesHelper.refreshBuildScript("nbproject/groovy-build.xml", uRL, bl);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (IllegalStateException illegalStateException) {
                Exceptions.printStackTrace((Throwable)illegalStateException);
            }
        }
    }

    public boolean isGroovyEnabled() {
        AntBuildExtender antBuildExtender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        return antBuildExtender != null && antBuildExtender.getExtension(GROOVY_EXTENSION_ID) != null;
    }

    private boolean addClasspath() {
        Library library = LibraryManager.getDefault().getLibrary("groovy-all");
        if (library != null) {
            try {
                SourceGroup[] sourceGroupArray;
                Sources sources = ProjectUtils.getSources((Project)this.project);
                for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
                }
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Exceptions.printStackTrace((Throwable)unsupportedOperationException);
            }
        }
        return false;
    }

    private boolean removeClasspath() {
        Library library = LibraryManager.getDefault().getLibrary("groovy-all");
        if (library != null) {
            try {
                SourceGroup[] sourceGroupArray;
                Sources sources = ProjectUtils.getSources((Project)this.project);
                for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
                    ProjectClassPathModifier.removeLibraries((Library[])new Library[]{library}, (FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
                }
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Exceptions.printStackTrace((Throwable)unsupportedOperationException);
            }
        }
        return false;
    }

    private boolean addExcludes() {
        try {
            EditableProperties editableProperties = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            String string = editableProperties.getProperty(J2SE_EXCLUDE_PROPERTY);
            if (!string.contains(EXCLUSION_PATTERN)) {
                editableProperties.setProperty(J2SE_EXCLUDE_PROPERTY, string + "," + EXCLUSION_PATTERN);
                GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, editableProperties);
            }
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private boolean removeExcludes() {
        try {
            EditableProperties editableProperties = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            String string = editableProperties.getProperty(J2SE_EXCLUDE_PROPERTY);
            if (string.contains(",**/*.groovy")) {
                string = string.replace(",**/*.groovy", "");
                editableProperties.setProperty(J2SE_EXCLUDE_PROPERTY, string);
                GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, editableProperties);
            }
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private boolean addBuildScript() {
        AntBuildExtender antBuildExtender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (antBuildExtender != null && antBuildExtender.getExtensibleTargets().contains(EXTENSIBLE_TARGET_NAME)) {
            AntBuildExtender.Extension extension = antBuildExtender.getExtension(GROOVY_EXTENSION_ID);
            if (extension == null) {
                FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject");
                try {
                    GeneratedFilesHelper generatedFilesHelper = new GeneratedFilesHelper(this.project.getProjectDirectory());
                    URL uRL = this.getClass().getClassLoader().getResource(GROOVY_BUILD_XSL);
                    generatedFilesHelper.generateBuildScriptFromStylesheet("nbproject/groovy-build.xml", uRL);
                    FileObject fileObject2 = fileObject.getFileObject("groovy-build", "xml");
                    extension = antBuildExtender.addExtension(GROOVY_EXTENSION_ID, fileObject2);
                    extension.addDependency(EXTENSIBLE_TARGET_NAME, "-groovy-init-macrodef-javac");
                    ProjectManager.getDefault().saveProject(this.project);
                    return true;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean removeBuildScript() {
        AntBuildExtender antBuildExtender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (antBuildExtender != null && antBuildExtender.getExtensibleTargets().contains(EXTENSIBLE_TARGET_NAME)) {
            AntBuildExtender.Extension extension = antBuildExtender.getExtension(GROOVY_EXTENSION_ID);
            if (extension != null) {
                FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject");
                try {
                    FileObject fileObject2;
                    extension.removeDependency(EXTENSIBLE_TARGET_NAME, "-groovy-init-macrodef-javac");
                    antBuildExtender.removeExtension(GROOVY_EXTENSION_ID);
                    if (fileObject != null && (fileObject2 = fileObject.getFileObject("groovy-build.xml")) != null) {
                        fileObject2.delete();
                    }
                    ProjectManager.getDefault().saveProject(this.project);
                    return true;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean addDisableCompileOnSaveProperty() {
        try {
            EditableProperties editableProperties = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            editableProperties.put(J2SE_DISABLE_COMPILE_ON_SAVE, "true");
            GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, editableProperties);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private boolean removeDisableCompileOnSaveProperty() {
        try {
            EditableProperties editableProperties = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            editableProperties.remove((Object)J2SE_DISABLE_COMPILE_ON_SAVE);
            GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, editableProperties);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private static EditableProperties getEditableProperties(final Project project, final String string) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject fileObject = project.getProjectDirectory().getFileObject(string);
                    EditableProperties editableProperties = null;
                    if (fileObject != null) {
                        InputStream inputStream = null;
                        editableProperties = new EditableProperties();
                        try {
                            inputStream = fileObject.getInputStream();
                            editableProperties.load(inputStream);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    return editableProperties;
                }
            });
        }
        catch (MutexException mutexException) {
            return null;
        }
    }

    private static void storeEditableProperties(final Project project, final String string, final EditableProperties editableProperties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    FileObject fileObject = project.getProjectDirectory().getFileObject(string);
                    if (fileObject != null) {
                        OutputStream outputStream = null;
                        try {
                            outputStream = fileObject.getOutputStream();
                            editableProperties.store(outputStream);
                        }
                        finally {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasBuildScriptFrom65(Project project, String string) throws IOException {
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/groovy-build.xml");
        if (fileObject == null) {
            return false;
        }
        URL uRL = GroovyProjectExtender.class.getClassLoader().getResource(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), "UTF-8"));
        try {
            List list = fileObject.asLines("UTF-8");
            for (String string2 : list) {
                String string3 = bufferedReader.readLine();
                if (string3 != null && string3.equals(string2)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = bufferedReader.readLine() == null;
            return bl;
        }
        finally {
            bufferedReader.close();
        }
    }
}

