/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesPlot;
import org.netbeans.modules.dlight.util.Range;

public final class TimeSeriesDataContainer {
    private final long bucketSize;
    private final Aggregation aggr;
    private final int arraySize;
    private final ArrayList<Bucket> list;
    private final boolean lastNonNull;
    private TimeSeriesPlot plot;

    public TimeSeriesDataContainer(long l, Aggregation aggregation, int n, boolean bl) {
        if (l <= 0L) {
            throw new IllegalArgumentException("bucketSize must be positive");
        }
        if (aggregation == null) {
            throw new NullPointerException("aggregation can't be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("arraySize must be positive");
        }
        this.bucketSize = l;
        this.aggr = aggregation;
        this.arraySize = n;
        this.list = new ArrayList();
        this.lastNonNull = bl;
    }

    public synchronized void put(long l, float[] fArray) {
        if (l < 0L) {
            throw new IllegalArgumentException("timestamp can't be negative");
        }
        if (fArray.length != this.arraySize) {
            throw new IllegalArgumentException("Wrong data size");
        }
        int n = (int)Math.ceil((double)l / (double)this.bucketSize);
        this.grow(n + 1);
        Bucket bucket = this.list.get(n);
        if (bucket == null) {
            bucket = new Bucket(this.aggr, fArray);
            this.list.set(n, bucket);
        } else {
            bucket.put(fArray);
        }
        if (this.plot != null) {
            int n2;
            int n3 = this.plot.calculateUpperLimit(bucket.get());
            for (n2 = this.plot.getUpperLimit(); n2 < n3; n2 *= 2) {
            }
            this.plot.setUpperLimit(n2);
        }
    }

    public synchronized float[] get(int n) {
        if (0 <= n && n < this.list.size()) {
            Bucket bucket = this.list.get(n);
            if (bucket == null) {
                if (this.lastNonNull) {
                    for (int i = n - 1; 0 <= i; --i) {
                        Bucket bucket2 = this.list.get(i);
                        if (bucket2 == null) continue;
                        return bucket2.get();
                    }
                }
                return new float[this.arraySize];
            }
            return bucket.get();
        }
        throw new IllegalArgumentException("No such bucket");
    }

    public synchronized void grow(int n) {
        if (this.list.size() < n) {
            this.list.ensureCapacity(n);
            this.list.addAll(Collections.nCopies(n - this.list.size(), null));
            if (this.plot != null) {
                this.plot.getViewportModel().setLimits(new Range((Number)0L, (Number)(1000000000L * (long)n)));
            }
        }
    }

    public int size() {
        return this.list.size();
    }

    public void setTimeSeriesPlot(TimeSeriesPlot timeSeriesPlot) {
        this.plot = timeSeriesPlot;
    }

    private static class Bucket {
        private final Aggregation aggr;
        private float[] data;
        private int count;

        public Bucket(Aggregation aggregation, float[] fArray) {
            this.aggr = aggregation;
            this.data = fArray;
            this.count = 1;
        }

        public void put(float[] fArray) {
            switch (this.aggr) {
                case FIRST: {
                    break;
                }
                case LAST: {
                    this.data = fArray;
                    break;
                }
                case SUM: {
                    for (int i = 0; i < fArray.length; ++i) {
                        int n = i;
                        this.data[n] = this.data[n] + fArray[i];
                    }
                    break;
                }
                case AVERAGE: {
                    for (int i = 0; i < fArray.length; ++i) {
                        this.data[i] = ((float)this.count * this.data[i] + fArray[i]) / (float)(++this.count);
                    }
                    break;
                }
            }
        }

        public float[] get() {
            return this.data;
        }
    }
}

