/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.registration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.registration.RegisterAction;
import org.netbeans.modules.reglib.BrowserSupport;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.reglib.NbServiceTagSupport;
import org.netbeans.modules.reglib.StatusData;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.ServiceTag;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.windows.WindowManager;

class NbConnection {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.registration.NbConnection");
    private static final String STATUS_FILE = "status.xml";
    private static StatusData status = new StatusData("unknown", 7);
    private static final RequestProcessor RP = new RequestProcessor("NetBeans Registration RP");

    private NbConnection() {
    }

    static void init() {
        if (!Boolean.getBoolean("netbeans.full.hack") && !Boolean.getBoolean("netbeans.close")) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    RP.post(new Runnable(){

                        public void run() {
                            NbConnection.checkStatus();
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkStatus() {
        LOG.log(Level.FINE, "Check registration status. Thread: " + Thread.currentThread().getName());
        File file = NbServiceTagSupport.getServiceTagDirHome();
        File file2 = new File(file, STATUS_FILE);
        if (file2.exists() && file2.length() > 0L) {
            LOG.log(Level.FINE, "Load registration status from:" + file2);
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                status = StatusData.loadFromXML((InputStream)bufferedInputStream);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error: Bad registration data \"" + file2 + "\"", iOException);
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, "Error: Cannot close reader", iOException);
                    }
                }
            }
            if (status.getStatus().equals("registered")) {
                LOG.log(Level.FINE, "Status is STATUS_REGISTERED");
                NbConnection.checkProductRegistrationStatus();
            } else if (status.getStatus().equals("never")) {
                LOG.log(Level.FINE, "Status is STATUS_NEVER");
            } else if (status.getStatus().equals("later")) {
                LOG.log(Level.FINE, "Status is STATUS_LATER");
                Date date = new Date(status.getTimestamp().getTime() + (long)status.getDelay() * 24L * 60L * 60L * 1000L);
                LOG.log(Level.FINE, "      Date timestamp:" + status.getTimestamp());
                LOG.log(Level.FINE, "Date timestamp+delay:" + date);
                Date date2 = new Date();
                LOG.log(Level.FINE, "            Date now:" + date2);
                if (date2.after(date)) {
                    status.setDelay(7);
                    NbConnection.storeStatus();
                    NbConnection.showDialog();
                }
            } else {
                LOG.log(Level.FINE, "Status is unknown");
                NbConnection.showDialog();
            }
        } else {
            NbConnection.showDialog();
        }
    }

    private static void showDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LOG.log(Level.INFO, "Method showDialog. Thread: " + Thread.currentThread().getName());
                RegisterAction registerAction = (RegisterAction)SharedClassObject.findObject(RegisterAction.class, (boolean)true);
                registerAction.showDialog();
            }
        });
    }

    private static void checkProductRegistrationStatus() {
        String string = "org/netbeans/modules/autoupdate";
        Preferences preferences = NbPreferences.root().node(string);
        int n = preferences.getInt("period", 2);
        if (n == 5) {
            return;
        }
        RegistrationData registrationData = null;
        try {
            registrationData = NbServiceTagSupport.getRegistrationData();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Cannot get registration data", iOException);
            return;
        }
        Set set = registrationData.getServiceTags();
        boolean bl = true;
        for (Object object : set) {
            bl = NbConnectionSupport.isRegistered((String)NbConnectionSupport.getRegistrationQueryHost(), (String)object.getInstanceURN());
            if (bl) continue;
            NbConnection.showDialog();
            break;
        }
        ServiceTag serviceTag = null;
        for (ServiceTag serviceTag2 : set) {
            if (!serviceTag2.getProductName().startsWith("Sun Java System Application Server")) continue;
            serviceTag = serviceTag2;
            break;
        }
        if (serviceTag != null && (bl = NbConnectionSupport.isRegistered2((String)NbConnectionSupport.getRegistrationQueryHost(), (String)serviceTag.getInstanceURN()))) {
            NbConnection.updateGFRegistrationStatus(serviceTag);
        }
    }

    private static void updateGFRegistrationStatus(ServiceTag serviceTag) {
        String string = serviceTag.getProductDefinedInstanceID();
        String[] stringArray = string.split(",");
        String string2 = "";
        for (String object : stringArray) {
            if (!object.startsWith("glassfish.home")) continue;
            int printWriter = object.indexOf("=");
            if (printWriter != -1) {
                string2 = object.substring(printWriter + 1);
                break;
            }
            return;
        }
        if (string2.length() == 0) {
            return;
        }
        File file = new File(string2 + File.separator + "lib" + File.separator + "registration" + File.separator + "servicetag-registry.xml");
        if (!file.canWrite()) {
            return;
        }
        LOG.log(Level.INFO, "Update file: " + file);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            File file2 = File.createTempFile("nbt", null, file.getParentFile());
            PrintWriter printWriter = new PrintWriter(file2, "UTF-8");
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                String bl = string3;
                if (string3.contains("NOT_REGISTERED")) {
                    bl = string3.replace("NOT_REGISTERED", "REGISTERED");
                } else if (string3.contains("ASK_FOR_REGISTRATION")) {
                    bl = string3.replace("ASK_FOR_REGISTRATION", "DONT_ASK_FOR_REGISTRATION");
                }
                printWriter.println(bl);
            }
            printWriter.flush();
            printWriter.close();
            ((InputStream)fileInputStream).close();
            file.delete();
            boolean bl = file2.renameTo(file);
            LOG.log(Level.FINE, "Did rename succeed: " + bl);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Cannot update: " + file, iOException);
        }
    }

    static void updateStatus(String string) {
        LOG.log(Level.FINE, "updateStatus status:" + string);
        if (string != null) {
            status.setStatus(string);
        }
        status.setTimestamp(new Date());
        NbConnection.storeStatus();
        if ("registered".equals(status.getStatus())) {
            try {
                NbConnection.register(NbServiceTagSupport.getRegistrationData());
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error: Cannot register product", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeStatus() {
        File file = NbServiceTagSupport.getServiceTagDirHome();
        File file2 = new File(file, STATUS_FILE);
        LOG.log(Level.FINE, "Store registration status to: " + file2);
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            status.storeToXML((OutputStream)filterOutputStream);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Cannot save status data to \"" + file2, iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, "Error: Cannot close writer", iOException);
                }
            }
        }
    }

    static void register(final RegistrationData registrationData) {
        RP.post(new Runnable(){

            public void run() {
                String string = NbServiceTagSupport.getProductId((RegistrationData)registrationData);
                LOG.log(Level.FINE, "Product registration");
                URL uRL = NbConnectionSupport.getRegistrationURL((String)registrationData.getRegistrationURN(), (String)string);
                LOG.log(Level.FINE, "POST registration data to:" + uRL);
                boolean bl = NbConnectionSupport.postRegistrationData((URL)uRL, (RegistrationData)registrationData);
                if (bl) {
                    LOG.log(Level.FINE, "Open browser with:" + uRL);
                    try {
                        NbConnection.openBrowser(uRL);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, "Error: Cannot open browser", iOException);
                    }
                } else {
                    try {
                        NbConnection.openOfflineRegisterPage(string, NbServiceTagSupport.getProductNames((RegistrationData)registrationData));
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, "Error: Cannot open browser", iOException);
                    }
                }
            }
        });
    }

    private static void openBrowser(URL uRL) throws IOException {
        if (BrowserSupport.isSupported()) {
            try {
                BrowserSupport.browse((URI)uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                InternalError internalError = new InternalError("Error in registering: " + uRISyntaxException.getMessage());
                internalError.initCause(uRISyntaxException);
                throw internalError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.log(Level.FINE, "Cannot open browser:", illegalArgumentException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOG.log(Level.FINE, "Cannot open browser:", unsupportedOperationException);
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "Cannot open browser:", iOException);
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
    }

    private static void openOfflineRegisterPage(String string, String[] stringArray) throws IOException {
        File file = NbServiceTagSupport.getRegistrationHtmlPage((String)string, (String[])stringArray);
        if (BrowserSupport.isSupported()) {
            try {
                BrowserSupport.browse((URI)file.toURI());
            }
            catch (FileNotFoundException fileNotFoundException) {
                InternalError internalError = new InternalError("Error in launching " + file + ": " + fileNotFoundException.getMessage());
                internalError.initCause(fileNotFoundException);
                throw internalError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.log(Level.FINE, "Cannot open browser:", illegalArgumentException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOG.log(Level.FINE, "Cannot open browser:", unsupportedOperationException);
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "Cannot open browser:", iOException);
                HtmlBrowser.URLDisplayer.getDefault().showURL(file.toURI().toURL());
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(file.toURI().toURL());
        }
    }
}

