/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClasspathNavigatorProviderImpl
implements NavigatorPanel {
    private JComponent panel;
    private final ExplorerManager manager = new ExplorerManager();

    public String getDisplayName() {
        return NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"NM_Classpath");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"SD_Classpath");
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            final PropertySheetView propertySheetView = new PropertySheetView();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Panel
            extends JPanel
            implements ExplorerManager.Provider,
            Lookup.Provider {
                private final Lookup lookup;

                Panel() {
                    this.lookup = ExplorerUtils.createLookup((ExplorerManager)ClasspathNavigatorProviderImpl.this.manager, (ActionMap)new ActionMap());
                    this.setLayout(new BorderLayout());
                    this.add((Component)propertySheetView, "Center");
                }

                public ExplorerManager getExplorerManager() {
                    return ClasspathNavigatorProviderImpl.this.manager;
                }

                public Lookup getLookup() {
                    return this.lookup;
                }
            }
            this.panel = new Panel();
        }
        return this.panel;
    }

    public Lookup getLookup() {
        return null;
    }

    public void panelActivated(Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            try {
                ClasspathNodeImpl classpathNodeImpl = new ClasspathNodeImpl(fileObject);
                this.manager.setRootContext((Node)classpathNodeImpl);
                this.manager.setSelectedNodes(new Node[]{classpathNodeImpl});
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
    }

    public void panelDeactivated() {
        this.manager.setRootContext((Node)new AbstractNode(Children.LEAF));
    }

    private static final class ClasspathNodeImpl
    extends FilterNode {
        private final FileObject file;

        public ClasspathNodeImpl(FileObject fileObject) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)fileObject).getNodeDelegate(), FilterNode.Children.LEAF);
            this.file = fileObject;
        }

        public Node.PropertySet[] getPropertySets() {
            Sheet sheet = new Sheet();
            Sheet.Set set = new Sheet.Set();
            set.setName("classpaths");
            set.setDisplayName(NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"LBL_JavaNode_sheet_classpaths"));
            set.setShortDescription(NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_sheet_classpaths"));
            set.put(new Node.Property[]{new ClasspathProperty("classpath/compile", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/source", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_source_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_source_classpath")), new ClasspathProperty("classpath/execute", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_boot_classpath")), new ClasspathProperty("classpath/compile", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_compile_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_compile_classpath_tr")), new ClasspathProperty("classpath/source", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_source_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_source_classpath_tr")), new ClasspathProperty("classpath/execute", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_execute_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_execute_classpath_tr")), new ClasspathProperty("classpath/boot", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_boot_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_boot_classpath_tr"))});
            sheet.put(set);
            return sheet.toArray();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ClasspathProperty
        extends PropertySupport.ReadOnly<String> {
            private final String id;
            private final boolean translate;

            public ClasspathProperty(String string, boolean bl, String string2, String string3) {
                super(string + (bl ? "_tr" : ""), String.class, string2, string3);
                this.id = string;
                this.translate = bl;
                this.setValue("oneline", false);
            }

            public String getValue() {
                ClassPath classPath = ClassPath.getClassPath((FileObject)ClasspathNodeImpl.this.file, (String)this.id);
                if (classPath != null) {
                    if (this.translate) {
                        classPath = "classpath/source".equals(this.id) ? CacheClassPath.forSourcePath((ClassPath)classPath) : CacheClassPath.forClassPath((ClassPath)classPath);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    for (ClassPath.Entry entry : classPath.entries()) {
                        URL uRL = entry.getURL();
                        String string = uRL.toExternalForm();
                        if (uRL.getProtocol().equals("file")) {
                            string = new File(URI.create(string)).getAbsolutePath();
                        } else if (uRL.getProtocol().equals("jar") && string.endsWith("!/")) {
                            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                            assert (uRL2 != null) : uRL;
                            if (uRL2.getProtocol().equals("file")) {
                                string = new File(URI.create(uRL2.toExternalForm())).getAbsolutePath();
                            }
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append('\n');
                        }
                        stringBuffer.append(string);
                    }
                    return stringBuffer.toString();
                }
                return NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"LBL_JavaNode_classpath_unknown");
            }
        }
    }
}

